/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.RutaLiteralMatcher;
import org.apache.uima.ruta.rule.RutaMatcher;
import org.apache.uima.ruta.rule.RutaRuleElement;
import org.apache.uima.ruta.rule.RutaTypeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RutaDisjunctiveMatcher
implements RutaMatcher {
    private final List<RutaExpression> expressions;
    private List<RutaMatcher> matchers;

    public RutaDisjunctiveMatcher(List<RutaExpression> expressions) {
        this.expressions = expressions;
        this.matchers = new ArrayList<RutaMatcher>();
        for (RutaExpression each : expressions) {
            if (each instanceof TypeExpression) {
                this.matchers.add(new RutaTypeMatcher((TypeExpression)each));
                continue;
            }
            if (!(each instanceof StringExpression)) continue;
            this.matchers.add(new RutaLiteralMatcher((StringExpression)each));
        }
    }

    @Override
    public Collection<AnnotationFS> getMatchingAnnotations(RutaStream stream, RutaBlock parent) {
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        for (RutaMatcher each : this.matchers) {
            result.addAll(each.getMatchingAnnotations(stream, parent));
        }
        return result;
    }

    @Override
    public boolean match(AnnotationFS annotation, RutaStream stream, RutaBlock parent) {
        for (RutaMatcher each : this.matchers) {
            boolean match = each.match(annotation, stream, parent);
            if (!match) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Type> getTypes(RutaBlock parent, RutaStream stream) {
        ArrayList<Type> result = new ArrayList<Type>();
        for (RutaMatcher each : this.matchers) {
            result.addAll(each.getTypes(parent, stream));
        }
        return result;
    }

    @Override
    public RutaExpression getExpression() {
        return null;
    }

    @Override
    public int estimateAnchors(RutaBlock parent, RutaStream stream) {
        int result = 0;
        for (RutaMatcher each : this.matchers) {
            result += each.estimateAnchors(parent, stream);
        }
        return result;
    }

    @Override
    public Collection<AnnotationFS> getAnnotationsAfter(RutaRuleElement ruleElement, AnnotationFS annotation, RutaStream stream, RutaBlock parent) {
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        for (RutaMatcher each : this.matchers) {
            result.addAll(each.getAnnotationsAfter(ruleElement, annotation, stream, parent));
        }
        return result;
    }

    @Override
    public Collection<AnnotationFS> getAnnotationsBefore(RutaRuleElement ruleElement, AnnotationFS annotation, RutaStream stream, RutaBlock parent) {
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        for (RutaMatcher each : this.matchers) {
            result.addAll(each.getAnnotationsBefore(ruleElement, annotation, stream, parent));
        }
        return result;
    }

    public List<RutaExpression> getExpressions() {
        return this.expressions;
    }

    public String toString() {
        return this.matchers.toString();
    }
}

