/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.core.packages;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.uima.ruta.ide.RutaIdePlugin;
import org.apache.uima.ruta.ide.core.packages.DLTKRutaHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PackagesManager {
    private static final String DEPENDENCY_TAG = "dependency";
    private static final String INTERPRETER_TAG = "interpreter";
    private static final String VALUE_ATTR = "value";
    private static final String PACKAGES_FILE = "packages.txt";
    private static final String PACKAGES_TAG = "packages";
    private static final String PACKAGE_TAG = "package";
    private static final String INTERPRETER_ATTR = "interpreter";
    private static final String NAME_ATTR = "name";
    private static final String PATH_TAG = "path";
    private static PackagesManager manager;
    private Map packages = new HashMap();
    private Map interpreterToPackages = new HashMap();
    private Map packsWithDeps = new HashMap();

    public static PackagesManager getInstance() {
        if (manager == null) {
            manager = new PackagesManager();
        }
        return manager;
    }

    private PackagesManager() {
        this.initialize();
    }

    private void initialize() {
        block9: {
            IPath packagesPath = RutaIdePlugin.getDefault().getStateLocation().append(PACKAGES_FILE);
            File packagesFile = packagesPath.toFile();
            if (packagesFile.exists()) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.parse(new BufferedInputStream(new FileInputStream(packagesFile), 2048));
                    this.populate(document.getDocumentElement());
                }
                catch (ParserConfigurationException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
                catch (FileNotFoundException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
                catch (SAXException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    if (!DLTKCore.DEBUG) break block9;
                    e.printStackTrace();
                }
            }
        }
    }

    private void save() {
        block8: {
            IPath packagesPath = RutaIdePlugin.getDefault().getStateLocation().append(PACKAGES_FILE);
            File packagesFile = packagesPath.toFile();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.newDocument();
                this.save(document);
                FileOutputStream fos = new FileOutputStream(packagesFile, false);
                BufferedOutputStream bos = new BufferedOutputStream(fos, 2048);
                TransformerFactory serFactory = TransformerFactory.newInstance();
                Transformer transformer = serFactory.newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                DOMSource source = new DOMSource(document);
                StreamResult outputTarget = new StreamResult(bos);
                transformer.transform(source, outputTarget);
                bos.close();
                fos.close();
            }
            catch (ParserConfigurationException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (FileNotFoundException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (TransformerException e) {
                if (!DLTKCore.DEBUG) break block8;
                e.printStackTrace();
            }
        }
    }

    private synchronized void save(Document doc) {
        Element packagesElement = doc.createElement(PACKAGES_TAG);
        doc.appendChild(packagesElement);
        for (PackageKey key : this.packages.keySet()) {
            Element packageElement = doc.createElement(PACKAGE_TAG);
            packageElement.setAttribute(NAME_ATTR, key.getPackageName());
            packageElement.setAttribute("interpreter", key.getInterpreterPath());
            PackageInformation info = (PackageInformation)this.packages.get(key);
            Set paths = info.getPaths();
            for (IPath path : paths) {
                Element pathElement = doc.createElement(PATH_TAG);
                pathElement.setAttribute(VALUE_ATTR, path.toOSString());
                packageElement.appendChild(pathElement);
            }
            Set deps = info.getDependencies();
            for (String pkgName : deps) {
                Element pkgElement = doc.createElement(DEPENDENCY_TAG);
                pkgElement.setAttribute(NAME_ATTR, pkgName);
                packageElement.appendChild(pkgElement);
            }
            packagesElement.appendChild(packageElement);
        }
        for (String interpreter : this.interpreterToPackages.keySet()) {
            Element interpreterElement = doc.createElement("interpreter");
            interpreterElement.setAttribute(NAME_ATTR, interpreter);
            Set pkgs = (Set)this.interpreterToPackages.get(interpreter);
            for (String pkgName : pkgs) {
                Element pathElement = doc.createElement(PACKAGE_TAG);
                pathElement.setAttribute(VALUE_ATTR, pkgName);
                interpreterElement.appendChild(pathElement);
            }
            packagesElement.appendChild(interpreterElement);
        }
    }

    private synchronized void populate(Element documentElement) {
        NodeList childNodes = documentElement.getChildNodes();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Element e;
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equalsIgnoreCase(PACKAGE_TAG)) {
                e = (Element)child;
                String packageName = e.getAttribute(NAME_ATTR);
                String interpreter = e.getAttribute("interpreter");
                PackageInformation packageInfo = new PackageInformation();
                NodeList childrens = e.getChildNodes();
                for (int j = 0; j < childrens.getLength(); ++j) {
                    Node path = childrens.item(j);
                    if (path.getNodeType() != 1) continue;
                    if (path.getNodeName().equalsIgnoreCase(PATH_TAG)) {
                        String pathValue = ((Element)path).getAttribute(VALUE_ATTR);
                        packageInfo.getPaths().add(new Path(pathValue));
                        continue;
                    }
                    if (!path.getNodeName().equalsIgnoreCase(DEPENDENCY_TAG)) continue;
                    String pkgName = ((Element)path).getAttribute(NAME_ATTR);
                    packageInfo.getDependencies().add(pkgName);
                }
                this.packages.put(this.makeKey(packageName, interpreter), packageInfo);
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("interpreter")) continue;
            e = (Element)child;
            String interpreter = e.getAttribute(NAME_ATTR);
            NodeList paths = e.getChildNodes();
            HashSet<String> packagesSet = new HashSet<String>();
            for (int j = 0; j < paths.getLength(); ++j) {
                Node packageNode = paths.item(j);
                if (packageNode.getNodeType() != 1 || !packageNode.getNodeName().equalsIgnoreCase(PACKAGE_TAG)) continue;
                String packageNameValue = ((Element)packageNode).getAttribute(VALUE_ATTR);
                packagesSet.add(packageNameValue);
            }
            this.interpreterToPackages.put(interpreter, packagesSet);
        }
    }

    private PackageKey makeKey(String packageName, String interpreter) {
        PackageKey key = new PackageKey();
        key.setPackageName(packageName);
        key.setInterpreterPath(interpreter);
        return key;
    }

    public synchronized IPath[] getPathsForPackage(IInterpreterInstall install, String packageName) {
        PackageKey key = this.makeKey(packageName, this.getInterpreterKey(install));
        if (this.packages.containsKey(key)) {
            PackageInformation info = (PackageInformation)this.packages.get(key);
            Set els = info.getPaths();
            return els.toArray(new IPath[els.size()]);
        }
        DLTKRutaHelper.RutaPackage[] srcs = DLTKRutaHelper.getSrcs(install.getExecEnvironment(), install.getInstallLocation(), install.getEnvironmentVariables(), packageName);
        PackageInformation resultInfo = null;
        for (int i = 0; i < srcs.length; ++i) {
            Set paths2 = srcs[i].getPaths();
            PackageKey okey = this.makeKey(srcs[i].getName(), this.getInterpreterKey(install));
            PackageInformation info = this.packages.containsKey(okey) ? (PackageInformation)this.packages.get(okey) : new PackageInformation();
            info.getPaths().addAll(paths2);
            info.getDependencies().addAll(srcs[i].getDependencies());
            this.packages.put(okey, info);
            if (!okey.equals(key)) continue;
            resultInfo = info;
        }
        if (resultInfo == null) {
            this.packages.put(key, new PackageInformation());
            return new IPath[0];
        }
        HashSet resultPaths = new HashSet();
        resultPaths.addAll(resultInfo.getPaths());
        this.save();
        return resultPaths.toArray(new IPath[resultPaths.size()]);
    }

    public synchronized Map getDependencies(String pkgName, IInterpreterInstall install) {
        HashSet checkedPackages = new HashSet();
        HashMap packagesSet = new HashMap();
        PackageKey key = this.makeKey(pkgName, install);
        PackageInformation info = (PackageInformation)this.packages.get(key);
        if (info != null) {
            this.traverseDependencies(packagesSet, checkedPackages, info, install);
        }
        return packagesSet;
    }

    private PackageKey makeKey(String pkgName, IInterpreterInstall install) {
        return this.makeKey(pkgName, this.getInterpreterKey(install));
    }

    private synchronized void traverseDependencies(Map packagesSet, Set checkedPackages, PackageInformation resultInfo, IInterpreterInstall install) {
        Set dependencies = resultInfo.getDependencies();
        for (String pkgName : dependencies) {
            if (checkedPackages.contains(pkgName)) continue;
            checkedPackages.add(pkgName);
            PackageKey pkgKey = this.makeKey(pkgName, this.getInterpreterKey(install));
            if (!this.packages.containsKey(pkgKey)) continue;
            PackageInformation depInfo = (PackageInformation)this.packages.get(pkgKey);
            packagesSet.put(pkgName, depInfo);
            this.traverseDependencies(packagesSet, checkedPackages, depInfo, install);
        }
    }

    public synchronized Set getPackageNames(IInterpreterInstall install) {
        String key = this.getInterpreterKey(install);
        if (this.interpreterToPackages.containsKey(key)) {
            Set set = (Set)this.interpreterToPackages.get(key);
            return set;
        }
        Set packs = DLTKRutaHelper.getPackages(install);
        this.interpreterToPackages.put(key, packs);
        this.save();
        return packs;
    }

    private String getInterpreterKey(IInterpreterInstall install) {
        if (install == null) {
            return "";
        }
        return install.getInstallLocation().toOSString() + ":" + install.getEnvironment().getId();
    }

    private String getInterpreterProjectKey(IInterpreterInstall install, String projectName) {
        return "internal|||" + projectName + "|||" + this.getInterpreterKey(install);
    }

    public Set getInternalPackageNames(IInterpreterInstall install, IScriptProject project) {
        return this.getInternalPackageNames(install, project.getElementName());
    }

    public Set getInternalPackageNames(IInterpreterInstall install, IProject project) {
        return this.getInternalPackageNames(install, project.getName());
    }

    public synchronized Set getInternalPackageNames(IInterpreterInstall install, String projectName) {
        String key = this.getInterpreterProjectKey(install, projectName);
        if (this.interpreterToPackages.containsKey(key)) {
            return (Set)this.interpreterToPackages.get(key);
        }
        return Collections.EMPTY_SET;
    }

    public synchronized void setInternalPackageNames(IInterpreterInstall install, IScriptProject project, Set names) {
        String key = this.getInterpreterProjectKey(install, project.getElementName());
        this.interpreterToPackages.put(key, new HashSet(names));
        this.save();
    }

    public synchronized IPath[] getPathsForPackages(IInterpreterInstall install, Set packagesInBuild) {
        StringBuffer buf = new StringBuffer();
        String[] pkgs = packagesInBuild.toArray(new String[packagesInBuild.size()]);
        for (int i = 0; i < pkgs.length; ++i) {
            buf.append(pkgs[i]).append(" ");
        }
        PackageKey key = this.makeKey(buf.toString(), this.getInterpreterKey(install));
        if (this.packages.containsKey(key)) {
            PackageInformation info = (PackageInformation)this.packages.get(key);
            Set paths = info.getPaths();
            return paths.toArray(new IPath[paths.size()]);
        }
        DLTKRutaHelper.RutaPackage[] srcs = DLTKRutaHelper.getSrcs(install.getExecEnvironment(), install.getInstallLocation(), install.getEnvironmentVariables(), buf.toString());
        HashSet result = new HashSet();
        if (srcs == null) {
            return new IPath[0];
        }
        for (int i = 0; i < srcs.length; ++i) {
            Set paths2 = srcs[i].getPaths();
            PackageKey okey = this.makeKey(srcs[i].getName(), this.getInterpreterKey(install));
            PackageInformation info = null;
            info = this.packages.containsKey(okey) ? (PackageInformation)this.packages.get(okey) : new PackageInformation();
            result.addAll(paths2);
            info.getPaths().addAll(paths2);
            info.getDependencies().addAll(srcs[i].getDependencies());
            this.packages.put(okey, info);
        }
        PackageInformation info = new PackageInformation();
        info.getPaths().addAll(result);
        this.packages.put(key, info);
        for (int i = 0; i < pkgs.length; ++i) {
            PackageKey lkey = this.makeKey(pkgs[i], this.getInterpreterKey(install));
            if (this.packages.containsKey(lkey)) continue;
            this.packages.put(lkey, new PackageInformation());
        }
        this.save();
        return result.toArray(new IPath[result.size()]);
    }

    public IPath[] getAllPaths(String pkgName, IInterpreterInstall install) {
        HashSet<IPath> result = new HashSet<IPath>();
        IPath[] paths = this.getPathsForPackage(install, pkgName);
        result.addAll(Arrays.asList(paths));
        Map dependencies = this.getDependencies(pkgName, install);
        for (String packageName : dependencies.keySet()) {
            PackageInformation info = (PackageInformation)dependencies.get(packageName);
            result.addAll(info.getPaths());
        }
        return result.toArray(new IPath[result.size()]);
    }

    public synchronized void removeInterprterInfo(IInterpreterInstall install) {
        String interpreterPath = this.getInterpreterKey(install);
        this.interpreterToPackages.remove(interpreterPath);
        Iterator iterator = this.packages.keySet().iterator();
        while (iterator.hasNext()) {
            PackageKey key = (PackageKey)iterator.next();
            String path = key.getInterpreterPath();
            if (!path.equals(interpreterPath)) continue;
            iterator.remove();
        }
        this.save();
    }

    public synchronized void clearCache() {
        this.interpreterToPackages.clear();
        this.packages.clear();
        this.packsWithDeps.clear();
        this.save();
    }

    public IPath[] getPathsForPackageWithDeps(IInterpreterInstall install, String name) {
        HashSet<IPath> result = new HashSet<IPath>();
        IPath[] paths = this.getPathsForPackage(install, name);
        result.addAll(Arrays.asList(paths));
        Map dependencies = this.getDependencies(name, install);
        for (String pkgName : dependencies.keySet()) {
            result.addAll(Arrays.asList(this.getPathsForPackage(install, pkgName)));
        }
        return result.toArray(new IPath[result.size()]);
    }

    public IPath[] getPathsForPackagesWithDeps(IInterpreterInstall install, Set packagesSet) {
        String pkey = this.makePKey(packagesSet);
        if (this.packsWithDeps.containsKey(pkey)) {
            return (IPath[])this.packsWithDeps.get(pkey);
        }
        HashSet<IPath> result = new HashSet<IPath>();
        IPath[] paths = this.getPathsForPackages(install, packagesSet);
        result.addAll(Arrays.asList(paths));
        for (String name : packagesSet) {
            Map dependencies = this.getDependencies(name, install);
            for (String pkgName : dependencies.keySet()) {
                result.addAll(Arrays.asList(this.getPathsForPackage(install, pkgName)));
            }
        }
        IPath[] array = result.toArray(new IPath[result.size()]);
        this.packsWithDeps.put(pkey, array);
        return array;
    }

    private String makePKey(Set packagesSet) {
        StringBuffer buffer = new StringBuffer();
        ArrayList l = new ArrayList();
        l.addAll(packagesSet);
        Collections.sort(l);
        for (String object : l) {
            buffer.append(object);
        }
        return buffer.toString();
    }

    public static class PackageInformation {
        private final Set paths = new HashSet();
        private final Set dependencies = new HashSet();

        public Set getPaths() {
            return this.paths;
        }

        public Set getDependencies() {
            return this.dependencies;
        }
    }

    private static class PackageKey {
        private String packageName;
        private String interpreterPath;

        private PackageKey() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.interpreterPath == null ? 0 : this.interpreterPath.hashCode());
            result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PackageKey other = (PackageKey)obj;
            if (this.interpreterPath == null ? other.interpreterPath != null : !this.interpreterPath.equals(other.interpreterPath)) {
                return false;
            }
            return !(this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName));
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getInterpreterPath() {
            return this.interpreterPath;
        }

        public void setInterpreterPath(String interpreterPath) {
            this.interpreterPath = interpreterPath;
        }
    }
}

