/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.core.packages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.ruta.ide.RutaIdeCorePlugin;
import org.apache.uima.ruta.ide.core.CodeModel;
import org.apache.uima.ruta.ide.core.packages.Messages;
import org.apache.uima.ruta.ide.core.packages.PackagesManager;
import org.apache.uima.ruta.ide.core.packages.RutaBuildPathPackageCollector;
import org.apache.uima.ruta.ide.parser.ast.RutaPackageDeclaration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemSeverities;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.builder.IBuildChange;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension2;
import org.eclipse.dltk.core.builder.IBuildState;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.osgi.util.NLS;

public class RutaCheckBuilder
implements IBuildParticipant,
IBuildParticipantExtension,
IBuildParticipantExtension2 {
    private final IScriptProject project;
    private final IInterpreterInstall install;
    private final PackagesManager manager = PackagesManager.getInstance();
    private final RutaBuildPathPackageCollector packageCollector = new RutaBuildPathPackageCollector();
    private final Map codeModels = new HashMap();
    private final Map resourceToModuleInfos = new HashMap();
    private final Set knownPackageNames;
    private final Set buildpath;
    private int buildType;

    public RutaCheckBuilder(IScriptProject project) throws CoreException, IllegalStateException {
        this.project = project;
        this.install = ScriptRuntime.getInterpreterInstall((IScriptProject)project);
        if (this.install == null) {
            throw new IllegalStateException(NLS.bind((String)Messages.RutaCheckBuilder_interpreterNotFound, (Object)project.getElementName()));
        }
        this.knownPackageNames = this.manager.getPackageNames(this.install);
        this.buildpath = RutaCheckBuilder.getBuildpath(project);
    }

    public boolean beginBuild(int buildType) {
        this.buildType = buildType;
        if (buildType != 1) {
            this.packageCollector.getPackagesProvided().addAll(this.manager.getInternalPackageNames(this.install, this.project));
        }
        this.loadProvidedPackagesFromRequiredProjects();
        return true;
    }

    private void loadProvidedPackagesFromRequiredProjects() {
        IBuildpathEntry[] resolvedBuildpath;
        try {
            resolvedBuildpath = this.project.getResolvedBuildpath(true);
        }
        catch (ModelException e) {
            RutaIdeCorePlugin.error(e);
            return;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        for (int i = 0; i < resolvedBuildpath.length; ++i) {
            IPath path;
            IProject project;
            IBuildpathEntry entry = resolvedBuildpath[i];
            if (entry.getEntryKind() != 2 || !(project = workspaceRoot.getProject((path = entry.getPath()).lastSegment())).exists()) continue;
            this.packageCollector.getPackagesProvided().addAll(this.manager.getInternalPackageNames(this.install, project));
        }
    }

    public void buildExternalModule(IBuildContext context) throws CoreException {
        ModuleDeclaration ast = (ModuleDeclaration)context.get(IBuildContext.ATTR_MODULE_DECLARATION);
        if (ast != null) {
            this.packageCollector.getRequireDirectives().clear();
            this.packageCollector.process(ast);
        }
    }

    public void build(IBuildContext context) throws CoreException {
        ModuleDeclaration ast = (ModuleDeclaration)context.get(ModuleDeclaration.class.getName());
        if (ast == null) {
            return;
        }
        this.packageCollector.getRequireDirectives().clear();
        this.packageCollector.process(ast);
        if (!this.packageCollector.getRequireDirectives().isEmpty()) {
            this.resourceToModuleInfos.put(context.getSourceModule(), new ModuleInfo(context.getProblemReporter(), new ArrayList(this.packageCollector.getRequireDirectives())));
        }
    }

    public void endBuild(IProgressMonitor monitor) {
        if (this.buildType != 10) {
            this.manager.setInternalPackageNames(this.install, this.project, this.packageCollector.getPackagesProvided());
        }
        monitor.subTask(Messages.RutaCheckBuilder_retrievePackages);
        Set requiredPackages = this.packageCollector.getPackagesRequired();
        if (!requiredPackages.isEmpty()) {
            this.manager.getPathsForPackages(this.install, requiredPackages);
            this.manager.getPathsForPackagesWithDeps(this.install, requiredPackages);
        }
        int remainingWork = this.resourceToModuleInfos.size();
        for (Map.Entry entry : this.resourceToModuleInfos.entrySet()) {
            ISourceModule module = (ISourceModule)entry.getKey();
            ModuleInfo info = (ModuleInfo)entry.getValue();
            monitor.subTask(NLS.bind((String)Messages.RutaCheckBuilder_processing, (Object)module.getElementName(), (Object)Integer.toString(remainingWork)));
            this.codeModels.clear();
            --remainingWork;
        }
    }

    private CodeModel getCodeModel(ISourceModule module) {
        CodeModel model = (CodeModel)this.codeModels.get(module);
        if (model == null) {
            try {
                model = new CodeModel(module.getSource());
                this.codeModels.put(module, model);
            }
            catch (ModelException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        return model;
    }

    private static Set getBuildpath(IScriptProject project) {
        IBuildpathEntry[] resolvedBuildpath;
        try {
            resolvedBuildpath = project.getResolvedBuildpath(true);
        }
        catch (ModelException e1) {
            RutaIdeCorePlugin.error(e1);
            return Collections.EMPTY_SET;
        }
        HashSet<IPath> buildpath = new HashSet<IPath>();
        for (int i = 0; i < resolvedBuildpath.length; ++i) {
            IBuildpathEntry entry = resolvedBuildpath[i];
            if (entry.getEntryKind() != 1 || !entry.isExternal()) continue;
            buildpath.add(EnvironmentPathUtils.getLocalPath((IPath)entry.getPath()));
        }
        return buildpath;
    }

    private void reportPackageProblem(RutaPackageDeclaration pkg, IProblemReporter reporter, ISourceModule module, String message, String pkgName) {
        CodeModel model = this.getCodeModel(module);
        if (model == null) {
            return;
        }
        reporter.reportProblem((IProblem)new DefaultProblem(message, 0x10000001, new String[]{pkgName}, ProblemSeverities.Error, pkg.sourceStart(), pkg.sourceEnd(), model.getLineNumber(pkg.sourceStart(), pkg.sourceEnd())));
    }

    private void checkPackage(ISourceModule module, RutaPackageDeclaration pkg, IProblemReporter reporter) {
        String packageName = pkg.getName();
        if (this.packageCollector.getPackagesProvided().contains(packageName)) {
            return;
        }
        if (!RutaCheckBuilder.isValidPackageName(packageName)) {
            return;
        }
        if (!this.knownPackageNames.contains(packageName)) {
            this.reportPackageProblem(pkg, reporter, module, NLS.bind((String)Messages.RutaCheckBuilder_unknownPackage, (Object)packageName), packageName);
            return;
        }
        if (this.checkPackage(packageName)) {
            this.reportPackageProblem(pkg, reporter, module, NLS.bind((String)Messages.RutaCheckBuilder_unresolvedDependencies, (Object)packageName), packageName);
            return;
        }
        Set dependencies = this.manager.getDependencies(packageName, this.install).keySet();
        for (String pkgName : dependencies) {
            if (!this.checkPackage(pkgName)) continue;
            this.reportPackageProblem(pkg, reporter, module, NLS.bind((String)Messages.RutaCheckBuilder_unresolvedDependencies, (Object)packageName), packageName);
            return;
        }
    }

    static boolean isValidPackageName(String packageName) {
        return packageName != null && packageName.length() != 0 && packageName.indexOf(36) == -1 && packageName.indexOf(91) == -1 && packageName.indexOf(93) == -1;
    }

    private boolean checkPackage(String packageName) {
        if (this.packageCollector.getPackagesProvided().contains(packageName)) {
            return false;
        }
        return RutaCheckBuilder.isOnBuildpath(this.buildpath, this.manager.getPathsForPackage(this.install, packageName));
    }

    private static boolean isOnBuildpath(Set buildpath, IPath path) {
        if (!buildpath.contains(path)) {
            for (IPath pp : buildpath) {
                if (!pp.isPrefixOf(path)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean isOnBuildpath(Set buildpath, IPath[] paths) {
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                IPath path = paths[i];
                if (RutaCheckBuilder.isOnBuildpath(buildpath, path)) continue;
                return true;
            }
        }
        return false;
    }

    public void prepare(IBuildChange buildChange, IBuildState buildState) throws CoreException {
    }

    private static class ModuleInfo {
        final List requireDirectives;
        final IProblemReporter reporter;

        public ModuleInfo(IProblemReporter reporter, List requireDirectives) {
            this.reporter = reporter;
            this.requireDirectives = requireDirectives;
        }
    }
}

