/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.lp2;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.textruler.TextRulerPlugin;
import org.apache.uima.ruta.textruler.core.TextRulerAnnotation;
import org.apache.uima.ruta.textruler.core.TextRulerBasicLearner;
import org.apache.uima.ruta.textruler.core.TextRulerExample;
import org.apache.uima.ruta.textruler.core.TextRulerExampleDocument;
import org.apache.uima.ruta.textruler.core.TextRulerRule;
import org.apache.uima.ruta.textruler.core.TextRulerRuleList;
import org.apache.uima.ruta.textruler.core.TextRulerShiftExample;
import org.apache.uima.ruta.textruler.core.TextRulerStatisticsCollector;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.extension.TextRulerLearner;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerDelegate;
import org.apache.uima.ruta.textruler.learner.lp2.LP2CurrentBestRulesQueue;
import org.apache.uima.ruta.textruler.learner.lp2.LP2Rule;
import org.apache.uima.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicLP2
extends TextRulerBasicLearner {
    public static final String WINDOW_SIZE_KEY = "windowSize";
    public static final String CURRENT_BEST_RULES_SIZE_KEY = "currentBestRulesSize";
    public static final String CURRENT_CONTEXTUAL_RULES_SIZE_KEY = "currentContextualRulesSize";
    public static final String MIN_COVERED_POSITIVES_PER_RULE_KEY = "minCoveredPositivesPerRule";
    public static final String MAX_ERROR_THRESHOLD_KEY = "maxErrorThreshold";
    public static final int STANDARD_WINDOW_SIZE = 2;
    public static final int STANDARD_MAX_CURRENT_BEST_RULES_COUNT = 4;
    public static final int STANDARD_MAX_CONTEXTUAL_RULES_COUNT = 4;
    public static final int STANDARD_MIN_COVERED_POSITIVES_PER_RULE = 1;
    public static final float STANDARD_MAX_ERROR_THRESHOLD = 0.1f;
    public static final String CORRECTION_ANNOTATION_NAME = "lp2shift";
    private static final int STANDARD_SHIFT_SIZE = 2;
    protected int maxCurrentBestRulesCount = 4;
    protected int maxCurrentContextualRulesCount = 4;
    protected int windowSize = 2;
    protected int shiftSize = 2;
    protected int minCoveredPositives = 1;
    protected float maxErrorThreshold = 0.1f;
    protected List<TextRulerExample> examples;
    protected Set<TextRulerExample> coveredExamples;
    protected Map<String, Integer> slotMaximumTokenCountMap = new TreeMap<String, Integer>();
    protected LP2CurrentBestRulesQueue currentBestRules;
    protected LP2CurrentBestRulesQueue currentContextualRules;
    protected Map<String, TextRulerRuleList> bestRulesPoolMap = new TreeMap<String, TextRulerRuleList>();
    protected Map<String, TextRulerRuleList> contextRulesPoolMap = new TreeMap<String, TextRulerRuleList>();
    protected Map<String, String> leftBoundaryBestRulesMap = new TreeMap<String, String>();
    protected Map<String, String> rightBoundaryBestRulesMap = new TreeMap<String, String>();
    protected Map<String, String> leftBoundaryContextualRulesMap = new TreeMap<String, String>();
    protected Map<String, String> rightBoundaryContextualRulesMap = new TreeMap<String, String>();

    public BasicLP2(String inputDir, String prePropTMFile, String tmpDir, String[] slotNames, Set<String> filterSet, boolean skip, TextRulerLearnerDelegate delegate) {
        super(inputDir, prePropTMFile, tmpDir, slotNames, filterSet, skip, delegate);
        this.supportBoundaries = true;
    }

    protected TextRulerRuleList learnTaggingRules(TextRulerTarget target, TextRulerRuleList contextualRules) {
        if (target.type == TextRulerTarget.MLTargetType.SINGLE_LEFT_BOUNDARY) {
            this.sendStatusUpdateToDelegate("Creating Left-Boundary Examples...", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
        } else if (target.type == TextRulerTarget.MLTargetType.SINGLE_RIGHT_BOUNDARY) {
            this.sendStatusUpdateToDelegate("Creating Right-Boundary Examples...", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
        } else if (target.type == TextRulerTarget.MLTargetType.SINGLE_LEFT_CORRECTION) {
            this.sendStatusUpdateToDelegate("Creating Left Correction Examples...", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
        } else {
            this.sendStatusUpdateToDelegate("Creating Right Correction Examples...", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
        }
        this.exampleDocuments.clearCurrentExamples();
        this.exampleDocuments.createExamplesForTarget(target);
        this.examples = this.exampleDocuments.getAllPositiveExamples();
        if (this.shouldAbort()) {
            return null;
        }
        TextRulerRuleList bestRulesPool = new TextRulerRuleList();
        TextRulerRuleList contextRulesPool = new TextRulerRuleList();
        String slotName = target.getSingleSlotRawTypeName();
        this.bestRulesPoolMap.put(slotName, bestRulesPool);
        this.contextRulesPoolMap.put(slotName, contextRulesPool);
        this.coveredExamples = new HashSet<TextRulerExample>();
        int roundNumber = 0;
        for (TextRulerExample e : this.examples) {
            if (this.coveredExamples.contains(e)) continue;
            if (this.shouldAbort()) break;
            this.currentBestRules = new LP2CurrentBestRulesQueue(this.maxCurrentBestRulesCount);
            this.currentContextualRules = new LP2CurrentBestRulesQueue(this.maxCurrentContextualRulesCount);
            this.induceRulesFromExample(e, ++roundNumber);
            for (LP2Rule bestRule : this.currentBestRules) {
                this.addToFinalBestRulesPool(bestRule);
            }
            for (LP2Rule ctxRule : this.currentContextualRules) {
                this.addToFinalContextRulesPool(ctxRule);
            }
            this.sendStatusUpdateToDelegate("New Rules added.", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
        }
        TextRulerRuleList result = bestRulesPool;
        if (contextualRules != null) {
            for (TextRulerRule r : contextRulesPool) {
                contextualRules.add(r);
            }
        }
        return result;
    }

    @Override
    public CAS loadCAS(String fileName, CAS reuseCAS) {
        CAS cas = super.loadCAS(fileName, reuseCAS);
        this.prepareCASWithBoundaries(cas);
        return cas;
    }

    public void prepareCASWithBoundaries(CAS cas) {
        for (String slotName : this.slotNames) {
            TextRulerExampleDocument.createBoundaryAnnotationsForCas(cas, slotName, this.filterSet);
        }
    }

    public void prepareCachedCASesWithBoundaries() {
        for (CAS cas : this.exampleDocuments.getCachedCASes()) {
            this.prepareCASWithBoundaries(cas);
        }
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this.examples = null;
        this.coveredExamples = null;
        this.currentBestRules = null;
        this.currentContextualRules = null;
        this.bestRulesPoolMap.clear();
        this.contextRulesPoolMap.clear();
    }

    @Override
    protected void doRun() {
        TextRulerToolkit.logIfDebug("--- LP2 START");
        this.prepareCachedCASesWithBoundaries();
        for (int i = 0; i < this.slotNames.length; ++i) {
            this.runForSlotName(this.slotNames[i]);
        }
        this.sendStatusUpdateToDelegate("Done", TextRulerLearner.TextRulerLearnerState.ML_DONE, true);
        TextRulerToolkit.logIfDebug("--- LP2 END");
    }

    protected void runForSlotName(String slotName) {
        this.sendStatusUpdateToDelegate("Creating slot length histogram...", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
        List<Integer> histogram = this.exampleDocuments.getTokenCountHistogrammForSlotName(slotName, TextRulerToolkit.getFilterSetWithSlotNames(this.slotNames, this.filterSet));
        if (this.shouldAbort()) {
            return;
        }
        this.slotMaximumTokenCountMap.put(slotName, histogram.size() - 1);
        TextRulerRuleList ctxRules = new TextRulerRuleList();
        TextRulerRuleList bestRules = this.learnTaggingRules(new TextRulerTarget(slotName, TextRulerTarget.MLTargetType.SINGLE_LEFT_BOUNDARY, this), ctxRules);
        if (bestRules != null) {
            this.leftBoundaryBestRulesMap.put(slotName, bestRules.getRulesString(""));
            this.leftBoundaryContextualRulesMap.put(slotName, ctxRules.getRulesString("\t"));
            bestRules.clear();
        }
        if (this.shouldAbort()) {
            return;
        }
        ctxRules.clear();
        bestRules = this.learnTaggingRules(new TextRulerTarget(slotName, TextRulerTarget.MLTargetType.SINGLE_RIGHT_BOUNDARY, this), ctxRules);
        if (bestRules != null) {
            this.rightBoundaryBestRulesMap.put(slotName, bestRules.getRulesString(""));
            this.rightBoundaryContextualRulesMap.put(slotName, ctxRules.getRulesString("\t"));
        }
        TextRulerTarget lsTarget = new TextRulerTarget(slotName, TextRulerTarget.MLTargetType.SINGLE_LEFT_CORRECTION, this);
        lsTarget.setMaxShiftDistance(this.shiftSize);
        TextRulerRuleList correctLeftRules = this.learnTaggingRules(lsTarget, null);
        this.sendStatusUpdateToDelegate("SLOT Done", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
        TextRulerToolkit.logIfDebug("--- LP2 END FOR SLOT:" + slotName);
    }

    protected abstract void induceRulesFromExample(TextRulerExample var1, int var2);

    protected void addToFinalContextRulesPool(LP2Rule rule) {
        String slotName = rule.getTarget().getSingleSlotRawTypeName();
        if (!this.contextRulesPoolMap.get(slotName).contains(rule)) {
            this.contextRulesPoolMap.get(slotName).add(rule);
        }
    }

    protected void addToFinalBestRulesPool(LP2Rule rule) {
        String slotName = rule.getTarget().getSingleSlotRawTypeName();
        if (!this.bestRulesPoolMap.get(slotName).contains(rule)) {
            this.bestRulesPoolMap.get(slotName).add(rule);
            this.coveredExamples.addAll(rule.getCoveringStatistics().getCoveredPositiveExamples());
        }
    }

    @Override
    public String getResultString() {
        StringBuilder sb = new StringBuilder();
        String header = this.getFileHeaderString(true);
        sb.append(header);
        for (String eachSlot : this.slotNames) {
            String leftBoundaryBestRulesString = this.leftBoundaryBestRulesMap.get(eachSlot);
            String rightBoundaryBestRulesString = this.rightBoundaryBestRulesMap.get(eachSlot);
            String leftBoundaryContextualRulesString = this.leftBoundaryContextualRulesMap.get(eachSlot);
            String rightBoundaryContextualRulesString = this.rightBoundaryContextualRulesMap.get(eachSlot);
            TextRulerRuleList bestRulesPool = this.bestRulesPoolMap.get(eachSlot);
            TextRulerRuleList contextRulesPool = this.contextRulesPoolMap.get(eachSlot);
            sb.append("\n// Slot: " + TextRulerToolkit.getTypeShortName(eachSlot) + "\n");
            sb.append("// LEFT BOUNDARY RULES:\n");
            if (leftBoundaryBestRulesString != null) {
                sb.append(leftBoundaryBestRulesString);
                sb.append("\n// RIGHT BOUNDARY RULES:\n");
                if (rightBoundaryBestRulesString != null) {
                    sb.append(rightBoundaryBestRulesString);
                } else if (bestRulesPool != null) {
                    sb.append(bestRulesPool.getRulesString(""));
                }
                sb.append("\nBLOCK(contextualRules_" + TextRulerToolkit.getTypeShortName(eachSlot) + ") Document{} {\n" + "\tDocument{->ASSIGN(redoContextualRules, false)}; // reset flag\n");
                sb.append("\n\t// LEFT BOUNDARY CONTEXTUAL RULES:\n");
                sb.append(leftBoundaryContextualRulesString);
                sb.append("\n\t// RIGHT BOUNDARY CONTEXTUAL RULES:\n");
                if (rightBoundaryBestRulesString != null) {
                    sb.append(rightBoundaryContextualRulesString);
                } else if (contextRulesPool != null) {
                    sb.append(contextRulesPool.getRulesString("\t"));
                }
                sb.append("\n\t//Document{IF(redoContextualRules)->CALL(thisFile.contextualRules_" + TextRulerToolkit.getTypeShortName(eachSlot) + ")};\n}\n");
                continue;
            }
            if (bestRulesPool == null) continue;
            sb.append(bestRulesPool.getRulesString(""));
            sb.append("\n\t// LEFT BOUNDARY CONTEXTUAL RULES:\n");
            if (contextRulesPool == null) continue;
            sb.append(contextRulesPool.getRulesString(""));
        }
        for (String eachSlot : this.slotNames) {
            String leftBoundary = TextRulerToolkit.getTypeShortName(new TextRulerTarget(eachSlot, TextRulerTarget.MLTargetType.SINGLE_LEFT_BOUNDARY, this).getSingleSlotTypeName());
            String rightBoundary = TextRulerToolkit.getTypeShortName(new TextRulerTarget(eachSlot, TextRulerTarget.MLTargetType.SINGLE_RIGHT_BOUNDARY, this).getSingleSlotTypeName());
            String slotMarkName = TextRulerToolkit.getTypeShortName(eachSlot);
            int maxInnerLength = this.getMaxTokens(eachSlot) * 3 - 2;
            sb.append("\n//slot-building rules:\n");
            sb.append(leftBoundary + "{IS(" + rightBoundary + ")->UNMARK(" + leftBoundary + "), UNMARK(" + rightBoundary + "), MARKONCE(" + slotMarkName + ")};\n");
            sb.append(leftBoundary + "{->UNMARK(" + leftBoundary + ")} ");
            if (maxInnerLength > 0) {
                sb.append("ANY[0, " + maxInnerLength + "]? ");
                sb.append(rightBoundary + "{->UNMARK(" + rightBoundary + "), MARKONCE(" + slotMarkName + ", 1, 3)};\n");
            } else {
                sb.append(rightBoundary + "{->UNMARK(" + rightBoundary + "), MARKONCE(" + slotMarkName + ", 1, 2)};\n");
            }
            sb.append("\n//cleaning up:\n" + leftBoundary + "{->UNMARK(" + leftBoundary + ")};\n" + rightBoundary + "{->UNMARK(" + rightBoundary + ")};\n");
        }
        return sb.toString();
    }

    private Integer getMaxTokens(String slot) {
        if (this.slotMaximumTokenCountMap.get(slot) == null) {
            return 0;
        }
        return this.slotMaximumTokenCountMap.get(slot);
    }

    @Override
    public void setParameters(Map<String, Object> params) {
        if (params.containsKey(WINDOW_SIZE_KEY)) {
            this.windowSize = (Integer)params.get(WINDOW_SIZE_KEY);
        }
        if (params.containsKey(CURRENT_BEST_RULES_SIZE_KEY)) {
            this.maxCurrentBestRulesCount = (Integer)params.get(CURRENT_BEST_RULES_SIZE_KEY);
        }
        if (params.containsKey(CURRENT_CONTEXTUAL_RULES_SIZE_KEY)) {
            this.maxCurrentContextualRulesCount = (Integer)params.get(CURRENT_CONTEXTUAL_RULES_SIZE_KEY);
        }
        if (params.containsKey(MIN_COVERED_POSITIVES_PER_RULE_KEY)) {
            this.minCoveredPositives = (Integer)params.get(MIN_COVERED_POSITIVES_PER_RULE_KEY);
        }
        if (params.containsKey(MAX_ERROR_THRESHOLD_KEY)) {
            this.maxErrorThreshold = ((Float)params.get(MAX_ERROR_THRESHOLD_KEY)).floatValue();
        }
    }

    protected String correctionRulesInputDirectory(TextRulerTarget target) {
        if (target.isLeftBoundary()) {
            return this.tempDirectory() + "leftCorrectionDocs";
        }
        return this.tempDirectory() + "rightCorrectionDocs";
    }

    protected boolean testTaggingRulesAndCreateCorrectionRulesExamples(TextRulerTarget target, int maxDistance) {
        try {
            File dir = new File(this.correctionRulesInputDirectory(target));
            if (!dir.exists()) {
                dir.mkdir();
            }
            this.exampleDocuments.clearCurrentExamples();
            this.exampleDocuments.createExamplesForTarget(target);
            this.examples = this.exampleDocuments.getAllPositiveExamples();
            TextRulerExampleDocument[] sortedDocs = this.exampleDocuments.getSortedDocumentsInCacheOptimizedOrder();
            TypeSystem ts = sortedDocs[0].getCAS().getTypeSystem();
            Type tokensRootType = ts.getType("org.apache.uima.ruta.type.ANY");
            String allRulesContent = FileUtils.file2String((File)new File("/testinput/testrules/rules.ruta"));
            FileUtils.saveString2File((String)allRulesContent, (File)new File(this.getTempRulesFileName()));
            CAS testCAS = this.getTestCAS();
            for (TextRulerExampleDocument doc : sortedDocs) {
                TextRulerStatisticsCollector c = new TextRulerStatisticsCollector();
                doc.resetAndFillTestCAS(testCAS, target);
                CAS docCAS = doc.getCAS();
                this.ae.process(testCAS);
                this.compareOriginalDocumentWithTestCAS(doc, testCAS, target, c, true);
                List<TextRulerExample> correctTags = doc.getPositiveExamples();
                ArrayList<TextRulerExample> wrongTags = new ArrayList<TextRulerExample>(c.getCoveredNegativeExamples());
                ArrayList<TextRulerShiftExample> newExamples = new ArrayList<TextRulerShiftExample>();
                for (TextRulerExample wrongTag : wrongTags) {
                    List<AnnotationFS> left = TextRulerToolkit.getAnnotationsBeforePosition(docCAS, wrongTag.getAnnotation().getBegin(), maxDistance, TextRulerToolkit.getFilterSetWithSlotNames(this.slotNames, this.filterSet), tokensRootType);
                    List<AnnotationFS> right = TextRulerToolkit.getAnnotationsAfterPosition(docCAS, wrongTag.getAnnotation().getEnd(), maxDistance, TextRulerToolkit.getFilterSetWithSlotNames(this.slotNames, this.filterSet), tokensRootType);
                    int leftDistance = 0;
                    TextRulerExample leftCorrectTag = null;
                    for (int i = left.size() - 1; i >= 0; --i) {
                        ++leftDistance;
                        TextRulerAnnotation needle = TextRulerToolkit.convertToTargetAnnotation(left.get(i), doc, target, docCAS.getTypeSystem());
                        leftCorrectTag = TextRulerToolkit.exampleListContainsAnnotation(correctTags, needle);
                        if (leftCorrectTag != null) break;
                    }
                    int rightDistance = 0;
                    TextRulerExample rightCorrectTag = null;
                    for (AnnotationFS fs : right) {
                        ++rightDistance;
                        TextRulerAnnotation needle = TextRulerToolkit.convertToTargetAnnotation(fs, doc, target, docCAS.getTypeSystem());
                        rightCorrectTag = TextRulerToolkit.exampleListContainsAnnotation(correctTags, needle);
                        if (rightCorrectTag == null) continue;
                        break;
                    }
                    TextRulerExample theCorrectTag = null;
                    theCorrectTag = rightDistance < leftDistance && rightCorrectTag != null ? rightCorrectTag : (rightDistance > leftDistance && leftCorrectTag != null ? leftCorrectTag : (target.type == TextRulerTarget.MLTargetType.SINGLE_LEFT_BOUNDARY && rightCorrectTag != null ? rightCorrectTag : leftCorrectTag));
                    if (theCorrectTag == null) continue;
                    TextRulerToolkit.log("FOUND BAD EXAMPLE FOR SHIFTING !!");
                    TextRulerShiftExample shiftExample = new TextRulerShiftExample(doc, wrongTag.getAnnotation(), theCorrectTag.getAnnotation(), true, target);
                    newExamples.add(shiftExample);
                }
                TextRulerToolkit.writeCAStoXMIFile(testCAS, dir + File.pathSeparator + doc.getCasFileName());
            }
            testCAS.reset();
        }
        catch (Exception e) {
            TextRulerPlugin.error(e);
            return false;
        }
        return true;
    }

    @Override
    public String getFileHeaderString(boolean complete) {
        return super.getFileHeaderString(complete) + "BOOLEAN redoContextualRules;\n\n";
    }

    @Override
    protected boolean checkForMandatoryTypes() {
        if (!super.checkForMandatoryTypes()) {
            return false;
        }
        CAS someCas = this.getTestCAS();
        TypeSystem ts = someCas.getTypeSystem();
        ArrayList<String> list = new ArrayList<String>();
        for (String eachSlot : this.slotNames) {
            list.add(new TextRulerTarget(eachSlot, TextRulerTarget.MLTargetType.SINGLE_LEFT_BOUNDARY, this).getSingleSlotTypeName());
            list.add(new TextRulerTarget(eachSlot, TextRulerTarget.MLTargetType.SINGLE_RIGHT_BOUNDARY, this).getSingleSlotTypeName());
        }
        boolean result = true;
        ArrayList<String> missingTypes = new ArrayList<String>();
        for (String s : list) {
            if (ts.getType(s) != null) continue;
            missingTypes.add(s);
            result = false;
        }
        String missingString = "";
        for (String string : missingTypes) {
            missingString = missingString + string + ", ";
        }
        if (!StringUtils.isEmpty((CharSequence)missingString)) {
            missingString = missingString.substring(0, missingString.length() - 2);
        }
        if (!result) {
            this.sendStatusUpdateToDelegate("Error: Some Slot- or Helper-Types were not found in TypeSystem: " + missingString, TextRulerLearner.TextRulerLearnerState.ML_ERROR, false);
        }
        return result;
    }
}

