/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.trabal;

import java.util.ArrayList;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.learner.trabal.AnnotationErrorType;
import org.apache.uima.ruta.textruler.learner.trabal.Condition;
import org.apache.uima.ruta.textruler.learner.trabal.ConditionType;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalAnnotation;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalLearner;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalRule;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalRuleItem;

public class DeletionRule
extends TrabalRule {
    public DeletionRule(TrabalLearner parentAlgorithm, TextRulerTarget target, TrabalAnnotation annotation) {
        super(parentAlgorithm, target);
        this.annotation = annotation;
        this.errorType = AnnotationErrorType.DELETION;
        this.addConditionTypes();
    }

    public DeletionRule(DeletionRule copyFrom) {
        super((TrabalLearner)copyFrom.algorithm, copyFrom.target);
        this.annotation = copyFrom.annotation;
        this.errorType = AnnotationErrorType.DELETION;
        this.conditions = new ArrayList();
        for (Condition c : copyFrom.conditions) {
            this.conditions.add(c.clone());
        }
        this.addConditionTypes();
    }

    private void addConditionTypes() {
        this.conditionTypes = new ArrayList();
        this.conditionTypes.add(ConditionType.BEFORE);
        this.conditionTypes.add(ConditionType.AFTER);
        this.conditionTypes.add(ConditionType.STARTSWITH);
        this.conditionTypes.add(ConditionType.ENDSWITH);
        this.conditionTypes.add(ConditionType.CONTAINS);
        this.conditionTypes.add(ConditionType.PARTOF);
    }

    @Override
    public void compileRuleString() {
        this.ruleString = this.annotation.getType().getShortName() + "{" + this.parseConditions(this.conditionTypes) + "-> UNMARK(" + this.annotation.getType().getShortName() + ", true)};";
        this.setNeedsCompile(false);
    }

    @Override
    public boolean contains(TrabalAnnotation target) {
        if (target != null) {
            if (this.annotation.getType().getShortName().equals(target.getType().getShortName())) {
                return true;
            }
            for (Condition each : this.getConditions()) {
                if (!each.getItem().getName().equals(target.getType().getShortName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasSameBasicRule(TrabalRule rule) {
        if (rule.getTargetAnnotation() != null) {
            return false;
        }
        if (rule.getAnnotation() == null) {
            return false;
        }
        return rule.getAnnotation().getType().getShortName().equals(this.annotation.getType().getShortName());
    }

    @Override
    public TrabalRuleItem getFrontBoundary() {
        return new TrabalRuleItem(this.annotation);
    }

    @Override
    public TrabalRuleItem getRearBoundary() {
        return new TrabalRuleItem(this.annotation);
    }

    @Override
    public TrabalRule copy() {
        return new DeletionRule(this);
    }
}

