/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.DynamicGVTBuilder;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.util.EventDispatcher;
import org.apache.batik.util.HaltingThread;
import org.w3c.dom.svg.SVGDocument;

public class GVTTreeBuilder
extends HaltingThread {
    protected SVGDocument svgDocument;
    protected BridgeContext bridgeContext;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected Exception exception;
    static EventDispatcher.Dispatcher startedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((GVTTreeBuilderListener)object).gvtBuildStarted((GVTTreeBuilderEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher completedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((GVTTreeBuilderListener)object).gvtBuildCompleted((GVTTreeBuilderEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher cancelledDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((GVTTreeBuilderListener)object).gvtBuildCancelled((GVTTreeBuilderEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher failedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object object, Object object2) {
            ((GVTTreeBuilderListener)object).gvtBuildFailed((GVTTreeBuilderEvent)object2);
        }
    };

    public GVTTreeBuilder(SVGDocument sVGDocument, BridgeContext bridgeContext) {
        this.svgDocument = sVGDocument;
        this.bridgeContext = bridgeContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        GVTTreeBuilderEvent gVTTreeBuilderEvent = new GVTTreeBuilderEvent(this, null);
        try {
            this.fireEvent(startedDispatcher, gVTTreeBuilderEvent);
            if (this.isHalted()) {
                this.fireEvent(cancelledDispatcher, gVTTreeBuilderEvent);
                return;
            }
            GVTBuilder gVTBuilder = null;
            gVTBuilder = this.bridgeContext.isDynamic() ? new DynamicGVTBuilder() : new GVTBuilder();
            GraphicsNode graphicsNode = gVTBuilder.build(this.bridgeContext, this.svgDocument);
            if (this.isHalted()) {
                this.fireEvent(cancelledDispatcher, gVTTreeBuilderEvent);
                return;
            }
            gVTTreeBuilderEvent = new GVTTreeBuilderEvent(this, graphicsNode);
            this.fireEvent(completedDispatcher, gVTTreeBuilderEvent);
        }
        catch (InterruptedBridgeException interruptedBridgeException) {
            this.fireEvent(cancelledDispatcher, gVTTreeBuilderEvent);
        }
        catch (BridgeException bridgeException) {
            this.exception = bridgeException;
            gVTTreeBuilderEvent = new GVTTreeBuilderEvent(this, bridgeException.getGraphicsNode());
            this.fireEvent(failedDispatcher, gVTTreeBuilderEvent);
        }
        catch (Exception exception) {
            this.exception = exception;
            this.fireEvent(failedDispatcher, gVTTreeBuilderEvent);
        }
        catch (ThreadDeath threadDeath) {
            this.exception = new Exception(threadDeath.getMessage());
            this.fireEvent(failedDispatcher, gVTTreeBuilderEvent);
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.exception = new Exception(throwable.getMessage());
            this.fireEvent(failedDispatcher, gVTTreeBuilderEvent);
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public void addGVTTreeBuilderListener(GVTTreeBuilderListener gVTTreeBuilderListener) {
        this.listeners.add(gVTTreeBuilderListener);
    }

    public void removeGVTTreeBuilderListener(GVTTreeBuilderListener gVTTreeBuilderListener) {
        this.listeners.remove(gVTTreeBuilderListener);
    }

    public void fireEvent(EventDispatcher.Dispatcher dispatcher, Object object) {
        EventDispatcher.fireEvent(dispatcher, this.listeners, object, true);
    }
}

