/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.wicket.Application;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.settings.JavaScriptLibrarySettings;
import org.apache.wicket.util.string.Strings;

public class OnDomReadyHeaderItem
extends HeaderItem {
    private static final long serialVersionUID = 1L;
    private final CharSequence javaScript;

    public static OnDomReadyHeaderItem forScript(CharSequence javaScript) {
        return new OnDomReadyHeaderItem(javaScript);
    }

    public OnDomReadyHeaderItem() {
        this(null);
    }

    public OnDomReadyHeaderItem(CharSequence javaScript) {
        this.javaScript = javaScript;
    }

    public CharSequence getJavaScript() {
        return this.javaScript;
    }

    @Override
    public void render(Response response) {
        CharSequence js = this.getJavaScript();
        if (!Strings.isEmpty((CharSequence)js)) {
            JavaScriptUtils.writeJavaScript(response, "Wicket.Event.add(window, \"domready\", function(event) { " + js + ";});");
        }
    }

    @Override
    public Iterable<?> getRenderTokens() {
        return Collections.singletonList("javascript-domready-" + this.getJavaScript());
    }

    public String toString() {
        return "OnDomReadyHeaderItem('" + this.getJavaScript() + "')";
    }

    public int hashCode() {
        return Objects.hash(this.javaScript);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OnDomReadyHeaderItem that = (OnDomReadyHeaderItem)o;
        return Objects.equals(this.javaScript, that.javaScript);
    }

    @Override
    public List<HeaderItem> getDependencies() {
        JavaScriptLibrarySettings ajaxSettings = Application.get().getJavaScriptLibrarySettings();
        ResourceReference wicketAjaxReference = ajaxSettings.getWicketAjaxReference();
        List<HeaderItem> dependencies = super.getDependencies();
        dependencies.add(JavaScriptHeaderItem.forReference(wicketAjaxReference));
        return dependencies;
    }
}

