/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import java.io.File;
import java.io.Serializable;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.util.file.Files;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.FileResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;

public class DownloadLink
extends Link<File> {
    private static final long serialVersionUID = 1L;
    private IModel<String> fileNameModel;
    private boolean deleteAfter;
    private Duration cacheDuration;

    public DownloadLink(String id, File file) {
        this(id, (IModel<File>)new Model<Serializable>((Serializable)Args.notNull((Object)file, (String)"file")));
    }

    public DownloadLink(String id, IModel<File> model) {
        this(id, model, (IModel<String>)null);
    }

    public DownloadLink(String id, IModel<File> model, String fileName) {
        this(id, model, Model.of(fileName));
    }

    public DownloadLink(String id, File file, String fileName) {
        this(id, Model.of((Serializable)Args.notNull((Object)file, (String)"file")), Model.of(fileName));
    }

    public DownloadLink(String id, IModel<File> fileModel, IModel<String> fileNameModel) {
        super(id, fileModel);
        this.fileNameModel = this.wrap(fileNameModel);
    }

    @Override
    public void detachModels() {
        super.detachModels();
        if (this.fileNameModel != null) {
            this.fileNameModel.detach();
        }
    }

    @Override
    public void onClick() {
        String fileName;
        final File file = (File)this.getModelObject();
        if (file == null) {
            throw new IllegalStateException(this.getClass().getName() + " failed to retrieve a File object from model");
        }
        String string = fileName = this.fileNameModel != null ? this.fileNameModel.getObject() : null;
        if (Strings.isEmpty((CharSequence)fileName)) {
            fileName = file.getName();
        }
        FileResourceStream resourceStream = new FileResourceStream(new org.apache.wicket.util.file.File(file));
        this.getRequestCycle().scheduleRequestHandlerAfterCurrent(new ResourceStreamRequestHandler((IResourceStream)resourceStream){

            @Override
            public void respond(IRequestCycle requestCycle) {
                super.respond(requestCycle);
                if (DownloadLink.this.deleteAfter) {
                    Files.remove((File)file);
                }
            }
        }.setFileName(fileName).setContentDisposition(ContentDisposition.ATTACHMENT).setCacheDuration(this.cacheDuration));
    }

    public final DownloadLink setDeleteAfterDownload(boolean deleteAfter) {
        this.deleteAfter = deleteAfter;
        return this;
    }

    public DownloadLink setCacheDuration(Duration duration) {
        this.cacheDuration = duration;
        return this;
    }
}

