/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.transformer;

import java.io.FileNotFoundException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.markup.transformer.ITransformer;
import org.apache.wicket.util.resource.IResourceStream;

public class XsltTransformer
implements ITransformer {
    private static final String extension = "xsl";
    private final String xslFile;

    public XsltTransformer() {
        this.xslFile = null;
    }

    public XsltTransformer(String xslFile) {
        this.xslFile = xslFile != null && xslFile.endsWith(extension) ? xslFile.substring(0, xslFile.length() - extension.length() - 1) : xslFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence transform(Component component, CharSequence output) throws Exception {
        IResourceStream resourceStream = this.getResourceStream(component);
        if (resourceStream == null) {
            throw new FileNotFoundException("Unable to find XSLT resource for " + component.toString());
        }
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(new StreamSource(resourceStream.getInputStream()));
            StringWriter writer = new StringWriter();
            transformer.transform(new StreamSource(new StringReader(output.toString())), new StreamResult(writer));
            StringBuffer stringBuffer = writer.getBuffer();
            return stringBuffer;
        }
        finally {
            resourceStream.close();
        }
    }

    private IResourceStream getResourceStream(Component component) {
        String filePath = this.xslFile;
        if (filePath == null) {
            filePath = component.findParentWithAssociatedMarkup().getClass().getPackage().getName().replace('.', '/') + "/" + component.getId();
        }
        IResourceStream resourceStream = Application.get().getResourceSettings().getResourceStreamLocator().locate(this.getClass(), filePath, component.getStyle(), component.getVariation(), component.getLocale(), extension, false);
        return resourceStream;
    }
}

