/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.servlet.MultipartServletWebRequest;
import org.apache.wicket.protocol.http.servlet.ServletPartFileItem;
import org.apache.wicket.protocol.http.servlet.UploadInfo;
import org.apache.wicket.util.file.FileCleanerTrackerAdapter;
import org.apache.wicket.util.file.IFileCleaner;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.value.ValueMap;

public class MultipartServletWebRequestImpl
extends MultipartServletWebRequest {
    private final Map<String, List<FileItem>> files;
    private final ValueMap parameters;
    private final String upload;
    private final FileItemFactory fileItemFactory;
    private int bytesUploaded;
    private int totalBytes;
    private static final String SESSION_KEY = MultipartServletWebRequestImpl.class.getName();

    public MultipartServletWebRequestImpl(HttpServletRequest request, String filterPrefix, Bytes maxSize, String upload) throws FileUploadException {
        this(request, filterPrefix, maxSize, upload, (FileItemFactory)new DiskFileItemFactory(){

            public FileCleaningTracker getFileCleaningTracker() {
                IFileCleaner fileCleaner = Application.get().getResourceSettings().getFileCleaner();
                return new FileCleanerTrackerAdapter(fileCleaner);
            }
        });
    }

    public MultipartServletWebRequestImpl(HttpServletRequest request, String filterPrefix, Bytes maxSize, String upload, FileItemFactory factory) throws FileUploadException {
        super(request, filterPrefix);
        Args.notNull((Object)upload, (String)"upload");
        this.upload = upload;
        this.fileItemFactory = factory;
        this.parameters = new ValueMap();
        this.files = new HashMap<String, List<FileItem>>();
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (!isMultipart) {
            throw new IllegalStateException("ServletRequest does not contain multipart content. One possible solution is to explicitly call Form.setMultipart(true), Wicket tries its best to auto-detect multipart forms but there are certain situation where it cannot.");
        }
        this.setMaxSize(maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseFileParts() throws FileUploadException {
        List items;
        HttpServletRequest request = this.getContainerRequest();
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = Application.get().getRequestCycleSettings().getResponseRequestEncoding();
        }
        FileUploadBase fileUpload = this.newFileUpload(encoding);
        if (this.wantUploadProgressUpdates()) {
            ServletRequestContext ctx = new ServletRequestContext(request){

                public InputStream getInputStream() throws IOException {
                    return new CountingInputStream(super.getInputStream());
                }
            };
            this.totalBytes = request.getContentLength();
            this.onUploadStarted(this.totalBytes);
            try {
                items = fileUpload.parseRequest((RequestContext)ctx);
            }
            finally {
                this.onUploadCompleted();
            }
        } else {
            items = fileUpload.parseRequest((RequestContext)new ServletRequestContext(request));
            if (items.isEmpty()) {
                items = this.readServlet3Parts(request);
            }
        }
        for (FileItem item : items) {
            if (item.isFormField()) {
                String value;
                if (encoding != null) {
                    try {
                        value = item.getString(encoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new WicketRuntimeException(e);
                    }
                } else {
                    value = item.getString();
                }
                this.addParameter(item.getFieldName(), value);
                continue;
            }
            List<FileItem> fileItems = this.files.get(item.getFieldName());
            if (fileItems == null) {
                fileItems = new ArrayList<FileItem>();
                this.files.put(item.getFieldName(), fileItems);
            }
            fileItems.add(item);
        }
    }

    private List<FileItem> readServlet3Parts(HttpServletRequest request) throws FileUploadException {
        ArrayList<FileItem> itemsFromParts = new ArrayList<FileItem>();
        try {
            Collection parts = request.getParts();
            if (parts != null) {
                for (Part part : parts) {
                    ServletPartFileItem fileItem = new ServletPartFileItem(part);
                    itemsFromParts.add(fileItem);
                }
            }
        }
        catch (IOException | ServletException e) {
            throw new FileUploadException("An error occurred while reading the upload parts", e);
        }
        return itemsFromParts;
    }

    protected FileUploadBase newFileUpload(String encoding) {
        ServletFileUpload fileUpload = new ServletFileUpload(this.fileItemFactory);
        if (encoding != null) {
            fileUpload.setHeaderEncoding(encoding);
        }
        fileUpload.setSizeMax(this.getMaxSize().bytes());
        Bytes fileMaxSize = this.getFileMaxSize();
        if (fileMaxSize != null) {
            fileUpload.setFileSizeMax(fileMaxSize.bytes());
        }
        fileUpload.setFileCountMax(this.getFileCountMax());
        return fileUpload;
    }

    private void addParameter(String name, String value) {
        String[] newVal;
        String[] currVal = (String[])this.parameters.get((Object)name);
        if (currVal != null) {
            newVal = new String[currVal.length + 1];
            System.arraycopy(currVal, 0, newVal, 0, currVal.length);
            newVal[currVal.length] = value;
        } else {
            newVal = new String[]{value};
        }
        this.parameters.put(name, (Object)newVal);
    }

    @Override
    public Map<String, List<FileItem>> getFiles() {
        return this.files;
    }

    @Override
    public List<FileItem> getFile(String fieldName) {
        return this.files.get(fieldName);
    }

    @Override
    protected Map<String, List<StringValue>> generatePostParameters() {
        HashMap<String, List<StringValue>> res = new HashMap<String, List<StringValue>>();
        for (Map.Entry entry : this.parameters.entrySet()) {
            String key = (String)entry.getKey();
            String[] val = (String[])entry.getValue();
            if (val == null || val.length <= 0) continue;
            ArrayList<StringValue> items = new ArrayList<StringValue>();
            for (String s : val) {
                items.add(StringValue.valueOf((String)s));
            }
            res.put(key, items);
        }
        return res;
    }

    protected boolean wantUploadProgressUpdates() {
        return Application.get().getApplicationSettings().isUploadProgressUpdatesEnabled();
    }

    protected void onUploadStarted(int totalBytes) {
        UploadInfo info = new UploadInfo(totalBytes);
        MultipartServletWebRequestImpl.setUploadInfo(this.getContainerRequest(), this.upload, info);
    }

    protected void onUploadUpdate(int bytesUploaded, int total) {
        HttpServletRequest request = this.getContainerRequest();
        UploadInfo info = MultipartServletWebRequestImpl.getUploadInfo(request, this.upload);
        if (info == null) {
            throw new IllegalStateException("could not find UploadInfo object in session which should have been set when uploaded started");
        }
        info.setBytesUploaded(bytesUploaded);
        MultipartServletWebRequestImpl.setUploadInfo(request, this.upload, info);
    }

    protected void onUploadCompleted() {
        MultipartServletWebRequestImpl.clearUploadInfo(this.getContainerRequest(), this.upload);
    }

    @Override
    public MultipartServletWebRequest newMultipartWebRequest(Bytes maxSize, String upload) throws FileUploadException {
        Bytes fileMaxSize = this.getFileMaxSize();
        for (Map.Entry<String, List<FileItem>> entry : this.files.entrySet()) {
            List<FileItem> fileItems = entry.getValue();
            for (FileItem fileItem : fileItems) {
                if (fileMaxSize == null || fileItem.getSize() <= fileMaxSize.bytes()) continue;
                String fieldName = entry.getKey();
                FileUploadBase.FileSizeLimitExceededException fslex = new FileUploadBase.FileSizeLimitExceededException("The field '" + fieldName + "' exceeds its maximum permitted size of '" + maxSize + "' characters.", fileItem.getSize(), fileMaxSize.bytes());
                throw fslex;
            }
        }
        return this;
    }

    @Override
    public MultipartServletWebRequest newMultipartWebRequest(Bytes maxSize, String upload, FileItemFactory factory) throws FileUploadException {
        return this;
    }

    private static String getSessionKey(String upload) {
        return SESSION_KEY + ":" + upload;
    }

    public static UploadInfo getUploadInfo(HttpServletRequest req, String upload) {
        Args.notNull((Object)req, (String)"req");
        return (UploadInfo)req.getSession().getAttribute(MultipartServletWebRequestImpl.getSessionKey(upload));
    }

    public static void setUploadInfo(HttpServletRequest req, String upload, UploadInfo uploadInfo) {
        Args.notNull((Object)req, (String)"req");
        Args.notNull((Object)upload, (String)"upload");
        Args.notNull((Object)uploadInfo, (String)"uploadInfo");
        req.getSession().setAttribute(MultipartServletWebRequestImpl.getSessionKey(upload), (Object)uploadInfo);
    }

    public static void clearUploadInfo(HttpServletRequest req, String upload) {
        Args.notNull((Object)req, (String)"req");
        Args.notNull((Object)upload, (String)"upload");
        req.getSession().removeAttribute(MultipartServletWebRequestImpl.getSessionKey(upload));
    }

    private class CountingInputStream
    extends InputStream {
        private final InputStream in;

        public CountingInputStream(InputStream in) {
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            int read = this.in.read();
            MultipartServletWebRequestImpl.this.bytesUploaded = MultipartServletWebRequestImpl.this.bytesUploaded + (read < 0 ? 0 : 1);
            MultipartServletWebRequestImpl.this.onUploadUpdate(MultipartServletWebRequestImpl.this.bytesUploaded, MultipartServletWebRequestImpl.this.totalBytes);
            return read;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int read = this.in.read(b);
            MultipartServletWebRequestImpl.this.bytesUploaded = MultipartServletWebRequestImpl.this.bytesUploaded + (read < 0 ? 0 : read);
            MultipartServletWebRequestImpl.this.onUploadUpdate(MultipartServletWebRequestImpl.this.bytesUploaded, MultipartServletWebRequestImpl.this.totalBytes);
            return read;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = this.in.read(b, off, len);
            MultipartServletWebRequestImpl.this.bytesUploaded = MultipartServletWebRequestImpl.this.bytesUploaded + (read < 0 ? 0 : read);
            MultipartServletWebRequestImpl.this.onUploadUpdate(MultipartServletWebRequestImpl.this.bytesUploaded, MultipartServletWebRequestImpl.this.totalBytes);
            return read;
        }
    }
}

