/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.settings;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IComponentAwareEventSink;
import org.apache.wicket.IDetachListener;
import org.apache.wicket.IEventDispatcher;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.serialize.java.JavaSerializer;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class FrameworkSettings
implements IEventDispatcher {
    private IDetachListener detachListener;
    private List<IEventDispatcher> eventDispatchers = null;
    private ISerializer serializer;

    public FrameworkSettings(Application application) {
        this.serializer = new JavaSerializer(application.getApplicationKey());
    }

    public String getVersion() {
        String implVersion = null;
        Package pkg = this.getClass().getPackage();
        if (pkg != null) {
            implVersion = pkg.getImplementationVersion();
        }
        return Strings.isEmpty(implVersion) ? "n/a" : implVersion;
    }

    public IDetachListener getDetachListener() {
        return this.detachListener;
    }

    public FrameworkSettings setDetachListener(IDetachListener detachListener) {
        this.detachListener = detachListener;
        return this;
    }

    public FrameworkSettings add(IEventDispatcher dispatcher) {
        Args.notNull((Object)dispatcher, (String)"dispatcher");
        if (this.eventDispatchers == null) {
            this.eventDispatchers = new ArrayList<IEventDispatcher>();
        }
        if (!this.eventDispatchers.contains(dispatcher)) {
            this.eventDispatchers.add(dispatcher);
        }
        return this;
    }

    @Override
    public void dispatchEvent(Object sink, IEvent<?> event, Component component) {
        if (component != null && sink instanceof IComponentAwareEventSink) {
            ((IComponentAwareEventSink)sink).onEvent(component, event);
        } else if (sink instanceof IEventSink) {
            ((IEventSink)sink).onEvent(event);
        }
        if (this.eventDispatchers == null) {
            return;
        }
        for (IEventDispatcher dispatcher : this.eventDispatchers) {
            dispatcher.dispatchEvent(sink, event, component);
        }
    }

    public FrameworkSettings setSerializer(ISerializer serializer) {
        this.serializer = (ISerializer)Args.notNull((Object)serializer, (String)"serializer");
        return this;
    }

    public ISerializer getSerializer() {
        return this.serializer;
    }
}

