/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.cdi;

import javax.enterprise.inject.spi.BeanManager;
import org.apache.wicket.cdi.INonContextualManager;
import org.apache.wicket.cdi.NonContextual;
import org.apache.wicket.util.lang.Args;

class NonContextualManager
implements INonContextualManager {
    private final BeanManager beanManager;

    public NonContextualManager(BeanManager beanManager) {
        Args.notNull((Object)beanManager, (String)"beanManager");
        this.beanManager = beanManager;
    }

    @Override
    public <T> void inject(T instance) {
        Args.notNull(instance, (String)"instance");
        NonContextual.of(instance, this.beanManager).inject(instance);
    }

    @Override
    public <T> void postConstruct(T instance) {
        Args.notNull(instance, (String)"instance");
        NonContextual.of(instance, this.beanManager).postConstruct(instance);
    }

    @Override
    public <T> void preDestroy(T instance) {
        Args.notNull(instance, (String)"instance");
        NonContextual.of(instance, this.beanManager).preDestroy(instance);
    }
}

