/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.protocol.http.WebApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketSessionFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(WicketSessionFilter.class);
    private String filterName;
    private String sessionKey;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterName = filterConfig.getInitParameter("filterName");
        if (this.filterName == null) {
            throw new ServletException("you must provide init parameter 'filterName if you want to use " + this.getClass().getName());
        }
        logger.debug("filterName/application key set to {}", (Object)this.filterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            WebApplication application = this.bindApplication();
            this.bindSession(request, application);
            chain.doFilter(request, response);
        }
        finally {
            this.cleanupBoundApplicationAndSession();
        }
    }

    private void cleanupBoundApplicationAndSession() {
        ThreadContext.detach();
    }

    private void bindSession(ServletRequest request, WebApplication application) {
        HttpSession httpSession = ((HttpServletRequest)request).getSession(false);
        Session session = this.getSession(httpSession, application);
        if (session == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("could not set Wicket session: key " + this.sessionKey + " not found in http session for " + ((HttpServletRequest)request).getContextPath() + "," + request.getServerName() + ", or http session does not exist");
            }
        } else {
            ThreadContext.setSession(session);
        }
    }

    private WebApplication bindApplication() {
        WebApplication application = (WebApplication)Application.get(this.filterName);
        if (application == null) {
            throw new IllegalStateException("Could not find wicket application mapped to filter: " + this.filterName + ". Make sure you set filterName attribute to the name of the wicket filter for the wicket application whose session you want to access.");
        }
        ThreadContext.setApplication(application);
        return application;
    }

    private Session getSession(HttpSession session, WebApplication application) {
        if (session != null) {
            if (this.sessionKey == null) {
                this.sessionKey = application.getSessionAttributePrefix(null, this.filterName) + "session";
                logger.debug("will use {} as the session key to get the Wicket session", (Object)this.sessionKey);
            }
            return (Session)session.getAttribute(this.sessionKey);
        }
        return null;
    }

    public void destroy() {
    }
}

