/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.NoRepaintRunnable;
import org.apache.batik.bridge.RepaintManager;
import org.apache.batik.bridge.ScriptingEnvironment;
import org.apache.batik.bridge.UpdateManagerEvent;
import org.apache.batik.bridge.UpdateManagerListener;
import org.apache.batik.bridge.svg12.DefaultXBLManager;
import org.apache.batik.bridge.svg12.SVG12BridgeContext;
import org.apache.batik.bridge.svg12.SVG12ScriptingEnvironment;
import org.apache.batik.dom.events.AbstractEvent;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.RootGraphicsNode;
import org.apache.batik.gvt.UpdateTracker;
import org.apache.batik.gvt.event.GraphicsNodeChangeListener;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.util.EventDispatcher;
import org.apache.batik.util.RunnableQueue;
import org.w3c.dom.Document;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public class UpdateManager {
    static final int MIN_REPAINT_TIME;
    protected BridgeContext bridgeContext;
    protected Document document;
    protected RunnableQueue updateRunnableQueue;
    protected RunnableQueue.RunHandler runHandler;
    protected boolean running;
    protected boolean suspendCalled;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected ScriptingEnvironment scriptingEnvironment;
    protected RepaintManager repaintManager;
    protected UpdateTracker updateTracker;
    protected GraphicsNode graphicsNode;
    protected boolean started;
    protected BridgeContext[] secondaryBridgeContexts;
    protected ScriptingEnvironment[] secondaryScriptingEnvironments;
    protected int minRepaintTime;
    long outOfDateTime = 0L;
    static EventDispatcher.Dispatcher startedDispatcher;
    static EventDispatcher.Dispatcher stoppedDispatcher;
    static EventDispatcher.Dispatcher suspendedDispatcher;
    static EventDispatcher.Dispatcher resumedDispatcher;
    static EventDispatcher.Dispatcher updateStartedDispatcher;
    static EventDispatcher.Dispatcher updateCompletedDispatcher;
    static EventDispatcher.Dispatcher updateFailedDispatcher;

    public UpdateManager(BridgeContext bridgeContext, GraphicsNode graphicsNode, Document document) {
        this.bridgeContext = bridgeContext;
        this.bridgeContext.setUpdateManager(this);
        this.document = document;
        this.updateRunnableQueue = RunnableQueue.createRunnableQueue();
        this.runHandler = this.createRunHandler();
        this.updateRunnableQueue.setRunHandler(this.runHandler);
        this.graphicsNode = graphicsNode;
        this.scriptingEnvironment = this.initializeScriptingEnvironment(this.bridgeContext);
        this.secondaryBridgeContexts = (BridgeContext[])bridgeContext.getChildContexts().clone();
        this.secondaryScriptingEnvironments = new ScriptingEnvironment[this.secondaryBridgeContexts.length];
        for (int i = 0; i < this.secondaryBridgeContexts.length; ++i) {
            ScriptingEnvironment scriptingEnvironment;
            BridgeContext bridgeContext2 = this.secondaryBridgeContexts[i];
            if (!((SVGOMDocument)bridgeContext2.getDocument()).isSVG12()) continue;
            bridgeContext2.setUpdateManager(this);
            this.secondaryScriptingEnvironments[i] = scriptingEnvironment = this.initializeScriptingEnvironment(bridgeContext2);
        }
        this.minRepaintTime = MIN_REPAINT_TIME;
    }

    public int getMinRepaintTime() {
        return this.minRepaintTime;
    }

    public void setMinRepaintTime(int n) {
        this.minRepaintTime = n;
    }

    protected ScriptingEnvironment initializeScriptingEnvironment(BridgeContext bridgeContext) {
        ScriptingEnvironment scriptingEnvironment;
        SVGOMDocument sVGOMDocument = (SVGOMDocument)bridgeContext.getDocument();
        if (sVGOMDocument.isSVG12()) {
            scriptingEnvironment = new SVG12ScriptingEnvironment(bridgeContext);
            bridgeContext.xblManager = new DefaultXBLManager((Document)sVGOMDocument, bridgeContext);
            sVGOMDocument.setXBLManager(bridgeContext.xblManager);
        } else {
            scriptingEnvironment = new ScriptingEnvironment(bridgeContext);
        }
        return scriptingEnvironment;
    }

    public synchronized void dispatchSVGLoadEvent() throws InterruptedException {
        this.dispatchSVGLoadEvent(this.bridgeContext, this.scriptingEnvironment);
        for (int i = 0; i < this.secondaryScriptingEnvironments.length; ++i) {
            BridgeContext bridgeContext = this.secondaryBridgeContexts[i];
            if (!((SVGOMDocument)bridgeContext.getDocument()).isSVG12()) continue;
            ScriptingEnvironment scriptingEnvironment = this.secondaryScriptingEnvironments[i];
            this.dispatchSVGLoadEvent(bridgeContext, scriptingEnvironment);
        }
        this.secondaryBridgeContexts = null;
        this.secondaryScriptingEnvironments = null;
    }

    protected void dispatchSVGLoadEvent(BridgeContext bridgeContext, ScriptingEnvironment scriptingEnvironment) {
        scriptingEnvironment.loadScripts();
        scriptingEnvironment.dispatchSVGLoadEvent();
        if (bridgeContext.isSVG12() && bridgeContext.xblManager != null) {
            SVG12BridgeContext sVG12BridgeContext = (SVG12BridgeContext)bridgeContext;
            sVG12BridgeContext.addBindingListener();
            sVG12BridgeContext.xblManager.startProcessing();
        }
    }

    public void dispatchSVGZoomEvent() throws InterruptedException {
        this.scriptingEnvironment.dispatchSVGZoomEvent();
    }

    public void dispatchSVGScrollEvent() throws InterruptedException {
        this.scriptingEnvironment.dispatchSVGScrollEvent();
    }

    public void dispatchSVGResizeEvent() throws InterruptedException {
        this.scriptingEnvironment.dispatchSVGResizeEvent();
    }

    public void manageUpdates(final ImageRenderer imageRenderer) {
        this.updateRunnableQueue.preemptLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                UpdateManager updateManager = UpdateManager.this;
                synchronized (updateManager) {
                    UpdateManager.this.running = true;
                    UpdateManager.this.updateTracker = new UpdateTracker();
                    RootGraphicsNode rootGraphicsNode = UpdateManager.this.graphicsNode.getRoot();
                    if (rootGraphicsNode != null) {
                        rootGraphicsNode.addTreeGraphicsNodeChangeListener((GraphicsNodeChangeListener)UpdateManager.this.updateTracker);
                    }
                    UpdateManager.this.repaintManager = new RepaintManager(imageRenderer);
                    UpdateManagerEvent updateManagerEvent = new UpdateManagerEvent(UpdateManager.this, null, null);
                    UpdateManager.this.fireEvent(startedDispatcher, updateManagerEvent);
                    UpdateManager.this.started = true;
                }
            }
        });
        this.resume();
    }

    public BridgeContext getBridgeContext() {
        return this.bridgeContext;
    }

    public RunnableQueue getUpdateRunnableQueue() {
        return this.updateRunnableQueue;
    }

    public RepaintManager getRepaintManager() {
        return this.repaintManager;
    }

    public UpdateTracker getUpdateTracker() {
        return this.updateTracker;
    }

    public Document getDocument() {
        return this.document;
    }

    public ScriptingEnvironment getScriptingEnvironment() {
        return this.scriptingEnvironment;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void suspend() {
        if (this.updateRunnableQueue.getQueueState() == RunnableQueue.RUNNING) {
            this.updateRunnableQueue.suspendExecution(false);
        }
        this.suspendCalled = true;
    }

    public synchronized void resume() {
        if (this.updateRunnableQueue.getQueueState() != RunnableQueue.RUNNING) {
            this.updateRunnableQueue.resumeExecution();
        }
    }

    public synchronized void interrupt() {
        if (this.updateRunnableQueue.getThread() == null) {
            return;
        }
        this.updateRunnableQueue.preemptLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                UpdateManager updateManager = UpdateManager.this;
                synchronized (updateManager) {
                    if (UpdateManager.this.started) {
                        UpdateManager.this.dispatchSVGUnLoadEvent();
                    } else {
                        UpdateManager.this.running = false;
                        UpdateManager.this.scriptingEnvironment.interrupt();
                        UpdateManager.this.updateRunnableQueue.getThread().halt();
                    }
                }
            }
        });
        this.resume();
    }

    public void dispatchSVGUnLoadEvent() {
        if (!this.started) {
            throw new IllegalStateException("UpdateManager not started.");
        }
        this.updateRunnableQueue.preemptLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                UpdateManager updateManager = UpdateManager.this;
                synchronized (updateManager) {
                    AbstractEvent abstractEvent = (AbstractEvent)((DocumentEvent)((Object)UpdateManager.this.document)).createEvent("SVGEvents");
                    String string = UpdateManager.this.bridgeContext.isSVG12() ? "unload" : "SVGUnload";
                    abstractEvent.initEventNS("http://www.w3.org/2001/xml-events", string, false, false);
                    ((EventTarget)((Object)UpdateManager.this.document.getDocumentElement())).dispatchEvent((Event)abstractEvent);
                    UpdateManager.this.running = false;
                    UpdateManager.this.scriptingEnvironment.interrupt();
                    UpdateManager.this.updateRunnableQueue.getThread().halt();
                    UpdateManager.this.bridgeContext.dispose();
                    UpdateManagerEvent updateManagerEvent = new UpdateManagerEvent(UpdateManager.this, null, null);
                    UpdateManager.this.fireEvent(stoppedDispatcher, updateManagerEvent);
                }
            }
        });
        this.resume();
    }

    public void updateRendering(AffineTransform affineTransform, boolean bl, Shape shape, int n, int n2) {
        this.repaintManager.setupRenderer(affineTransform, bl, shape, n, n2);
        ArrayList<Shape> arrayList = new ArrayList<Shape>(1);
        arrayList.add(shape);
        this.updateRendering(arrayList, false);
    }

    public void updateRendering(AffineTransform affineTransform, boolean bl, boolean bl2, Shape shape, int n, int n2) {
        this.repaintManager.setupRenderer(affineTransform, bl, shape, n, n2);
        ArrayList<Shape> arrayList = new ArrayList<Shape>(1);
        arrayList.add(shape);
        this.updateRendering(arrayList, bl2);
    }

    protected void updateRendering(List list, boolean bl) {
        try {
            UpdateManagerEvent updateManagerEvent = new UpdateManagerEvent(this, this.repaintManager.getOffScreen(), null);
            this.fireEvent(updateStartedDispatcher, updateManagerEvent);
            Collection collection = this.repaintManager.updateRendering(list);
            ArrayList arrayList = new ArrayList(collection);
            updateManagerEvent = new UpdateManagerEvent(this, this.repaintManager.getOffScreen(), arrayList, bl);
            this.fireEvent(updateCompletedDispatcher, updateManagerEvent);
        }
        catch (ThreadDeath threadDeath) {
            UpdateManagerEvent updateManagerEvent = new UpdateManagerEvent(this, null, null);
            this.fireEvent(updateFailedDispatcher, updateManagerEvent);
            throw threadDeath;
        }
        catch (Throwable throwable) {
            UpdateManagerEvent updateManagerEvent = new UpdateManagerEvent(this, null, null);
            this.fireEvent(updateFailedDispatcher, updateManagerEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void repaint() {
        Object object;
        if (!this.updateTracker.hasChanged()) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l - this.outOfDateTime < (long)this.minRepaintTime) {
            object = this.updateRunnableQueue.getIteratorLock();
            synchronized (object) {
                Iterator iterator = this.updateRunnableQueue.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() instanceof NoRepaintRunnable) continue;
                    return;
                }
            }
        }
        object = this.updateTracker.getDirtyAreas();
        this.updateTracker.clear();
        if (object != null) {
            this.updateRendering((List)object, false);
        }
        this.outOfDateTime = 0L;
    }

    public void addUpdateManagerListener(UpdateManagerListener updateManagerListener) {
        this.listeners.add(updateManagerListener);
    }

    public void removeUpdateManagerListener(UpdateManagerListener updateManagerListener) {
        this.listeners.remove(updateManagerListener);
    }

    protected void fireEvent(EventDispatcher.Dispatcher dispatcher, Object object) {
        EventDispatcher.fireEvent((EventDispatcher.Dispatcher)dispatcher, (List)this.listeners, (Object)object, (boolean)false);
    }

    protected RunnableQueue.RunHandler createRunHandler() {
        return new UpdateManagerRunHander();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        int n = 20;
        try {
            String string = System.getProperty("org.apache.batik.min_repaint_time", "20");
            n = Integer.parseInt(string);
        }
        catch (SecurityException securityException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        finally {
            MIN_REPAINT_TIME = n;
        }
        startedDispatcher = new EventDispatcher.Dispatcher(){

            public void dispatch(Object object, Object object2) {
                ((UpdateManagerListener)object).managerStarted((UpdateManagerEvent)object2);
            }
        };
        stoppedDispatcher = new EventDispatcher.Dispatcher(){

            public void dispatch(Object object, Object object2) {
                ((UpdateManagerListener)object).managerStopped((UpdateManagerEvent)object2);
            }
        };
        suspendedDispatcher = new EventDispatcher.Dispatcher(){

            public void dispatch(Object object, Object object2) {
                ((UpdateManagerListener)object).managerSuspended((UpdateManagerEvent)object2);
            }
        };
        resumedDispatcher = new EventDispatcher.Dispatcher(){

            public void dispatch(Object object, Object object2) {
                ((UpdateManagerListener)object).managerResumed((UpdateManagerEvent)object2);
            }
        };
        updateStartedDispatcher = new EventDispatcher.Dispatcher(){

            public void dispatch(Object object, Object object2) {
                ((UpdateManagerListener)object).updateStarted((UpdateManagerEvent)object2);
            }
        };
        updateCompletedDispatcher = new EventDispatcher.Dispatcher(){

            public void dispatch(Object object, Object object2) {
                ((UpdateManagerListener)object).updateCompleted((UpdateManagerEvent)object2);
            }
        };
        updateFailedDispatcher = new EventDispatcher.Dispatcher(){

            public void dispatch(Object object, Object object2) {
                ((UpdateManagerListener)object).updateFailed((UpdateManagerEvent)object2);
            }
        };
    }

    protected class UpdateManagerRunHander
    extends RunnableQueue.RunHandlerAdapter {
        protected UpdateManagerRunHander() {
        }

        public void runnableStart(RunnableQueue runnableQueue, Runnable runnable) {
            if (UpdateManager.this.running && !(runnable instanceof NoRepaintRunnable) && UpdateManager.this.outOfDateTime == 0L) {
                UpdateManager.this.outOfDateTime = System.currentTimeMillis();
            }
        }

        public void runnableInvoked(RunnableQueue runnableQueue, Runnable runnable) {
            if (UpdateManager.this.running && !(runnable instanceof NoRepaintRunnable)) {
                UpdateManager.this.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executionSuspended(RunnableQueue runnableQueue) {
            UpdateManager updateManager = UpdateManager.this;
            synchronized (updateManager) {
                if (UpdateManager.this.suspendCalled) {
                    UpdateManager.this.running = false;
                    UpdateManagerEvent updateManagerEvent = new UpdateManagerEvent((Object)this, null, null);
                    UpdateManager.this.fireEvent(suspendedDispatcher, updateManagerEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executionResumed(RunnableQueue runnableQueue) {
            UpdateManager updateManager = UpdateManager.this;
            synchronized (updateManager) {
                if (UpdateManager.this.suspendCalled && !UpdateManager.this.running) {
                    UpdateManager.this.running = true;
                    UpdateManager.this.suspendCalled = false;
                    UpdateManagerEvent updateManagerEvent = new UpdateManagerEvent((Object)this, null, null);
                    UpdateManager.this.fireEvent(resumedDispatcher, updateManagerEvent);
                }
            }
        }
    }
}

