/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.primitive;

import java.util.Arrays;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.factory.primitive.DoubleBags;
import org.eclipse.collections.api.factory.primitive.DoubleLists;
import org.eclipse.collections.api.factory.primitive.DoubleSets;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;

public abstract class AbstractDoubleIterable
implements DoubleIterable {
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public double minIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double maxIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        double[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            double first = sortedArray[middleIndex];
            double second = sortedArray[middleIndex - 1];
            return (first + second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public double[] toSortedArray() {
        double[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableDoubleList toSortedList() {
        return this.toList().sortThis();
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter(this);
    }

    public MutableDoubleList toList() {
        return DoubleLists.mutable.withAll((DoubleIterable)this);
    }

    public MutableDoubleSet toSet() {
        return DoubleSets.mutable.withAll((DoubleIterable)this);
    }

    public MutableDoubleBag toBag() {
        return DoubleBags.mutable.withAll((DoubleIterable)this);
    }
}

