/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.axf.ide;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.amp.axf.ide.AXFWorkbenchPlugin;
import org.eclipse.amp.axf.ide.handlers.ModelRunHandler;
import org.eclipse.core.commands.IHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class HandlerManager {
    private IHandlerService handlerService;
    private List<IHandlerActivation> handlerActivations;
    private List<ModelRunHandler> handlers;

    public synchronized void activate() {
        this.handlerService = (IHandlerService)AXFWorkbenchPlugin.getDefault().getWorkbench().getService(IHandlerService.class);
        this.handlerActivations = new ArrayList<IHandlerActivation>();
        this.handlers = new ArrayList<ModelRunHandler>();
    }

    public synchronized void deactivate() {
        if (this.handlerService != null) {
            this.handlerService.deactivateHandlers(this.handlerActivations);
        }
    }

    protected synchronized void addHandler(String id, ModelRunHandler handler) {
        this.handlers.add(handler);
        this.handlerActivations.add(this.handlerService.activateHandler(id, (IHandler)handler));
    }

    public synchronized void notifyHandlers() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                for (ModelRunHandler handler : HandlerManager.this.handlers) {
                    handler.notifyChange();
                }
            }
        });
    }
}

