/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.calendar;

import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.bpel.common.ui.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class CalendarControl
extends Canvas {
    private static final int LONG_DAY_MARGIN = 1;
    private static final int SHORT_DAY_MARGIN = 5;
    private static final int ROW_COUNT = 6;
    private static final int ARROW_OFFSET = 5;
    private static final int ROW_SPACING = 5;
    private static final int LINE_WIDTH = 1;
    private static final int DAY_MARGIN = 3;
    private static final int MONTH_MARGIN = 4;
    Calendar calendar = Calendar.getInstance();
    private ArrayList<SelectionListener> selectionListeners = new ArrayList();
    private CalendarPainter painter;
    private CalendarMouseAdapter mouseListener;
    int cellWidth;
    int cellHeight;
    int titleHeight;
    int width;
    int height;
    int lineStart;
    int lineEnd;
    int dayOfMonthMin;
    int dayOfMonthMax;
    int dayOfWeekMax;
    int startDayOfWeek;
    int lastDayOfPreviousMonth;
    int[] previousMonth;
    int[] nextMonth;
    String title;
    String[] days;
    private String[] months;
    private int dayMargin;
    int day;

    public CalendarControl(Composite parent) {
        super(parent, 262144);
        this.initializeControlContents();
        this.hookControlListener();
        this.updateVisuals();
    }

    public void setTimeZone(String tz) {
        this.calendar.setTimeZone(TimeZone.getTimeZone(tz));
    }

    private void initializeControlContents() {
        this.dayOfWeekMax = this.calendar.getActualMaximum(7);
        DateFormatSymbols symbols = new DateFormatSymbols();
        this.months = symbols.getMonths();
        this.setLongDayNames(true);
        GC gc = new GC((Drawable)this);
        Point dayMax = this.findMaximumSize(gc, this.days);
        Point monthMax = this.findMaximumSize(gc, this.months);
        gc.dispose();
        this.cellWidth = dayMax.x + this.dayMargin * 2 + 1;
        this.cellHeight = dayMax.y + 5;
        this.titleHeight = monthMax.y + 8;
        this.width = this.dayOfWeekMax * this.cellWidth;
        this.height = 8 + monthMax.y + 6 + dayMax.y + 6 * (dayMax.y + 5);
        this.lineStart = this.titleHeight + dayMax.y + 6;
        this.lineEnd = this.lineStart + (dayMax.y + 5) * 6;
        int lineLength = this.titleHeight - 10;
        this.previousMonth = new int[6];
        this.previousMonth[0] = 5;
        this.previousMonth[1] = this.titleHeight / 2;
        this.previousMonth[2] = 5 + lineLength / 2;
        this.previousMonth[3] = 5;
        this.previousMonth[4] = 5 + lineLength / 2;
        this.previousMonth[5] = 5 + lineLength;
        this.nextMonth = new int[6];
        this.nextMonth[0] = this.width - 5;
        this.nextMonth[1] = this.titleHeight / 2;
        this.nextMonth[2] = this.width - 5 - lineLength / 2;
        this.nextMonth[3] = 5;
        this.nextMonth[4] = this.width - 5 - lineLength / 2;
        this.nextMonth[5] = 5 + lineLength;
    }

    private void hookControlListener() {
        this.addKeyListener((KeyListener)new CalendarKeyAdapter());
        this.mouseListener = new CalendarMouseAdapter();
        this.addMouseListener((MouseListener)this.mouseListener);
        this.painter = new CalendarPainter(this.getDisplay());
        this.addPaintListener(this.painter);
    }

    private Point findMaximumSize(GC gc, String[] displayStrings) {
        Point max = new Point(0, 0);
        int i = 0;
        while (i < displayStrings.length) {
            Point size = gc.stringExtent(displayStrings[i]);
            if (size.x > max.x) {
                max.x = size.x;
            }
            if (size.y > max.y) {
                max.y = size.y;
            }
            ++i;
        }
        return max;
    }

    int getMatrixIndex(int x, int y) {
        if (this.lineStart <= y && this.lineEnd >= y && x >= 0 && x <= this.width) {
            int row = (y - this.lineStart) / this.cellHeight;
            int col = x / this.cellWidth;
            return row * this.dayOfWeekMax + col + 1;
        }
        return -1;
    }

    void changeMonth(boolean next) {
        if (this.day > this.dayOfMonthMax) {
            this.day = this.dayOfMonthMax;
        } else if (this.day < this.dayOfMonthMin) {
            this.day = this.dayOfMonthMin;
        }
        if (next) {
            this.calendar.set(2, this.calendar.get(2) + 1);
        } else {
            this.calendar.set(2, this.calendar.get(2) - 1);
        }
        this.updateVisuals();
    }

    void updateVisuals() {
        this.calendar.set(5, this.dayOfMonthMin);
        this.dayOfMonthMin = this.calendar.getActualMinimum(5);
        this.dayOfMonthMax = this.calendar.getActualMaximum(5);
        this.calendar.set(5, this.dayOfMonthMin);
        this.startDayOfWeek = this.calendar.get(7);
        this.calendar.set(2, this.calendar.get(2) - 1);
        this.lastDayOfPreviousMonth = this.calendar.getActualMaximum(5);
        this.calendar.set(2, this.calendar.get(2) + 1);
        if (this.day > this.dayOfMonthMax) {
            this.day = this.dayOfMonthMax;
        }
        this.title = NLS.bind((String)Messages.CalendarControl_title, (Object[])new Object[]{this.months[this.calendar.get(2)], String.valueOf(this.calendar.get(1))});
        this.redraw();
    }

    void fireSelectionChanged() {
        Event e = new Event();
        e.widget = this;
        e.data = this.getSelectedDate();
        int i = 0;
        while (i < this.selectionListeners.size()) {
            SelectionListener listener = this.selectionListeners.get(i);
            SelectionEvent se = new SelectionEvent(e);
            listener.widgetSelected(se);
            if (!se.doit) break;
            ++i;
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener != null && !this.selectionListeners.contains(listener)) {
            this.selectionListeners.add(listener);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (listener != null) {
            this.selectionListeners.remove(listener);
        }
    }

    public Date getSelectedDate() {
        this.calendar.set(5, this.day);
        Date date = this.calendar.getTime();
        this.calendar.set(5, this.dayOfMonthMin);
        return date;
    }

    public void setSelectedDate(Date selectedDate) {
        if (selectedDate == null) {
            selectedDate = new Date();
        }
        this.calendar.setTime(selectedDate);
        this.day = this.calendar.get(5);
        this.updateVisuals();
    }

    public boolean isLongDayNames() {
        return this.dayMargin == 1;
    }

    public void setLongDayNames(boolean useLongDayNames) {
        DateFormatSymbols symbols = new DateFormatSymbols();
        this.days = symbols.getShortWeekdays();
        if (useLongDayNames) {
            this.dayMargin = 1;
        } else {
            this.dayMargin = 5;
            int i = 0;
            while (i < this.days.length) {
                if (this.days[i].length() != 0) {
                    this.days[i] = this.days[i].substring(0, 1);
                }
                ++i;
            }
        }
    }

    public void dispose() {
        this.painter.dispose();
        this.mouseListener.dispose();
        super.dispose();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(this.width, this.height);
    }

    public Point computeSize(int wHint, int hHint) {
        return new Point(this.width, this.height);
    }

    private class CalendarKeyAdapter
    extends KeyAdapter {
        private CalendarKeyAdapter() {
        }

        public void keyPressed(KeyEvent e) {
            int dayChange = 0;
            int monthChange = 0;
            switch (e.keyCode) {
                case 0x1000001: {
                    if (CalendarControl.this.day - CalendarControl.this.dayOfWeekMax >= CalendarControl.this.dayOfMonthMin) {
                        dayChange -= CalendarControl.this.dayOfWeekMax;
                        break;
                    }
                    CalendarControl.this.calendar.set(2, CalendarControl.this.calendar.get(2) - 1);
                    int lastDay = CalendarControl.this.calendar.getActualMaximum(5);
                    CalendarControl.this.calendar.set(2, CalendarControl.this.calendar.get(2) + 1);
                    CalendarControl.this.day = CalendarControl.this.day - CalendarControl.this.dayOfWeekMax + lastDay;
                    monthChange = -1;
                    break;
                }
                case 0x1000002: {
                    if (CalendarControl.this.day + CalendarControl.this.dayOfWeekMax <= CalendarControl.this.dayOfMonthMax) {
                        dayChange += CalendarControl.this.dayOfWeekMax;
                        break;
                    }
                    CalendarControl.this.day = CalendarControl.this.day + CalendarControl.this.dayOfWeekMax - CalendarControl.this.dayOfMonthMax;
                    monthChange = 1;
                    break;
                }
                case 0x1000003: {
                    if ((e.stateMask & 0x20000) != 0) {
                        CalendarControl.this.changeMonth(false);
                        break;
                    }
                    if (CalendarControl.this.day != CalendarControl.this.dayOfMonthMin) {
                        --dayChange;
                        break;
                    }
                    CalendarControl.this.calendar.set(2, CalendarControl.this.calendar.get(2) - 1);
                    CalendarControl.this.day = CalendarControl.this.calendar.getActualMaximum(5);
                    CalendarControl.this.calendar.set(2, CalendarControl.this.calendar.get(2) + 1);
                    monthChange = -1;
                    break;
                }
                case 0x1000004: {
                    if ((e.stateMask & 0x20000) != 0) {
                        CalendarControl.this.changeMonth(true);
                        break;
                    }
                    if (CalendarControl.this.day != CalendarControl.this.dayOfMonthMax) {
                        ++dayChange;
                        break;
                    }
                    CalendarControl.this.day = CalendarControl.this.dayOfMonthMin;
                    monthChange = 1;
                }
            }
            if (dayChange != 0) {
                CalendarControl.this.day += dayChange;
                CalendarControl.this.redraw();
            }
            if (monthChange != 0) {
                CalendarControl.this.calendar.set(2, CalendarControl.this.calendar.get(2) + monthChange);
                CalendarControl.this.updateVisuals();
            }
            if (dayChange != 0 || monthChange != 0) {
                CalendarControl.this.fireSelectionChanged();
            }
        }
    }

    private class CalendarMouseAdapter
    extends MouseAdapter {
        private Region previousRegion = new Region();
        private Region nextRegion;

        public CalendarMouseAdapter() {
            this.previousRegion.add(CalendarControl.this.previousMonth);
            this.nextRegion = new Region();
            this.nextRegion.add(CalendarControl.this.nextMonth);
        }

        public void mouseDown(MouseEvent e) {
            boolean selectionChanged = false;
            if (e.y > CalendarControl.this.lineStart && e.y < CalendarControl.this.lineEnd) {
                int offset = CalendarControl.this.startDayOfWeek == CalendarControl.this.calendar.getFirstDayOfWeek() ? CalendarControl.this.dayOfWeekMax : 0;
                int selectedDay = CalendarControl.this.getMatrixIndex(e.x, e.y) - CalendarControl.this.startDayOfWeek + 1 - offset;
                if (selectedDay > CalendarControl.this.dayOfMonthMax) {
                    CalendarControl.this.day = selectedDay - CalendarControl.this.dayOfMonthMax;
                    CalendarControl.this.changeMonth(true);
                } else if (selectedDay < CalendarControl.this.dayOfMonthMin) {
                    CalendarControl.this.calendar.set(2, CalendarControl.this.calendar.get(2) - 1);
                    CalendarControl.this.day = CalendarControl.this.calendar.getActualMaximum(5) + selectedDay;
                    CalendarControl.this.calendar.set(2, CalendarControl.this.calendar.get(2) + 1);
                    CalendarControl.this.changeMonth(false);
                } else {
                    CalendarControl.this.day = selectedDay;
                }
                selectionChanged = true;
                CalendarControl.this.redraw();
            } else if (this.nextRegion.contains(e.x, e.y)) {
                CalendarControl.this.calendar.set(2, CalendarControl.this.calendar.get(2) + 1);
                CalendarControl.this.updateVisuals();
                selectionChanged = true;
            } else if (this.previousRegion.contains(e.x, e.y)) {
                CalendarControl.this.calendar.set(2, CalendarControl.this.calendar.get(2) - 1);
                CalendarControl.this.updateVisuals();
                selectionChanged = true;
            }
            if (selectionChanged) {
                CalendarControl.this.fireSelectionChanged();
            }
        }

        public void dispose() {
            if (this.previousRegion != null) {
                this.previousRegion.dispose();
                this.previousRegion = null;
            }
            if (this.nextRegion != null) {
                this.nextRegion.dispose();
                this.nextRegion = null;
            }
        }
    }

    private class CalendarPainter
    implements PaintListener {
        private int currentDay;
        private int currentMonth;
        private int currentYear;
        private Color background;
        private Color foreground;
        private Color titleBackground;
        private Color titleForeground;
        private Color lineForeground;
        private Color disabledForeground;
        private Font currentDayFont;
        private Image buffer;

        public CalendarPainter(Display display) {
            this.currentDay = CalendarControl.this.calendar.get(5);
            this.currentMonth = CalendarControl.this.calendar.get(2);
            this.currentYear = CalendarControl.this.calendar.get(1);
            this.foreground = display.getSystemColor(24);
            this.background = display.getSystemColor(25);
            this.titleBackground = display.getSystemColor(26);
            this.titleForeground = display.getSystemColor(27);
            this.lineForeground = display.getSystemColor(15);
            this.disabledForeground = display.getSystemColor(15);
            this.currentDayFont = this.createBoldFont(CalendarControl.this.getFont());
            this.buffer = new Image((Device)display, CalendarControl.this.width, CalendarControl.this.height);
        }

        public void paintControl(PaintEvent e) {
            GC gc = new GC((Drawable)this.buffer);
            gc.setBackground(this.background);
            gc.setForeground(this.foreground);
            gc.fillRectangle(0, 0, CalendarControl.this.width, CalendarControl.this.height);
            this.drawMonthName(gc);
            this.drawDayNames(gc);
            int predayCount = CalendarControl.this.startDayOfWeek == CalendarControl.this.calendar.getFirstDayOfWeek() ? CalendarControl.this.dayOfWeekMax : CalendarControl.this.startDayOfWeek - 1;
            this.drawDayRange(gc, 0, CalendarControl.this.lastDayOfPreviousMonth - predayCount + 1, predayCount, true);
            this.drawDayRange(gc, predayCount, CalendarControl.this.dayOfMonthMin, CalendarControl.this.dayOfMonthMax, false);
            this.drawDayRange(gc, CalendarControl.this.dayOfMonthMax + predayCount, 1, 6 * CalendarControl.this.dayOfWeekMax - predayCount - CalendarControl.this.dayOfMonthMax, true);
            this.drawDayLines(gc);
            e.gc.drawImage(this.buffer, 0, 0);
            gc.dispose();
        }

        public void dispose() {
            if (this.currentDayFont != null) {
                this.currentDayFont.dispose();
                this.currentDayFont = null;
            }
            if (this.buffer != null) {
                this.buffer.dispose();
                this.buffer = null;
            }
        }

        private void drawMonthName(GC gc) {
            Color gcBackground = gc.getBackground();
            Color gcForeground = gc.getForeground();
            gc.setBackground(this.titleBackground);
            gc.setForeground(this.titleForeground);
            gc.fillRectangle(0, 0, CalendarControl.this.width, CalendarControl.this.titleHeight);
            gc.drawString(CalendarControl.this.title, (CalendarControl.this.width - gc.stringExtent((String)CalendarControl.this.title).x) / 2, 4);
            gc.setBackground(gcBackground);
            gc.setForeground(gcForeground);
            gc.fillPolygon(CalendarControl.this.previousMonth);
            gc.fillPolygon(CalendarControl.this.nextMonth);
        }

        private void drawDayNames(GC gc) {
            int x = 0;
            int y = CalendarControl.this.titleHeight + 3;
            int i = CalendarControl.this.calendar.getFirstDayOfWeek();
            do {
                if (CalendarControl.this.days[i] == null || CalendarControl.this.days[i].length() == 0) continue;
                Point size = gc.stringExtent(CalendarControl.this.days[i]);
                gc.drawString(CalendarControl.this.days[i], (CalendarControl.this.cellWidth - size.x) / 2 + 1 + x, y);
                x += CalendarControl.this.cellWidth;
            } while ((i = (i + 1) % CalendarControl.this.days.length) != CalendarControl.this.calendar.getFirstDayOfWeek());
        }

        private void drawDayRange(GC gc, int index, int startDay, int length, boolean disabled) {
            int x = index % CalendarControl.this.dayOfWeekMax * CalendarControl.this.cellWidth;
            int y = index / CalendarControl.this.dayOfWeekMax * CalendarControl.this.cellHeight + CalendarControl.this.lineStart;
            int dayOfWeek = index % CalendarControl.this.dayOfWeekMax + 1;
            Color gcBackground = gc.getBackground();
            Color gcForeground = gc.getForeground();
            Font gcFont = gc.getFont();
            if (disabled) {
                gc.setForeground(this.disabledForeground);
            }
            int i = startDay;
            while (i < startDay + length) {
                String displayString = String.valueOf(i);
                if (!disabled && i == CalendarControl.this.day) {
                    gc.setBackground(this.titleBackground);
                    gc.setForeground(this.titleForeground);
                }
                if (!disabled && this.currentDay == i && this.currentMonth == CalendarControl.this.calendar.get(2) && this.currentYear == CalendarControl.this.calendar.get(1)) {
                    gc.setFont(this.currentDayFont);
                }
                Point size = gc.stringExtent(displayString);
                gc.drawString(displayString, (CalendarControl.this.cellWidth - size.x) / 2 + 1 + x, y);
                if (!disabled && i == CalendarControl.this.day) {
                    gc.setBackground(gcBackground);
                    gc.setForeground(gcForeground);
                }
                if (!disabled && this.currentDay == i && this.currentMonth == CalendarControl.this.calendar.get(2) && this.currentYear == CalendarControl.this.calendar.get(1)) {
                    gc.setFont(gcFont);
                }
                if (dayOfWeek % CalendarControl.this.dayOfWeekMax == 0 && i != CalendarControl.this.dayOfMonthMax) {
                    y += CalendarControl.this.cellHeight;
                    x = 0;
                } else {
                    x += CalendarControl.this.cellWidth;
                }
                dayOfWeek = (dayOfWeek + 1) % CalendarControl.this.dayOfWeekMax;
                ++i;
            }
            if (disabled) {
                gc.setForeground(gcForeground);
            }
        }

        private void drawDayLines(GC gc) {
            int x = CalendarControl.this.cellWidth;
            Color gcForeground = gc.getForeground();
            gc.setForeground(this.lineForeground);
            int i = 1;
            while (i < CalendarControl.this.dayOfWeekMax) {
                gc.drawLine(x, CalendarControl.this.lineStart, x, CalendarControl.this.lineEnd);
                x += CalendarControl.this.cellWidth;
                ++i;
            }
            gc.setForeground(gcForeground);
        }

        private Font createBoldFont(Font font) {
            FontData[] data = font.getFontData();
            int i = 0;
            while (i < data.length) {
                data[i].setStyle(data[i].getStyle() | 1);
                ++i;
            }
            return new Font((Device)Display.getCurrent(), data);
        }
    }
}

