/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.figures;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.handles.RelativeHandleLocator;

public class InsetRelativeHandleLocator
extends RelativeHandleLocator {
    int fVerticalInset;
    int fHorizontalInset;
    int fLocation;

    public InsetRelativeHandleLocator(IFigure reference, int aLocation, int verticalInset, int horizontalInset) {
        super(reference, aLocation);
        this.fVerticalInset = verticalInset;
        this.fHorizontalInset = horizontalInset;
        this.fLocation = aLocation;
    }

    public void relocate(IFigure target) {
        IFigure reference = this.getReferenceFigure();
        PrecisionRectangle targetBounds = new PrecisionRectangle(this.getReferenceBox().getResized(-1, -1));
        reference.translateToAbsolute((Translatable)targetBounds);
        target.translateToRelative((Translatable)targetBounds);
        targetBounds.resize(1, 1);
        Dimension targetSize = target.getPreferredSize();
        switch (this.fLocation & 0x18) {
            case 8: {
                targetBounds.x -= targetSize.width / 2;
                targetBounds.x += this.fHorizontalInset;
                break;
            }
            case 16: {
                targetBounds.x += targetBounds.width - targetSize.width / 2;
                targetBounds.x -= this.fHorizontalInset;
                break;
            }
            default: {
                targetBounds.x += targetBounds.width / 2;
            }
        }
        switch (this.fLocation & 5) {
            case 1: {
                targetBounds.y -= targetSize.height / 2;
                targetBounds.y += this.fVerticalInset;
                break;
            }
            case 4: {
                targetBounds.y += targetBounds.height - (targetSize.height + 2) / 2;
                targetBounds.y -= this.fVerticalInset;
                break;
            }
            default: {
                targetBounds.y += targetBounds.height / 2;
            }
        }
        targetBounds.setSize(targetSize);
        target.setBounds((Rectangle)targetBounds);
    }
}

