/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.GraphicalBPELRootEditPart;
import org.eclipse.bpel.ui.editparts.ProcessEditPart;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.IModelVisitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.ui.parts.GraphicalViewerImpl;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ScrollingBPELGraphicalViewer
extends GraphicalViewerImpl {
    private HashMap<Object, Integer> orderMap = null;
    protected List selectionList = null;
    protected int indexVisit = 0;
    protected boolean hasFocus;
    protected boolean notifyingOfSelectionChange;

    protected void createDefaultRoot() {
        this.setRootEditPart((RootEditPart)new GraphicalBPELRootEditPart());
    }

    public void appendSelection(EditPart editpart) {
        super.appendSelection(editpart);
        this.selectionList = this.primGetSelectedEditParts();
        if (this.selectionList.size() > 1) {
            this.indexVisit = 0;
            this.orderMap = new HashMap();
            BPELUtil.visitModelDepthFirst(BPELUtils.getProcess((Object)editpart.getModel()), new NumeratorVisitor());
            OrderedSelectionComparator cmp = new OrderedSelectionComparator();
            Collections.sort(this.selectionList, cmp);
            StructuredSelection newSel = new StructuredSelection(this.selectionList);
            this.setSelection((ISelection)newSel);
        }
        this.orderMap = null;
        this.selectionList = null;
    }

    public final Control createControl(Composite parent) {
        final FigureCanvas canvas = new FigureCanvas(parent, this.getLightweightSystem());
        canvas.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ScrollingBPELGraphicalViewer.this.hasFocus = true;
                canvas.redraw();
            }

            public void focusLost(FocusEvent e) {
                ScrollingBPELGraphicalViewer.this.hasFocus = false;
                canvas.redraw();
            }
        });
        super.setControl((Control)canvas);
        this.installRootFigure();
        return canvas;
    }

    protected FigureCanvas getFigureCanvas() {
        return (FigureCanvas)this.getControl();
    }

    public boolean getFigureCanvasFocus() {
        return this.hasFocus;
    }

    private void installRootFigure() {
        if (this.getFigureCanvas() == null) {
            return;
        }
        IFigure rootFigure = this.getRootFigure();
        if (rootFigure instanceof Viewport) {
            this.getFigureCanvas().setViewport((Viewport)rootFigure);
        } else {
            this.getFigureCanvas().setContents(rootFigure);
        }
    }

    public void reveal(EditPart part) {
        super.reveal(part);
        if (part instanceof ProcessEditPart) {
            return;
        }
        Viewport port = this.getFigureCanvas().getViewport();
        IFigure target = ((GraphicalEditPart)part).getFigure();
        Rectangle exposeRegion = target.getBounds().getExpanded(5, 5);
        target = target.getParent();
        while (target != null && target != port) {
            target.translateToParent((Translatable)exposeRegion);
            target = target.getParent();
        }
        Dimension viewportSize = port.getClientArea().getSize();
        Point topLeft = exposeRegion.getTopLeft();
        Point bottomRight = exposeRegion.getBottomRight().translate(viewportSize.negate());
        Point finalLocation = Point.min((Point)topLeft, (Point)Point.max((Point)bottomRight, (Point)port.getViewLocation()));
        Dimension existingSize = port.getSize();
        int oldViewportY = port.getViewLocation().y;
        int newViewportY = finalLocation.y;
        int figureY = exposeRegion.y;
        int figureHeight = exposeRegion.height;
        int bottomVisibleBefore = Math.min(figureY + figureHeight, oldViewportY + existingSize.height);
        int bottomVisibleAfter = Math.min(figureY + figureHeight, newViewportY + existingSize.height);
        if (bottomVisibleAfter < bottomVisibleBefore) {
            finalLocation.y = figureY + figureHeight - existingSize.height;
        }
        int topVisibleBefore = Math.max(figureY, oldViewportY);
        int topVisibleAfter = Math.max(figureY, finalLocation.y);
        if (topVisibleAfter > topVisibleBefore && bottomVisibleAfter < bottomVisibleBefore) {
            finalLocation.y = oldViewportY;
        }
        this.getFigureCanvas().scrollSmoothTo(finalLocation.x, finalLocation.y);
    }

    protected void setRootFigure(IFigure figure) {
        super.setRootFigure(figure);
        this.installRootFigure();
    }

    public void scrollVertical(boolean up) {
        Viewport port = this.getFigureCanvas().getViewport();
        Point finalLocation = port.getViewLocation().getCopy();
        finalLocation.y = finalLocation.y + (up ? -100 : 100);
        this.getFigureCanvas().scrollSmoothTo(finalLocation.x, finalLocation.y);
    }

    public void scrollHorizontal(boolean left) {
        Viewport port = this.getFigureCanvas().getViewport();
        Point finalLocation = port.getViewLocation().getCopy();
        finalLocation.x = finalLocation.x + (left ? -100 : 100);
        this.getFigureCanvas().scrollSmoothTo(finalLocation.x, finalLocation.y);
    }

    protected void fireSelectionChanged() {
        try {
            this.notifyingOfSelectionChange = true;
            super.fireSelectionChanged();
        }
        finally {
            this.notifyingOfSelectionChange = false;
        }
    }

    public void setSelection(ISelection arg0) {
        if (this.notifyingOfSelectionChange) {
            return;
        }
        super.setSelection(arg0);
    }

    public ISelection getSelection() {
        if (this.getSelectedEditParts().isEmpty()) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection(this.getSelectedEditParts());
    }

    public class NumeratorVisitor
    implements IModelVisitor {
        @Override
        public boolean visit(Object modelObject) {
            ++ScrollingBPELGraphicalViewer.this.indexVisit;
            ScrollingBPELGraphicalViewer.this.orderMap.put(modelObject, ScrollingBPELGraphicalViewer.this.indexVisit);
            return true;
        }
    }

    private class OrderedSelectionComparator
    implements Comparator<EditPart> {
        private OrderedSelectionComparator() {
        }

        @Override
        public int compare(EditPart ep1, EditPart ep2) {
            int val1 = 0;
            int val2 = 0;
            Object m1 = ep1.getModel();
            Object m2 = ep2.getModel();
            if (ScrollingBPELGraphicalViewer.this.orderMap.get(m1) != null) {
                val1 = (Integer)ScrollingBPELGraphicalViewer.this.orderMap.get(m1);
            }
            if (ScrollingBPELGraphicalViewer.this.orderMap.get(m2) != null) {
                val2 = (Integer)ScrollingBPELGraphicalViewer.this.orderMap.get(m2);
            }
            if (val1 < val2) {
                return -1;
            }
            if (val1 > val2) {
                return 1;
            }
            return 0;
        }
    }
}

