/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cft.server.core.internal.CloudFoundryBrandingExtensionPoint;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class CloudFoundryBrandingUIExtensionPoint
extends CloudFoundryBrandingExtensionPoint {
    public static String ATTR_NAME = "name";
    public static String ATTR_SERVER_TYPE_ID = "serverTypeId";
    public static String ATTR_WIZ_BAN = "wizardBanner";
    public static String POINT_ID = "org.eclipse.cft.server.ui.brandingUI";
    private static Map<String, IConfigurationElement> brandingUIDefinitions = new HashMap<String, IConfigurationElement>();
    private static List<String> brandingUIServerTypeIds = new ArrayList<String>();
    private static boolean read;

    private static void readBrandingUIDefinitions() {
        IExtensionPoint brandingUIExtPoint = Platform.getExtensionRegistry().getExtensionPoint(POINT_ID);
        if (brandingUIExtPoint != null) {
            CloudFoundryBrandingExtensionPoint.readBrandingDefinitions();
            brandingUIServerTypeIds.clear();
            IExtension[] iExtensionArray = brandingUIExtPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement coreConfig;
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    String serverId = config.getAttribute(ATTR_SERVER_TYPE_ID);
                    String name = config.getAttribute(ATTR_NAME);
                    if (serverId != null && serverId.trim().length() > 0 && name != null && name.trim().length() > 0 && (coreConfig = CloudFoundryBrandingExtensionPoint.getConfigurationElement((String)serverId)) != null) {
                        IConfigurationElement[] defaultUrl = coreConfig.getChildren(ELEM_DEFAULT_URL);
                        IConfigurationElement[] cloudUrls = coreConfig.getChildren(ELEM_CLOUD_URL);
                        String urlProviderClass = coreConfig.getAttribute(ATTR_URL_PROVIDER_CLASS);
                        if (defaultUrl != null && defaultUrl.length > 0 || cloudUrls != null && cloudUrls.length > 0 || urlProviderClass != null) {
                            brandingUIDefinitions.put(serverId, config);
                            brandingUIServerTypeIds.add(serverId);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            read = true;
        }
    }

    public static List<String> getServerTypeIds() {
        if (!read) {
            CloudFoundryBrandingUIExtensionPoint.readBrandingUIDefinitions();
        }
        return brandingUIServerTypeIds;
    }

    public static String getServiceName(String serverTypeId) {
        IConfigurationElement config;
        if (!read) {
            CloudFoundryBrandingUIExtensionPoint.readBrandingUIDefinitions();
        }
        if ((config = brandingUIDefinitions.get(serverTypeId)) != null) {
            return config.getAttribute(ATTR_NAME);
        }
        return null;
    }

    public static String getWizardBannerPath(String serverTypeId) {
        IConfigurationElement config;
        if (!read) {
            CloudFoundryBrandingUIExtensionPoint.readBrandingUIDefinitions();
        }
        if ((config = brandingUIDefinitions.get(serverTypeId)) != null) {
            return config.getAttribute(ATTR_WIZ_BAN);
        }
        return null;
    }
}

