/*
 * Copyright 2007 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.gwt.i18n.client.constants;

import com.google.gwt.i18n.client.Constants;

/**
 * TimeZoneConstants encapsulates a collection of time zone data for use with
 * DateTimeFormat services. This class extends GWT's Constants class.
 * The values of the constants are defined in property files named something
 * like "TimeZoneConstants_xx.properties".
 * 
 * Time zone data has only been provided for the "en" locale. Due to the large
 * size of the time zone data for each locale, we recommend that applications
 * retrieve the necessary data (i.e. over RPC) for the user's locale at run
 * time.
 */
public interface TimeZoneConstants extends Constants {
  String africaAbidjan();

  String africaAccra();

  String africaAddisAbaba();

  String africaAlgiers();

  String africaAsmera();

  String africaBamako();

  String africaBangui();

  String africaBanjul();

  String africaBissau();

  String africaBlantyre();

  String africaBrazzaville();

  String africaBujumbura();

  String africaCairo();

  String africaCasablanca();

  String africaCeuta();

  String africaConakry();

  String africaDakar();

  String africaDaresSalaam();

  String africaDjibouti();

  String africaDouala();

  String africaElAaiun();

  String africaFreetown();

  String africaGaborone();

  String africaHarare();

  String africaJohannesburg();

  String africaKampala();

  String africaKhartoum();

  String africaKigali();

  String africaKinshasa();

  String africaLagos();

  String africaLibreville();

  String africaLome();

  String africaLuanda();

  String africaLubumbashi();

  String africaLusaka();

  String africaMalabo();

  String africaMaputo();

  String africaMaseru();

  String africaMbabane();

  String africaMogadishu();

  String africaMonrovia();

  String africaNairobi();

  String africaNdjamena();

  String africaNiamey();

  String africaNouakchott();

  String africaOuagadougou();

  String africaPortoNovo();

  String africaSaoTome();

  String africaTripoli();

  String africaTunis();

  String africaWindhoek();

  String americaAdak();

  String americaAnchorage();

  String americaAnguilla();

  String americaAntigua();

  String americaAraguaina();

  String americaArgentinaLaRioja();

  String americaArgentinaRioGallegos();

  String americaArgentinaSalta();

  String americaArgentinaSanJuan();

  String americaArgentinaSanLuis();

  String americaArgentinaTucuman();

  String americaArgentinaUshuaia();

  String americaAruba();

  String americaAsuncion();

  String americaBahia();

  String americaBahiaBanderas();

  String americaBarbados();

  String americaBelem();

  String americaBelize();

  String americaBlancSablon();

  String americaBoaVista();

  String americaBogota();

  String americaBoise();

  String americaBuenosAires();

  String americaCambridgeBay();

  String americaCampoGrande();

  String americaCancun();

  String americaCaracas();

  String americaCatamarca();

  String americaCayenne();

  String americaCayman();

  String americaChicago();

  String americaChihuahua();

  String americaCoralHarbour();

  String americaCordoba();

  String americaCostaRica();

  String americaCreston();

  String americaCuiaba();

  String americaCuracao();

  String americaDanmarkshavn();

  String americaDawson();

  String americaDawsonCreek();

  String americaDenver();

  String americaDetroit();

  String americaDominica();

  String americaEdmonton();

  String americaEirunepe();

  String americaElSalvador();

  String americaFortaleza();

  String americaGlaceBay();

  String americaGodthab();

  String americaGooseBay();

  String americaGrandTurk();

  String americaGrenada();

  String americaGuadeloupe();

  String americaGuatemala();

  String americaGuayaquil();

  String americaGuyana();

  String americaHalifax();

  String americaHavana();

  String americaHermosillo();

  String americaIndianaKnox();

  String americaIndianaMarengo();

  String americaIndianaPetersburg();

  String americaIndianapolis();

  String americaIndianaTellCity();

  String americaIndianaVevay();

  String americaIndianaVincennes();

  String americaIndianaWinamac();

  String americaInuvik();

  String americaIqaluit();

  String americaJamaica();

  String americaJujuy();

  String americaJuneau();

  String americaKentuckyMonticello();

  String americaKralendijk();

  String americaLaPaz();

  String americaLima();

  String americaLosAngeles();

  String americaLouisville();

  String americaLowerPrinces();

  String americaMaceio();

  String americaManagua();

  String americaManaus();

  String americaMarigot();

  String americaMartinique();

  String americaMatamoros();

  String americaMazatlan();

  String americaMendoza();

  String americaMenominee();

  String americaMerida();

  String americaMetlakatla();

  String americaMexicoCity();

  String americaMiquelon();

  String americaMoncton();

  String americaMonterrey();

  String americaMontevideo();

  String americaMontserrat();

  String americaNassau();

  String americaNewYork();

  String americaNipigon();

  String americaNome();

  String americaNoronha();

  String americaNorthDakotaBeulah();

  String americaNorthDakotaCenter();

  String americaNorthDakotaNewSalem();

  String americaOjinaga();

  String americaPanama();

  String americaPangnirtung();

  String americaParamaribo();

  String americaPhoenix();

  String americaPortauPrince();

  String americaPortofSpain();

  String americaPortoVelho();

  String americaPuertoRico();

  String americaRainyRiver();

  String americaRankinInlet();

  String americaRecife();

  String americaRegina();

  String americaResolute();

  String americaRioBranco();

  String americaSantaIsabel();

  String americaSantarem();

  String americaSantiago();

  String americaSantoDomingo();

  String americaSaoPaulo();

  String americaScoresbysund();

  String americaSitka();

  String americaStBarthelemy();

  String americaStJohns();

  String americaStKitts();

  String americaStLucia();

  String americaStThomas();

  String americaStVincent();

  String americaSwiftCurrent();

  String americaTegucigalpa();

  String americaThule();

  String americaThunderBay();

  String americaTijuana();

  String americaToronto();

  String americaTortola();

  String americaVancouver();

  String americaWhitehorse();

  String americaWinnipeg();

  String americaYakutat();

  String americaYellowknife();

  String antarcticaCasey();

  String antarcticaDavis();

  String antarcticaDumontDUrville();

  String antarcticaMacquarie();

  String antarcticaMawson();

  String antarcticaMcMurdo();

  String antarcticaPalmer();

  String antarcticaRothera();

  String antarcticaSyowa();

  String antarcticaVostok();

  String arcticLongyearbyen();

  String asiaAden();

  String asiaAlmaty();

  String asiaAmman();

  String asiaAnadyr();

  String asiaAqtau();

  String asiaAqtobe();

  String asiaAshgabat();

  String asiaBaghdad();

  String asiaBahrain();

  String asiaBaku();

  String asiaBangkok();

  String asiaBeirut();

  String asiaBishkek();

  String asiaBrunei();

  String asiaCalcutta();

  String asiaChoibalsan();

  String asiaChongqing();

  String asiaColombo();

  String asiaDamascus();

  String asiaDhaka();

  String asiaDili();

  String asiaDubai();

  String asiaDushanbe();

  String asiaGaza();

  String asiaHarbin();

  String asiaHongKong();

  String asiaHovd();

  String asiaIrkutsk();

  String asiaJakarta();

  String asiaJayapura();

  String asiaJerusalem();

  String asiaKabul();

  String asiaKamchatka();

  String asiaKarachi();

  String asiaKashgar();

  String asiaKatmandu();

  String asiaKrasnoyarsk();

  String asiaKualaLumpur();

  String asiaKuching();

  String asiaKuwait();

  String asiaMacau();

  String asiaMagadan();

  String asiaMakassar();

  String asiaManila();

  String asiaMuscat();

  String asiaNicosia();

  String asiaNovokuznetsk();

  String asiaNovosibirsk();

  String asiaOmsk();

  String asiaOral();

  String asiaPhnomPenh();

  String asiaPontianak();

  String asiaPyongyang();

  String asiaQatar();

  String asiaQyzylorda();

  String asiaRangoon();

  String asiaRiyadh();

  String asiaSaigon();

  String asiaSakhalin();

  String asiaSamarkand();

  String asiaSeoul();

  String asiaShanghai();

  String asiaSingapore();

  String asiaTaipei();

  String asiaTashkent();

  String asiaTbilisi();

  String asiaTehran();

  String asiaThimphu();

  String asiaTokyo();

  String asiaUlaanbaatar();

  String asiaUrumqi();

  String asiaVientiane();

  String asiaVladivostok();

  String asiaYakutsk();

  String asiaYekaterinburg();

  String asiaYerevan();

  String atlanticAzores();

  String atlanticBermuda();

  String atlanticCanary();

  String atlanticCapeVerde();

  String atlanticFaeroe();

  String atlanticMadeira();

  String atlanticReykjavik();

  String atlanticSouthGeorgia();

  String atlanticStanley();

  String atlanticStHelena();

  String australiaAdelaide();

  String australiaBrisbane();

  String australiaBrokenHill();

  String australiaCurrie();

  String australiaDarwin();

  String australiaEucla();

  String australiaHobart();

  String australiaLindeman();

  String australiaLordHowe();

  String australiaMelbourne();

  String australiaPerth();

  String australiaSydney();

  String cST6CDT();

  String eST5EDT();

  String europeAmsterdam();

  String europeAndorra();

  String europeAthens();

  String europeBelgrade();

  String europeBerlin();

  String europeBratislava();

  String europeBrussels();

  String europeBucharest();

  String europeBudapest();

  String europeChisinau();

  String europeCopenhagen();

  String europeDublin();

  String europeGibraltar();

  String europeGuernsey();

  String europeHelsinki();

  String europeIsleofMan();

  String europeIstanbul();

  String europeJersey();

  String europeKaliningrad();

  String europeKiev();

  String europeLisbon();

  String europeLjubljana();

  String europeLondon();

  String europeLuxembourg();

  String europeMadrid();

  String europeMalta();

  String europeMariehamn();

  String europeMinsk();

  String europeMonaco();

  String europeMoscow();

  String europeOslo();

  String europeParis();

  String europePodgorica();

  String europePrague();

  String europeRiga();

  String europeRome();

  String europeSamara();

  String europeSanMarino();

  String europeSarajevo();

  String europeSimferopol();

  String europeSkopje();

  String europeSofia();

  String europeStockholm();

  String europeTallinn();

  String europeTirane();

  String europeUzhgorod();

  String europeVaduz();

  String europeVatican();

  String europeVienna();

  String europeVilnius();

  String europeVolgograd();

  String europeWarsaw();

  String europeZagreb();

  String europeZaporozhye();

  String europeZurich();

  String indianAntananarivo();

  String indianChagos();

  String indianChristmas();

  String indianCocos();

  String indianComoro();

  String indianKerguelen();

  String indianMahe();

  String indianMaldives();

  String indianMauritius();

  String indianMayotte();

  String indianReunion();

  String mST7MDT();

  String pacificApia();

  String pacificAuckland();

  String pacificChatham();

  String pacificEaster();

  String pacificEfate();

  String pacificEnderbury();

  String pacificFakaofo();

  String pacificFiji();

  String pacificFunafuti();

  String pacificGalapagos();

  String pacificGambier();

  String pacificGuadalcanal();

  String pacificGuam();

  String pacificHonolulu();

  String pacificJohnston();

  String pacificKiritimati();

  String pacificKosrae();

  String pacificKwajalein();

  String pacificMajuro();

  String pacificMarquesas();

  String pacificMidway();

  String pacificNauru();

  String pacificNiue();

  String pacificNorfolk();

  String pacificNoumea();

  String pacificPagoPago();

  String pacificPalau();

  String pacificPitcairn();

  String pacificPonape();

  String pacificPortMoresby();

  String pacificRarotonga();

  String pacificSaipan();

  String pacificTahiti();

  String pacificTarawa();

  String pacificTongatapu();

  String pacificTruk();

  String pacificWake();

  String pacificWallis();

  String pST8PDT();
}
