/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2013-08-29 04:32:04 +0200 (Thu, 29 Aug 2013) $
//  number=$Revision: 9287 $
//  type=sn

/**
 * Localized names for the "sn" locale.
 */
public class LocalizedNamesImpl_sn extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "ZW",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "AR",
        "AL",
        "DZ",
        "US",
        "AD",
        "AO",
        "AI",
        "AG",
        "AQ",
        "AM",
        "AW",
        "AU",
        "AT",
        "AX",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BZ",
        "BE",
        "BJ",
        "BM",
        "BT",
        "BL",
        "BO",
        "BW",
        "BA",
        "BQ",
        "BR",
        "IO",
        "BF",
        "BG",
        "BI",
        "BN",
        "BV",
        "CC",
        "CF",
        "TD",
        "CL",
        "CN",
        "NF",
        "CP",
        "CU",
        "CW",
        "CX",
        "CY",
        "CZ",
        "CD",
        "DK",
        "DG",
        "DJ",
        "DM",
        "DO",
        "EA",
        "TL",
        "EC",
        "EG",
        "EH",
        "SV",
        "GQ",
        "ER",
        "EE",
        "ET",
        "EU",
        "FJ",
        "FI",
        "FO",
        "FR",
        "GF",
        "PF",
        "GA",
        "GM",
        "GE",
        "DE",
        "GG",
        "GH",
        "GI",
        "GR",
        "GL",
        "GD",
        "GS",
        "GP",
        "GU",
        "GT",
        "GN",
        "GW",
        "GY",
        "HT",
        "HK",
        "HM",
        "HN",
        "HU",
        "IC",
        "IS",
        "IM",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IT",
        "CI",
        "IL",
        "JM",
        "JP",
        "JE",
        "JO",
        "KH",
        "CM",
        "CA",
        "KZ",
        "KE",
        "KI",
        "CO",
        "KM",
        "CG",
        "HR",
        "KP",
        "KR",
        "CR",
        "KW",
        "KG",
        "LA",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MK",
        "MG",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MQ",
        "MR",
        "MU",
        "YT",
        "ME",
        "MX",
        "MF",
        "FM",
        "MO",
        "MD",
        "MC",
        "MN",
        "MS",
        "MA",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NL",
        "AN",
        "NC",
        "NZ",
        "NI",
        "NE",
        "NG",
        "NU",
        "NO",
        "OM",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PH",
        "PN",
        "PL",
        "PT",
        "PS",
        "PR",
        "QA",
        "QO",
        "RE",
        "RO",
        "RS",
        "RU",
        "RW",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "WS",
        "AS",
        "SM",
        "ST",
        "SA",
        "SN",
        "SC",
        "SL",
        "SG",
        "SJ",
        "SK",
        "SI",
        "SO",
        "ZA",
        "ES",
        "LK",
        "SS",
        "SD",
        "SR",
        "SZ",
        "SE",
        "CH",
        "SX",
        "SY",
        "TA",
        "TW",
        "TJ",
        "TZ",
        "TF",
        "TH",
        "TG",
        "TK",
        "TO",
        "TT",
        "TN",
        "TR",
        "TM",
        "TV",
        "UG",
        "UA",
        "UM",
        "AE",
        "GB",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "XK",
        "YE",
        "ZM",
        "ZW",
        "SB",
        "VI",
        "CV",
        "KY",
        "CK",
        "FK",
        "VG",
        "MP",
        "MH",
        "TC",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Andora");
    namesMap.put("AF", "Afuganistani");
    namesMap.put("AG", "Antigua ne Barbuda");
    namesMap.put("AI", "Anguila");
    namesMap.put("AR", "Ajentina");
    namesMap.put("AS", "Samoa ye Amerika");
    namesMap.put("AW", "Arubha");
    namesMap.put("AZ", "Azabajani");
    namesMap.put("BA", "Boznia ne Herzegovina");
    namesMap.put("BD", "Bangladeshi");
    namesMap.put("BE", "Beljium");
    namesMap.put("BF", "Bukinafaso");
    namesMap.put("BH", "Bahareni");
    namesMap.put("BJ", "Benini");
    namesMap.put("BN", "Burunei");
    namesMap.put("BS", "Bahama");
    namesMap.put("BT", "Bhutani");
    namesMap.put("BY", "Belarusi");
    namesMap.put("CA", "Kanada");
    namesMap.put("CD", "Democratic Republic of the Congo");
    namesMap.put("CG", "Kongo");
    namesMap.put("CI", "Ivory Coast");
    namesMap.put("CK", "Zvitsuwa zveCook");
    namesMap.put("CM", "Kameruni");
    namesMap.put("CO", "Kolombia");
    namesMap.put("CR", "Kostarika");
    namesMap.put("CV", "Zvitsuwa zveCape Verde");
    namesMap.put("DZ", "Aljeria");
    namesMap.put("ET", "Etiopia");
    namesMap.put("FK", "Zvitsuwa zveFalklands");
    namesMap.put("HR", "Korasia");
    namesMap.put("IL", "Izuraeri");
    namesMap.put("KH", "Kambodia");
    namesMap.put("KM", "Komoro");
    namesMap.put("KP", "Korea, North");
    namesMap.put("KR", "Korea, South");
    namesMap.put("KY", "Zvitsuwa zveCayman");
    namesMap.put("MH", "Zvitsuwa zveMarshall");
    namesMap.put("MK", "Macedonia");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MP", "Zvitsuwa zvekumaodzanyemba eMariana");
    namesMap.put("NF", "Chitsuwa cheNorfolk");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("SB", "Zvitsuwa zvaSolomon");
    namesMap.put("TC", "Zvitsuwa zveTurk neCaico");
    namesMap.put("TD", "Chadi");
    namesMap.put("TL", "East Timor");
    namesMap.put("US", "Amerika");
    namesMap.put("VA", "Vatican State");
    namesMap.put("VC", "Saint Vincent and the Grenadines");
    namesMap.put("VG", "Zvitsuwa zveHingirandi");
    namesMap.put("VI", "Zvitsuwa zveAmerika");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Andora",
        "AF": "Afuganistani",
        "AG": "Antigua ne Barbuda",
        "AI": "Anguila",
        "AR": "Ajentina",
        "AS": "Samoa ye Amerika",
        "AW": "Arubha",
        "AZ": "Azabajani",
        "BA": "Boznia ne Herzegovina",
        "BD": "Bangladeshi",
        "BE": "Beljium",
        "BF": "Bukinafaso",
        "BH": "Bahareni",
        "BJ": "Benini",
        "BN": "Burunei",
        "BS": "Bahama",
        "BT": "Bhutani",
        "BY": "Belarusi",
        "CA": "Kanada",
        "CD": "Democratic Republic of the Congo",
        "CG": "Kongo",
        "CI": "Ivory Coast",
        "CK": "Zvitsuwa zveCook",
        "CM": "Kameruni",
        "CO": "Kolombia",
        "CR": "Kostarika",
        "CV": "Zvitsuwa zveCape Verde",
        "DZ": "Aljeria",
        "ET": "Etiopia",
        "FK": "Zvitsuwa zveFalklands",
        "HR": "Korasia",
        "IL": "Izuraeri",
        "KH": "Kambodia",
        "KM": "Komoro",
        "KP": "Korea, North",
        "KR": "Korea, South",
        "KY": "Zvitsuwa zveCayman",
        "MH": "Zvitsuwa zveMarshall",
        "MK": "Macedonia",
        "MM": "Myanmar",
        "MP": "Zvitsuwa zvekumaodzanyemba eMariana",
        "NF": "Chitsuwa cheNorfolk",
        "PN": "Pitcairn",
        "SB": "Zvitsuwa zvaSolomon",
        "TC": "Zvitsuwa zveTurk neCaico",
        "TD": "Chadi",
        "TL": "East Timor",
        "US": "Amerika",
        "VA": "Vatican State",
        "VC": "Saint Vincent and the Grenadines",
        "VG": "Zvitsuwa zveHingirandi",
        "VI": "Zvitsuwa zveAmerika"
    };
  }-*/;
}
