/*******************************************************************************
 * Copyright (c) 2012-2016 Codenvy, S.A.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Codenvy, S.A. - initial API and implementation
 *******************************************************************************/


// GENERATED SOURCE. DO NOT EDIT.
package org.eclipse.che.api.agent.server.dto;

import org.eclipse.che.dto.server.JsonSerializable;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;

import java.util.List;
import java.util.Map;


@SuppressWarnings({"unchecked", "cast"})
public class DtoServerImpls implements org.eclipse.che.dto.server.DtoFactoryVisitor {

  private static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();

  @Override
  public void accept(org.eclipse.che.dto.server.DtoFactory dtoFactory) {
    dtoFactory.registerProvider(org.eclipse.che.api.agent.shared.dto.AgentDto.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.agent.shared.dto.AgentDto>() {
        public Class<? extends org.eclipse.che.api.agent.shared.dto.AgentDto> getImplClass() {
            return AgentDtoImpl.class;
        }

        public org.eclipse.che.api.agent.shared.dto.AgentDto newInstance() {
            return AgentDtoImpl.make();
        }

        public org.eclipse.che.api.agent.shared.dto.AgentDto fromJson(String json) {
            return AgentDtoImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.agent.shared.dto.AgentDto fromJson(com.google.gson.JsonElement json) {
            return AgentDtoImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.agent.shared.dto.AgentDto clone(org.eclipse.che.api.agent.shared.dto.AgentDto origin) {
            return new AgentDtoImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.api.agent.shared.dto.AgentKeyDto.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.agent.shared.dto.AgentKeyDto>() {
        public Class<? extends org.eclipse.che.api.agent.shared.dto.AgentKeyDto> getImplClass() {
            return AgentKeyDtoImpl.class;
        }

        public org.eclipse.che.api.agent.shared.dto.AgentKeyDto newInstance() {
            return AgentKeyDtoImpl.make();
        }

        public org.eclipse.che.api.agent.shared.dto.AgentKeyDto fromJson(String json) {
            return AgentKeyDtoImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.agent.shared.dto.AgentKeyDto fromJson(com.google.gson.JsonElement json) {
            return AgentKeyDtoImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.agent.shared.dto.AgentKeyDto clone(org.eclipse.che.api.agent.shared.dto.AgentKeyDto origin) {
            return new AgentKeyDtoImpl(origin);
        }
    });
  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class AgentDtoImpl implements org.eclipse.che.api.agent.shared.dto.AgentDto, JsonSerializable  {

    public static AgentDtoImpl make() {
        return new AgentDtoImpl();
    }

    public AgentDtoImpl() {
    }

    protected java.lang.String version;
    protected java.lang.String name;
    protected java.util.List<java.lang.String> dependencies;
    protected java.util.Map<java.lang.String, java.lang.String> properties;
    protected java.lang.String script;

    @Override
    public java.lang.String getVersion() {
      return version;
    }

    public void setVersion(java.lang.String v) {
      this.version = v;
    }

    @Override
    public java.lang.String getName() {
      return name;
    }

    public void setName(java.lang.String v) {
      this.name = v;
    }

    @Override
    public java.util.List<java.lang.String> getDependencies() {
      ensureDependencies();
      return new org.eclipse.che.dto.server.JsonArrayImpl(dependencies);
    }

    public void setDependencies(java.util.List<java.lang.String> v) {
      this.dependencies = v;
    }

    public void addDependencies(java.lang.String v) {
      ensureDependencies();
      dependencies.add(v);
    }

    public void clearDependencies() {
      ensureDependencies();
      dependencies.clear();
    }

    protected void ensureDependencies() {
      if (dependencies == null) {
        dependencies = new java.util.ArrayList<java.lang.String>();
      }
    }
    @Override
    public java.util.Map<java.lang.String, java.lang.String> getProperties() {
      ensureProperties();
      return new org.eclipse.che.dto.server.JsonStringMapImpl(properties);
    }

    public void setProperties(java.util.Map<java.lang.String, java.lang.String> v) {
      this.properties = v;
    }

    public void putProperties(String k, java.lang.String v) {
      ensureProperties();
      properties.put(k, v);
    }

    public void clearProperties() {
      ensureProperties();
      properties.clear();
    }

    protected void ensureProperties() {
      if (properties == null) {
        properties = new java.util.HashMap<java.lang.String, java.lang.String>();
      }
    }
    @Override
    public java.lang.String getScript() {
      return script;
    }

    public void setScript(java.lang.String v) {
      this.script = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof AgentDtoImpl)) {
        return false;
      }
      AgentDtoImpl other = (AgentDtoImpl) o;
      if (this.version != null) {
        if (!this.version.equals(other.version)) {
          return false;
        }
      } else {
        if (other.version != null) {
          return false;
        }
      }
      if (this.name != null) {
        if (!this.name.equals(other.name)) {
          return false;
        }
      } else {
        if (other.name != null) {
          return false;
        }
      }
      this.ensureDependencies();
      other.ensureDependencies();
      
      if (this.dependencies != null) {
        if (!this.dependencies.equals(other.dependencies)) {
          return false;
        }
      } else {
        if (other.dependencies != null) {
          return false;
        }
      }
      this.ensureProperties();
      other.ensureProperties();
      
      if (this.properties != null) {
        if (!this.properties.equals(other.properties)) {
          return false;
        }
      } else {
        if (other.properties != null) {
          return false;
        }
      }
      if (this.script != null) {
        if (!this.script.equals(other.script)) {
          return false;
        }
      } else {
        if (other.script != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (version != null ? version.hashCode() : 0);
      hash = hash * 31 + (name != null ? name.hashCode() : 0);
      ensureDependencies();
      hash = hash * 31 + (dependencies != null ? dependencies.hashCode() : 0);
      ensureProperties();
      hash = hash * 31 + (properties != null ? properties.hashCode() : 0);
      hash = hash * 31 + (script != null ? script.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonElement versionOut = (this.version == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.version);
      result.add("version", versionOut);

      JsonElement nameOut = (this.name == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.name);
      result.add("name", nameOut);

      JsonArray dependenciesOut = new JsonArray();
      this.ensureDependencies();
      for (java.lang.String dependencies_ : this.dependencies) {
        JsonElement dependenciesOut_ = (dependencies_ == null) ? JsonNull.INSTANCE : new JsonPrimitive(dependencies_);
        dependenciesOut.add(dependenciesOut_);
      }
      result.add("dependencies", dependenciesOut);

      JsonObject propertiesOut = new JsonObject();
      this.ensureProperties();
      for (java.util.Map.Entry<String, java.lang.String> entry0 : this.properties.entrySet()) {
        java.lang.String properties_ = entry0.getValue();
        JsonElement propertiesOut_ = (properties_ == null) ? JsonNull.INSTANCE : new JsonPrimitive(properties_);
        propertiesOut.add(entry0.getKey(), propertiesOut_);
      }
      result.add("properties", propertiesOut);

      JsonElement scriptOut = (this.script == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.script);
      result.add("script", scriptOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static AgentDtoImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static AgentDtoImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      AgentDtoImpl dto = new AgentDtoImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("version")) {
        JsonElement versionIn = json.get("version");
        java.lang.String versionOut = gson.fromJson(versionIn, java.lang.String.class);
        dto.setVersion(versionOut);
      }

      if (json.has("name")) {
        JsonElement nameIn = json.get("name");
        java.lang.String nameOut = gson.fromJson(nameIn, java.lang.String.class);
        dto.setName(nameOut);
      }

      if (json.has("dependencies")) {
        JsonElement dependenciesIn = json.get("dependencies");
        java.util.List<java.lang.String> dependenciesOut = null;
        if (dependenciesIn != null && !dependenciesIn.isJsonNull()) {
          dependenciesOut = new java.util.ArrayList<java.lang.String>();
          java.util.Iterator<JsonElement> dependenciesInIterator = dependenciesIn.getAsJsonArray().iterator();
          while (dependenciesInIterator.hasNext()) {
            JsonElement dependenciesIn_ = dependenciesInIterator.next();
            java.lang.String dependenciesOut_ = gson.fromJson(dependenciesIn_, java.lang.String.class);
            dependenciesOut.add(dependenciesOut_);
          }
        }
        dto.setDependencies(dependenciesOut);
      }

      if (json.has("properties")) {
        JsonElement propertiesIn = json.get("properties");
        java.util.Map<java.lang.String, java.lang.String> propertiesOut = null;
        if (propertiesIn != null && !propertiesIn.isJsonNull()) {
          propertiesOut = new java.util.HashMap<java.lang.String, java.lang.String>();
          java.util.Set<java.util.Map.Entry<String, JsonElement>> entries0 = propertiesIn.getAsJsonObject().entrySet();
          for (java.util.Map.Entry<String, JsonElement> entry0 : entries0) {
            JsonElement propertiesIn_ = entry0.getValue();
            java.lang.String propertiesOut_ = gson.fromJson(propertiesIn_, java.lang.String.class);
            propertiesOut.put(entry0.getKey(), propertiesOut_);
          }
        }
        dto.setProperties(propertiesOut);
      }

      if (json.has("script")) {
        JsonElement scriptIn = json.get("script");
        java.lang.String scriptOut = gson.fromJson(scriptIn, java.lang.String.class);
        dto.setScript(scriptOut);
      }

      return dto;
    }

    public static AgentDtoImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public AgentDtoImpl(org.eclipse.che.api.agent.shared.dto.AgentDto origin) {
      this.version = origin.getVersion();
      this.name = origin.getName();
      java.util.List<java.lang.String> dependenciesIn = origin.getDependencies();
      if (dependenciesIn != null) {
        java.util.List<java.lang.String> dependenciesOut = new java.util.ArrayList<java.lang.String>();
        for (java.lang.String dependenciesIn_ : dependenciesIn) {
            dependenciesOut.add(dependenciesIn_);
        }
        this.dependencies = dependenciesOut;
      }
      java.util.Map<java.lang.String, java.lang.String> propertiesIn = origin.getProperties();
      if (propertiesIn != null) {
        java.util.Map<java.lang.String, java.lang.String> propertiesOut = new java.util.HashMap<java.lang.String, java.lang.String>();
        for (java.util.Map.Entry<String, java.lang.String> entry0 : propertiesIn.entrySet()) {
          java.lang.String propertiesIn_ = entry0.getValue();
            propertiesOut.put(entry0.getKey(), propertiesIn_);
        }
        this.properties = propertiesOut;
      }
      this.script = origin.getScript();
    }

    public org.eclipse.che.api.agent.shared.dto.AgentDto withVersion(java.lang.String v) {
      this.version = v;
      return this;
    }

    public org.eclipse.che.api.agent.shared.dto.AgentDto withName(java.lang.String v) {
      this.name = v;
      return this;
    }

    public org.eclipse.che.api.agent.shared.dto.AgentDto withDependencies(java.util.List<java.lang.String> v) {
      this.dependencies = v;
      return this;
    }

    public org.eclipse.che.api.agent.shared.dto.AgentDto withProperties(java.util.Map<java.lang.String, java.lang.String> v) {
      this.properties = v;
      return this;
    }

    public org.eclipse.che.api.agent.shared.dto.AgentDto withScript(java.lang.String v) {
      this.script = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class AgentKeyDtoImpl implements org.eclipse.che.api.agent.shared.dto.AgentKeyDto, JsonSerializable  {

    public static AgentKeyDtoImpl make() {
        return new AgentKeyDtoImpl();
    }

    public AgentKeyDtoImpl() {
    }

    protected java.lang.String version;
    protected java.lang.String name;

    @Override
    public java.lang.String getVersion() {
      return version;
    }

    public void setVersion(java.lang.String v) {
      this.version = v;
    }

    @Override
    public java.lang.String getName() {
      return name;
    }

    public void setName(java.lang.String v) {
      this.name = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof AgentKeyDtoImpl)) {
        return false;
      }
      AgentKeyDtoImpl other = (AgentKeyDtoImpl) o;
      if (this.version != null) {
        if (!this.version.equals(other.version)) {
          return false;
        }
      } else {
        if (other.version != null) {
          return false;
        }
      }
      if (this.name != null) {
        if (!this.name.equals(other.name)) {
          return false;
        }
      } else {
        if (other.name != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (version != null ? version.hashCode() : 0);
      hash = hash * 31 + (name != null ? name.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonElement versionOut = (this.version == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.version);
      result.add("version", versionOut);

      JsonElement nameOut = (this.name == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.name);
      result.add("name", nameOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static AgentKeyDtoImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static AgentKeyDtoImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      AgentKeyDtoImpl dto = new AgentKeyDtoImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("version")) {
        JsonElement versionIn = json.get("version");
        java.lang.String versionOut = gson.fromJson(versionIn, java.lang.String.class);
        dto.setVersion(versionOut);
      }

      if (json.has("name")) {
        JsonElement nameIn = json.get("name");
        java.lang.String nameOut = gson.fromJson(nameIn, java.lang.String.class);
        dto.setName(nameOut);
      }

      return dto;
    }

    public static AgentKeyDtoImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public AgentKeyDtoImpl(org.eclipse.che.api.agent.shared.dto.AgentKeyDto origin) {
      this.version = origin.getVersion();
      this.name = origin.getName();
    }

    public org.eclipse.che.api.agent.shared.dto.AgentKeyDto withVersion(java.lang.String v) {
      this.version = v;
      return this;
    }

    public org.eclipse.che.api.agent.shared.dto.AgentKeyDto withName(java.lang.String v) {
      this.name = v;
      return this;
    }

  }


}