/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2013-08-29 04:32:04 +0200 (Thu, 29 Aug 2013) $
//  number=$Revision: 9287 $
//  type=ln

/**
 * Localized names for the "ln" locale.
 */
public class LocalizedNamesImpl_ln extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "ZA",
        "SA",
        "DE",
        "AL",
        "DZ",
        "US",
        "AM",
        "AD",
        "AI",
        "AO",
        "GB",
        "AQ",
        "AG",
        "AN",
        "AR",
        "AW",
        "HT",
        "AZ",
        "BS",
        "BH",
        "BB",
        "BE",
        "BZ",
        "BD",
        "BJ",
        "BM",
        "BG",
        "MM",
        "IC",
        "CV",
        "KY",
        "CK",
        "FK",
        "MP",
        "MH",
        "TC",
        "VI",
        "VG",
        "CC",
        "SB",
        "FO",
        "AX",
        "BL",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BR",
        "BN",
        "BF",
        "BI",
        "BT",
        "BY",
        "CP",
        "CW",
        "DK",
        "DG",
        "DM",
        "DJ",
        "EC",
        "ER",
        "NF",
        "IM",
        "BV",
        "CX",
        "AC",
        "ES",
        "EE",
        "ET",
        "EG",
        "FR",
        "FJ",
        "FI",
        "PH",
        "GA",
        "GM",
        "GH",
        "GR",
        "GD",
        "GN",
        "GW",
        "GQ",
        "GY",
        "GF",
        "GL",
        "GG",
        "GP",
        "GU",
        "GT",
        "HK",
        "UA",
        "HM",
        "GS",
        "ID",
        "IN",
        "IR",
        "IQ",
        "IE",
        "UY",
        "IS",
        "IL",
        "IT",
        "JE",
        "NC",
        "KH",
        "CM",
        "CA",
        "QA",
        "KZ",
        "KE",
        "CU",
        "KG",
        "KI",
        "CO",
        "KM",
        "CG",
        "KP",
        "KR",
        "CR",
        "CI",
        "KW",
        "HR",
        "LA",
        "RE",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LU",
        "EU",
        "LI",
        "LT",
        "AE",
        "IO",
        "MG",
        "MV",
        "MW",
        "MY",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MK",
        "YT",
        "MX",
        "MF",
        "FM",
        "MO",
        "MD",
        "MC",
        "MN",
        "ME",
        "MU",
        "MR",
        "MZ",
        "MS",
        "NA",
        "NR",
        "NP",
        "NI",
        "NG",
        "NE",
        "NO",
        "NU",
        "NL",
        "OM",
        "HN",
        "HU",
        "AU",
        "AT",
        "PK",
        "PY",
        "PW",
        "PS",
        "PA",
        "PG",
        "PE",
        "PN",
        "PF",
        "PL",
        "PT",
        "PR",
        "QO",
        "CD",
        "CZ",
        "CF",
        "DO",
        "RU",
        "RO",
        "RW",
        "EH",
        "WS",
        "AS",
        "SH",
        "KN",
        "LC",
        "SM",
        "PM",
        "VC",
        "ST",
        "SV",
        "SN",
        "RS",
        "SL",
        "CL",
        "SK",
        "SI",
        "SG",
        "CN",
        "CY",
        "SY",
        "LK",
        "SO",
        "SD",
        "SS",
        "SR",
        "SJ",
        "SZ",
        "SE",
        "CH",
        "SX",
        "SC",
        "TA",
        "TH",
        "TW",
        "TZ",
        "TJ",
        "TF",
        "TM",
        "TR",
        "TL",
        "TT",
        "TN",
        "TG",
        "TK",
        "TO",
        "TD",
        "TV",
        "UG",
        "UM",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "XK",
        "YE",
        "JM",
        "ZM",
        "JP",
        "NZ",
        "EA",
        "GI",
        "ZW",
        "GE",
        "JO",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Mabelé");
    namesMap.put("002", "Afríka");
    namesMap.put("003", "Ameríka ya Nola");
    namesMap.put("005", "Ameríka ya Sidi");
    namesMap.put("011", "Afríka ya Wɛ́sita");
    namesMap.put("013", "Ameríka ya káti");
    namesMap.put("014", "Afríka ya Ɛ́sita");
    namesMap.put("015", "Afríka ya Nola");
    namesMap.put("017", "Afríka ya Katikáti");
    namesMap.put("018", "Afríka ya Sidi");
    namesMap.put("019", "Ameríka");
    namesMap.put("030", "Azía ya Ɛ́sita");
    namesMap.put("034", "Azía ya Sidi");
    namesMap.put("035", "Azía ya Sidi-Ɛ́sita");
    namesMap.put("039", "Erópa ya Sidi");
    namesMap.put("142", "Azía");
    namesMap.put("143", "Azía ya Katikáti");
    namesMap.put("145", "Azía ya Wɛ́sita");
    namesMap.put("150", "Erópa");
    namesMap.put("151", "Erópa ya Ɛ́sita");
    namesMap.put("154", "Erópa ya Nola");
    namesMap.put("155", "Erópa ya Wɛ́sita");
    namesMap.put("419", "Ameríka Latína");
    namesMap.put("AC", "Esenga ya Mbuta o likoló");
    namesMap.put("AD", "Andorɛ");
    namesMap.put("AE", "Lɛmila alabo");
    namesMap.put("AF", "Afiganisitá");
    namesMap.put("AG", "Antiga mpé Barbuda");
    namesMap.put("AI", "Angiyɛ");
    namesMap.put("AL", "Alibani");
    namesMap.put("AM", "Amɛni");
    namesMap.put("AN", "Antiyɛ ya Olandɛ");
    namesMap.put("AO", "Angóla");
    namesMap.put("AQ", "Antarctique");
    namesMap.put("AR", "Arizantinɛ");
    namesMap.put("AS", "Samoa ya Ameriki");
    namesMap.put("AT", "Otilisi");
    namesMap.put("AU", "Ositáli");
    namesMap.put("AX", "Bisanga Ɛland");
    namesMap.put("AZ", "Azɛlɛbaizá");
    namesMap.put("BA", "Bosini mpé Hezegovine");
    namesMap.put("BB", "Barɛbadɛ");
    namesMap.put("BD", "Bengalidɛsi");
    namesMap.put("BE", "Beleziki");
    namesMap.put("BF", "Bukina Faso");
    namesMap.put("BG", "Biligari");
    namesMap.put("BH", "Bahrɛnɛ");
    namesMap.put("BJ", "Benɛ");
    namesMap.put("BN", "Brineyi");
    namesMap.put("BO", "Bolivi");
    namesMap.put("BR", "Brezílɛ");
    namesMap.put("BS", "Bahamasɛ");
    namesMap.put("BT", "Butáni");
    namesMap.put("BV", "Esenga Buvé");
    namesMap.put("BY", "Byelorisi");
    namesMap.put("BZ", "Belizɛ");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Bisanga Kokos");
    namesMap.put("CD", "Repibiki demokratiki ya Kongó");
    namesMap.put("CF", "Repibiki ya Afríka ya Káti");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Swisɛ");
    namesMap.put("CI", "Kotídivualɛ");
    namesMap.put("CK", "Bisanga bya Kookɛ");
    namesMap.put("CL", "Síli");
    namesMap.put("CM", "Kamɛrune");
    namesMap.put("CN", "Sinɛ");
    namesMap.put("CO", "Kolombi");
    namesMap.put("CR", "Kositarika");
    namesMap.put("CU", "Kiba");
    namesMap.put("CV", "Bisanga bya Kapevɛrɛ");
    namesMap.put("CX", "Esenga ya Mbótama");
    namesMap.put("CY", "Sípɛlɛ");
    namesMap.put("CZ", "Repibiki Tsekɛ");
    namesMap.put("DE", "Alemani");
    namesMap.put("DJ", "Dzibuti");
    namesMap.put("DK", "Danɛmarike");
    namesMap.put("DM", "Domínike");
    namesMap.put("DO", "Repibiki ya Domínikɛ");
    namesMap.put("DZ", "Alizɛri");
    namesMap.put("EA", "Zewta mpé Melílla");
    namesMap.put("EC", "Ekwatɛ́lɛ");
    namesMap.put("EE", "Esitoni");
    namesMap.put("EG", "Ezípite");
    namesMap.put("EH", "Sahara ya Limbɛ");
    namesMap.put("ER", "Elitelɛ");
    namesMap.put("ES", "Esipanye");
    namesMap.put("ET", "Etsíopi");
    namesMap.put("EU", "Lisangá ya Erópa");
    namesMap.put("FI", "Filandɛ");
    namesMap.put("FJ", "Fidzi");
    namesMap.put("FK", "Bisanga bya Maluni");
    namesMap.put("FM", "Mikronezi");
    namesMap.put("FO", "Bisanga ya Fɛróa");
    namesMap.put("FR", "Falánsɛ");
    namesMap.put("GA", "Gabɔ");
    namesMap.put("GB", "Angɛlɛtɛ́lɛ");
    namesMap.put("GD", "Gelenadɛ");
    namesMap.put("GE", "Zorzi");
    namesMap.put("GF", "Giyanɛ ya Falánsɛ");
    namesMap.put("GG", "Guernesey");
    namesMap.put("GH", "Gana");
    namesMap.put("GI", "Zibatalɛ");
    namesMap.put("GL", "Gowelande");
    namesMap.put("GM", "Gambi");
    namesMap.put("GN", "Ginɛ");
    namesMap.put("GP", "Gwadɛlupɛ");
    namesMap.put("GQ", "Ginɛ́kwatɛ́lɛ");
    namesMap.put("GR", "Geleki");
    namesMap.put("GS", "Îles de Géorgie du Sud et Sandwich du Sud");
    namesMap.put("GT", "Gwatémala");
    namesMap.put("GU", "Gwamɛ");
    namesMap.put("GW", "Ginɛbisau");
    namesMap.put("GY", "Giyane");
    namesMap.put("HM", "Ile Heard et Iles McDonald");
    namesMap.put("HN", "Ondurasɛ");
    namesMap.put("HR", "Krowasi");
    namesMap.put("HT", "Ayiti");
    namesMap.put("HU", "Ongili");
    namesMap.put("IC", "Bisanga bya Kanári");
    namesMap.put("ID", "Indonezi");
    namesMap.put("IE", "Irelandɛ");
    namesMap.put("IL", "Isirayelɛ");
    namesMap.put("IM", "Esanga ya Man");
    namesMap.put("IN", "Índɛ");
    namesMap.put("IO", "Mabelé ya Angɛlɛtɛ́lɛ na mbú ya Indiya");
    namesMap.put("IQ", "Iraki");
    namesMap.put("IR", "Irâ");
    namesMap.put("IS", "Isilandɛ");
    namesMap.put("IT", "Itali");
    namesMap.put("JM", "Zamaiki");
    namesMap.put("JO", "Zɔdani");
    namesMap.put("JP", "Zapɔ");
    namesMap.put("KG", "Kigizisitá");
    namesMap.put("KH", "Kambodza");
    namesMap.put("KM", "Komorɛ");
    namesMap.put("KN", "Sántu krístofe mpé Nevɛ̀s");
    namesMap.put("KP", "Korɛ ya nɔ́rdi");
    namesMap.put("KR", "Korɛ ya súdi");
    namesMap.put("KW", "Koweti");
    namesMap.put("KY", "Bisanga bya Kayíma");
    namesMap.put("KZ", "Kazakisitá");
    namesMap.put("LA", "Lawosi");
    namesMap.put("LB", "Libá");
    namesMap.put("LC", "Sántu lisi");
    namesMap.put("LI", "Lishɛteni");
    namesMap.put("LK", "Sirilanka");
    namesMap.put("LR", "Libériya");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Litwani");
    namesMap.put("LU", "Likisambulu");
    namesMap.put("LV", "Letoni");
    namesMap.put("LY", "Libí");
    namesMap.put("MA", "Marokɛ");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Molidavi");
    namesMap.put("ME", "Monténégro");
    namesMap.put("MG", "Madagasikari");
    namesMap.put("MH", "Bisanga bya Marishalɛ");
    namesMap.put("MK", "Masedwanɛ");
    namesMap.put("ML", "Malí");
    namesMap.put("MM", "Birmanie");
    namesMap.put("MN", "Mongolí");
    namesMap.put("MP", "Bisanga bya Marianɛ ya nɔ́rdi");
    namesMap.put("MQ", "Martiniki");
    namesMap.put("MR", "Moritani");
    namesMap.put("MS", "Mɔsera");
    namesMap.put("MT", "Malitɛ");
    namesMap.put("MU", "Morisɛ");
    namesMap.put("MV", "Madívɛ");
    namesMap.put("MX", "Meksike");
    namesMap.put("MY", "Malezi");
    namesMap.put("MZ", "Mozambíki");
    namesMap.put("NA", "Namibi");
    namesMap.put("NC", "Kaledoni ya sika");
    namesMap.put("NE", "Nizɛrɛ");
    namesMap.put("NF", "Esanga Norfokɛ");
    namesMap.put("NG", "Nizerya");
    namesMap.put("NI", "Nikaragwa");
    namesMap.put("NL", "Olandɛ");
    namesMap.put("NO", "Norivezɛ");
    namesMap.put("NP", "Nepálɛ");
    namesMap.put("NU", "Nyué");
    namesMap.put("NZ", "Zelandɛ ya sika");
    namesMap.put("OM", "Ománɛ");
    namesMap.put("PE", "Péru");
    namesMap.put("PF", "Polinezi ya Falánsɛ");
    namesMap.put("PG", "Papwazi Ginɛ ya sika");
    namesMap.put("PH", "Filipinɛ");
    namesMap.put("PK", "Pakisitá");
    namesMap.put("PL", "Poloni");
    namesMap.put("PM", "Sántu pététo mpé Mikelɔ");
    namesMap.put("PN", "Pikairni");
    namesMap.put("PR", "Pɔtoriko");
    namesMap.put("PS", "Palɛsine");
    namesMap.put("PT", "Putúlugɛsi");
    namesMap.put("PY", "Palagwei");
    namesMap.put("QA", "Katari");
    namesMap.put("RE", "Lenyo");
    namesMap.put("RO", "Romani");
    namesMap.put("RS", "Serbie");
    namesMap.put("RU", "Risí");
    namesMap.put("SA", "Alabi Sawuditɛ");
    namesMap.put("SB", "Bisanga Solomɔ");
    namesMap.put("SC", "Sɛshɛlɛ");
    namesMap.put("SD", "Sudá");
    namesMap.put("SE", "Swédɛ");
    namesMap.put("SG", "Singapurɛ");
    namesMap.put("SH", "Sántu eleni");
    namesMap.put("SI", "Siloveni");
    namesMap.put("SJ", "Svalbard mpé Jan Mayen");
    namesMap.put("SK", "Silovaki");
    namesMap.put("SL", "Siera Leonɛ");
    namesMap.put("SM", "Sántu Marinɛ");
    namesMap.put("SN", "Senegalɛ");
    namesMap.put("SO", "Somali");
    namesMap.put("SR", "Surinamɛ");
    namesMap.put("SS", "Sudani ya Sidi");
    namesMap.put("ST", "Sao Tomé mpé Presipɛ");
    namesMap.put("SV", "Savadɔrɛ");
    namesMap.put("SY", "Sirí");
    namesMap.put("SZ", "Swazilandi");
    namesMap.put("TC", "Bisanga bya Turki mpé Kaiko");
    namesMap.put("TD", "Tsádi");
    namesMap.put("TF", "Terres australes et antarctiques françaises");
    namesMap.put("TH", "Tailandɛ");
    namesMap.put("TJ", "Tazikisitá");
    namesMap.put("TL", "Timorɛ ya Moniɛlɛ");
    namesMap.put("TM", "Tikɛménisitá");
    namesMap.put("TN", "Tinizi");
    namesMap.put("TR", "Tiliki");
    namesMap.put("TT", "Tinidadɛ mpé Tobago");
    namesMap.put("TW", "Taiwanin");
    namesMap.put("TZ", "Tanzani");
    namesMap.put("UA", "Ikrɛni");
    namesMap.put("US", "Ameriki");
    namesMap.put("UY", "Irigwei");
    namesMap.put("UZ", "Uzibɛkisitá");
    namesMap.put("VA", "Vatiká");
    namesMap.put("VC", "Sántu vesá mpé Gelenadinɛ");
    namesMap.put("VE", "Venézuela");
    namesMap.put("VG", "Bisanga bya Vierzi ya Angɛlɛtɛ́lɛ");
    namesMap.put("VI", "Bisanga bya Vierzi ya Ameriki");
    namesMap.put("VN", "Viyetinamɛ");
    namesMap.put("WF", "Walisɛ mpé Futuna");
    namesMap.put("YE", "Yemɛnɛ");
    namesMap.put("YT", "Mayotɛ");
    namesMap.put("ZA", "Afríka ya Súdi");
    namesMap.put("ZM", "Zambi");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Mabelé",
        "002": "Afríka",
        "003": "Ameríka ya Nola",
        "005": "Ameríka ya Sidi",
        "011": "Afríka ya Wɛ́sita",
        "013": "Ameríka ya káti",
        "014": "Afríka ya Ɛ́sita",
        "015": "Afríka ya Nola",
        "017": "Afríka ya Katikáti",
        "018": "Afríka ya Sidi",
        "019": "Ameríka",
        "030": "Azía ya Ɛ́sita",
        "034": "Azía ya Sidi",
        "035": "Azía ya Sidi-Ɛ́sita",
        "039": "Erópa ya Sidi",
        "142": "Azía",
        "143": "Azía ya Katikáti",
        "145": "Azía ya Wɛ́sita",
        "150": "Erópa",
        "151": "Erópa ya Ɛ́sita",
        "154": "Erópa ya Nola",
        "155": "Erópa ya Wɛ́sita",
        "419": "Ameríka Latína",
        "AC": "Esenga ya Mbuta o likoló",
        "AD": "Andorɛ",
        "AE": "Lɛmila alabo",
        "AF": "Afiganisitá",
        "AG": "Antiga mpé Barbuda",
        "AI": "Angiyɛ",
        "AL": "Alibani",
        "AM": "Amɛni",
        "AN": "Antiyɛ ya Olandɛ",
        "AO": "Angóla",
        "AQ": "Antarctique",
        "AR": "Arizantinɛ",
        "AS": "Samoa ya Ameriki",
        "AT": "Otilisi",
        "AU": "Ositáli",
        "AX": "Bisanga Ɛland",
        "AZ": "Azɛlɛbaizá",
        "BA": "Bosini mpé Hezegovine",
        "BB": "Barɛbadɛ",
        "BD": "Bengalidɛsi",
        "BE": "Beleziki",
        "BF": "Bukina Faso",
        "BG": "Biligari",
        "BH": "Bahrɛnɛ",
        "BJ": "Benɛ",
        "BN": "Brineyi",
        "BO": "Bolivi",
        "BR": "Brezílɛ",
        "BS": "Bahamasɛ",
        "BT": "Butáni",
        "BV": "Esenga Buvé",
        "BY": "Byelorisi",
        "BZ": "Belizɛ",
        "CA": "Kanada",
        "CC": "Bisanga Kokos",
        "CD": "Repibiki demokratiki ya Kongó",
        "CF": "Repibiki ya Afríka ya Káti",
        "CG": "Kongo",
        "CH": "Swisɛ",
        "CI": "Kotídivualɛ",
        "CK": "Bisanga bya Kookɛ",
        "CL": "Síli",
        "CM": "Kamɛrune",
        "CN": "Sinɛ",
        "CO": "Kolombi",
        "CR": "Kositarika",
        "CU": "Kiba",
        "CV": "Bisanga bya Kapevɛrɛ",
        "CX": "Esenga ya Mbótama",
        "CY": "Sípɛlɛ",
        "CZ": "Repibiki Tsekɛ",
        "DE": "Alemani",
        "DJ": "Dzibuti",
        "DK": "Danɛmarike",
        "DM": "Domínike",
        "DO": "Repibiki ya Domínikɛ",
        "DZ": "Alizɛri",
        "EA": "Zewta mpé Melílla",
        "EC": "Ekwatɛ́lɛ",
        "EE": "Esitoni",
        "EG": "Ezípite",
        "EH": "Sahara ya Limbɛ",
        "ER": "Elitelɛ",
        "ES": "Esipanye",
        "ET": "Etsíopi",
        "EU": "Lisangá ya Erópa",
        "FI": "Filandɛ",
        "FJ": "Fidzi",
        "FK": "Bisanga bya Maluni",
        "FM": "Mikronezi",
        "FO": "Bisanga ya Fɛróa",
        "FR": "Falánsɛ",
        "GA": "Gabɔ",
        "GB": "Angɛlɛtɛ́lɛ",
        "GD": "Gelenadɛ",
        "GE": "Zorzi",
        "GF": "Giyanɛ ya Falánsɛ",
        "GG": "Guernesey",
        "GH": "Gana",
        "GI": "Zibatalɛ",
        "GL": "Gowelande",
        "GM": "Gambi",
        "GN": "Ginɛ",
        "GP": "Gwadɛlupɛ",
        "GQ": "Ginɛ́kwatɛ́lɛ",
        "GR": "Geleki",
        "GS": "Îles de Géorgie du Sud et Sandwich du Sud",
        "GT": "Gwatémala",
        "GU": "Gwamɛ",
        "GW": "Ginɛbisau",
        "GY": "Giyane",
        "HM": "Ile Heard et Iles McDonald",
        "HN": "Ondurasɛ",
        "HR": "Krowasi",
        "HT": "Ayiti",
        "HU": "Ongili",
        "IC": "Bisanga bya Kanári",
        "ID": "Indonezi",
        "IE": "Irelandɛ",
        "IL": "Isirayelɛ",
        "IM": "Esanga ya Man",
        "IN": "Índɛ",
        "IO": "Mabelé ya Angɛlɛtɛ́lɛ na mbú ya Indiya",
        "IQ": "Iraki",
        "IR": "Irâ",
        "IS": "Isilandɛ",
        "IT": "Itali",
        "JM": "Zamaiki",
        "JO": "Zɔdani",
        "JP": "Zapɔ",
        "KG": "Kigizisitá",
        "KH": "Kambodza",
        "KM": "Komorɛ",
        "KN": "Sántu krístofe mpé Nevɛ̀s",
        "KP": "Korɛ ya nɔ́rdi",
        "KR": "Korɛ ya súdi",
        "KW": "Koweti",
        "KY": "Bisanga bya Kayíma",
        "KZ": "Kazakisitá",
        "LA": "Lawosi",
        "LB": "Libá",
        "LC": "Sántu lisi",
        "LI": "Lishɛteni",
        "LK": "Sirilanka",
        "LR": "Libériya",
        "LS": "Lesoto",
        "LT": "Litwani",
        "LU": "Likisambulu",
        "LV": "Letoni",
        "LY": "Libí",
        "MA": "Marokɛ",
        "MC": "Monako",
        "MD": "Molidavi",
        "ME": "Monténégro",
        "MG": "Madagasikari",
        "MH": "Bisanga bya Marishalɛ",
        "MK": "Masedwanɛ",
        "ML": "Malí",
        "MM": "Birmanie",
        "MN": "Mongolí",
        "MP": "Bisanga bya Marianɛ ya nɔ́rdi",
        "MQ": "Martiniki",
        "MR": "Moritani",
        "MS": "Mɔsera",
        "MT": "Malitɛ",
        "MU": "Morisɛ",
        "MV": "Madívɛ",
        "MX": "Meksike",
        "MY": "Malezi",
        "MZ": "Mozambíki",
        "NA": "Namibi",
        "NC": "Kaledoni ya sika",
        "NE": "Nizɛrɛ",
        "NF": "Esanga Norfokɛ",
        "NG": "Nizerya",
        "NI": "Nikaragwa",
        "NL": "Olandɛ",
        "NO": "Norivezɛ",
        "NP": "Nepálɛ",
        "NU": "Nyué",
        "NZ": "Zelandɛ ya sika",
        "OM": "Ománɛ",
        "PE": "Péru",
        "PF": "Polinezi ya Falánsɛ",
        "PG": "Papwazi Ginɛ ya sika",
        "PH": "Filipinɛ",
        "PK": "Pakisitá",
        "PL": "Poloni",
        "PM": "Sántu pététo mpé Mikelɔ",
        "PN": "Pikairni",
        "PR": "Pɔtoriko",
        "PS": "Palɛsine",
        "PT": "Putúlugɛsi",
        "PY": "Palagwei",
        "QA": "Katari",
        "RE": "Lenyo",
        "RO": "Romani",
        "RS": "Serbie",
        "RU": "Risí",
        "SA": "Alabi Sawuditɛ",
        "SB": "Bisanga Solomɔ",
        "SC": "Sɛshɛlɛ",
        "SD": "Sudá",
        "SE": "Swédɛ",
        "SG": "Singapurɛ",
        "SH": "Sántu eleni",
        "SI": "Siloveni",
        "SJ": "Svalbard mpé Jan Mayen",
        "SK": "Silovaki",
        "SL": "Siera Leonɛ",
        "SM": "Sántu Marinɛ",
        "SN": "Senegalɛ",
        "SO": "Somali",
        "SR": "Surinamɛ",
        "SS": "Sudani ya Sidi",
        "ST": "Sao Tomé mpé Presipɛ",
        "SV": "Savadɔrɛ",
        "SY": "Sirí",
        "SZ": "Swazilandi",
        "TC": "Bisanga bya Turki mpé Kaiko",
        "TD": "Tsádi",
        "TF": "Terres australes et antarctiques françaises",
        "TH": "Tailandɛ",
        "TJ": "Tazikisitá",
        "TL": "Timorɛ ya Moniɛlɛ",
        "TM": "Tikɛménisitá",
        "TN": "Tinizi",
        "TR": "Tiliki",
        "TT": "Tinidadɛ mpé Tobago",
        "TW": "Taiwanin",
        "TZ": "Tanzani",
        "UA": "Ikrɛni",
        "US": "Ameriki",
        "UY": "Irigwei",
        "UZ": "Uzibɛkisitá",
        "VA": "Vatiká",
        "VC": "Sántu vesá mpé Gelenadinɛ",
        "VE": "Venézuela",
        "VG": "Bisanga bya Vierzi ya Angɛlɛtɛ́lɛ",
        "VI": "Bisanga bya Vierzi ya Ameriki",
        "VN": "Viyetinamɛ",
        "WF": "Walisɛ mpé Futuna",
        "YE": "Yemɛnɛ",
        "YT": "Mayotɛ",
        "ZA": "Afríka ya Súdi",
        "ZM": "Zambi"
    };
  }-*/;
}
