/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import org.eclipse.birt.report.model.adapter.oda.IReportParameterAdapter;
import org.eclipse.birt.report.model.adapter.oda.impl.AbstractReportParameterAdapter;
import org.eclipse.birt.report.model.adapter.oda.impl.AdapterUtil;
import org.eclipse.birt.report.model.adapter.oda.impl.CompareUtil;
import org.eclipse.birt.report.model.adapter.oda.impl.DataSetParameterAdapter;
import org.eclipse.birt.report.model.adapter.oda.util.ParameterValueUtil;
import org.eclipse.birt.report.model.api.AbstractScalarParameterHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.OdaDataSetParameter;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataElementUIHints;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DynamicValuesQuery;
import org.eclipse.datatools.connectivity.oda.design.InputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputElementUIHints;
import org.eclipse.datatools.connectivity.oda.design.InputParameterAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputPromptControlStyle;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

class ReportParameterAdapter
extends AbstractReportParameterAdapter
implements IReportParameterAdapter {
    private String dataType;

    ReportParameterAdapter() {
    }

    public void updateLinkedReportParameter(ScalarParameterHandle reportParam, OdaDataSetParameterHandle dataSetParam) throws SemanticException {
        if (reportParam == null || dataSetParam == null) {
            return;
        }
        this.updateLinkedReportParameterFromROMParameter((AbstractScalarParameterHandle)reportParam, dataSetParam);
    }

    public void updateLinkedReportParameter(ScalarParameterHandle reportParam, OdaDataSetParameterHandle dataSetParam, DataSetDesign dataSetDesign) throws SemanticException {
        if (reportParam == null || dataSetParam == null) {
            return;
        }
        ParameterDefinition matchedParam = null;
        String dataType = null;
        OdaDataSetHandle setHandle = (OdaDataSetHandle)dataSetParam.getElementHandle();
        if (dataSetDesign != null) {
            matchedParam = ReportParameterAdapter.getValidParameterDefinition(dataSetParam, dataSetDesign.getParameters());
            dataType = DataSetParameterAdapter.getROMDataType(dataSetDesign.getOdaExtensionDataSourceId(), dataSetDesign.getOdaExtensionDataSetId(), (OdaDataSetParameter)dataSetParam.getStructure(), setHandle == null ? null : setHandle.parametersIterator());
        }
        CommandStack cmdStack = reportParam.getModuleHandle().getCommandStack();
        cmdStack.startTrans(null);
        try {
            if (matchedParam != null) {
                this.updateLinkedReportParameter(reportParam, matchedParam, null, dataType, (OdaDataSetHandle)dataSetParam.getElementHandle());
            }
            this.updateLinkedReportParameterFromROMParameter((AbstractScalarParameterHandle)reportParam, dataSetParam);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    boolean isUpdatedReportParameter(ScalarParameterHandle reportParam, ParameterDefinition odaParam, String newDataType) {
        if (reportParam == null || odaParam == null) {
            return true;
        }
        DataElementAttributes dataAttrs = odaParam.getAttributes();
        Boolean odaAllowNull = AdapterUtil.getROMNullability(dataAttrs.getNullability());
        boolean allowNull = this.getReportParamAllowMumble((AbstractScalarParameterHandle)reportParam, "allowNull");
        if (odaAllowNull != null && allowNull != odaAllowNull) {
            return false;
        }
        if (!"any".equalsIgnoreCase(newDataType) && !CompareUtil.isEquals(newDataType, reportParam.getDataType())) {
            return false;
        }
        DataElementUIHints dataUiHints = dataAttrs.getUiHints();
        if (dataUiHints != null) {
            String newPromptText = dataUiHints.getDisplayName();
            String newHelpText = dataUiHints.getDescription();
            if (!CompareUtil.isEquals(newPromptText, reportParam.getPromptText())) {
                return false;
            }
            if (!CompareUtil.isEquals(newHelpText, reportParam.getHelpText())) {
                return false;
            }
        }
        InputParameterAttributes paramAttrs = odaParam.getInputAttributes();
        InputParameterAttributes tmpParamDefn = null;
        DataSetDesign tmpDataSet = null;
        if (paramAttrs != null) {
            tmpParamDefn = (InputParameterAttributes)EcoreUtil.copy((EObject)paramAttrs);
            DynamicValuesQuery tmpDynamicQuery = tmpParamDefn.getElementAttributes().getDynamicValueChoices();
            if (tmpDynamicQuery != null) {
                tmpDataSet = tmpDynamicQuery.getDataSetDesign();
                tmpDynamicQuery.setDataSetDesign(null);
            }
            if (tmpParamDefn.getUiHints() != null) {
                tmpParamDefn.setUiHints(null);
            }
        } else {
            tmpParamDefn = this.designFactory.createInputParameterAttributes();
        }
        InputParameterAttributes tmpParamDefn1 = this.designFactory.createInputParameterAttributes();
        this.updateInputElementAttrs(tmpParamDefn1, (AbstractScalarParameterHandle)reportParam, null);
        if (tmpParamDefn1.getUiHints() != null) {
            tmpParamDefn1.setUiHints(null);
        }
        DynamicValuesQuery tmpDynamicQuery1 = tmpParamDefn1.getElementAttributes().getDynamicValueChoices();
        DataSetDesign tmpDataSet1 = null;
        if (tmpDynamicQuery1 != null) {
            tmpDataSet1 = tmpDynamicQuery1.getDataSetDesign();
            tmpDynamicQuery1.setDataSetDesign(null);
        }
        if (!EcoreUtil.equals((EObject)tmpDataSet, (EObject)tmpDataSet1)) {
            return false;
        }
        return EcoreUtil.equals((EObject)tmpParamDefn, (EObject)tmpParamDefn1);
    }

    protected void updateLinkedReportParameterFromROMParameter(AbstractScalarParameterHandle reportParam, OdaDataSetParameterHandle dataSetParam) throws SemanticException {
        assert (reportParam != null && reportParam instanceof ScalarParameterHandle);
        ScalarParameterHandle scalarParam = (ScalarParameterHandle)reportParam;
        String dataType = dataSetParam.getParameterDataType();
        if (!StringUtil.isBlank((String)dataType)) {
            if (!"any".equalsIgnoreCase(dataType)) {
                scalarParam.setDataType(dataType);
            } else {
                scalarParam.setDataType("string");
            }
        }
        super.updateLinkedReportParameterFromROMParameter(reportParam, dataSetParam);
    }

    protected InputParameterAttributes updateInputElementAttrs(InputParameterAttributes inputParamAttrs, AbstractScalarParameterHandle paramHandle, DataSetDesign dataSetDesign) {
        assert (paramHandle instanceof ScalarParameterHandle);
        ScalarParameterHandle scalarParam = (ScalarParameterHandle)paramHandle;
        InputParameterAttributes retInputParamAttrs = super.updateInputElementAttrs(inputParamAttrs, paramHandle, dataSetDesign);
        InputElementAttributes inputAttrs = retInputParamAttrs.getElementAttributes();
        inputAttrs.setMasksValue(scalarParam.isConcealValue());
        InputElementUIHints uiHints = this.designFactory.createInputElementUIHints();
        uiHints.setPromptStyle(AdapterUtil.newPromptStyle(scalarParam.getControlType(), scalarParam.isMustMatch()));
        PropertyHandle tmpPropHandle = paramHandle.getPropertyHandle("autoSuggestThreshold");
        if (tmpPropHandle.isSet()) {
            uiHints.setAutoSuggestThreshold(scalarParam.getAutoSuggestThreshold());
        }
        inputAttrs.setUiHints(uiHints);
        return retInputParamAttrs;
    }

    protected void setReportParamIsRequired(AbstractScalarParameterHandle param, String obsoletePropName, boolean value) throws SemanticException {
        assert (param instanceof ScalarParameterHandle);
        if ("allowNull".equalsIgnoreCase(obsoletePropName)) {
            ((ScalarParameterHandle)param).setAllowNull(value);
        } else if ("allowBlank".equalsIgnoreCase(obsoletePropName)) {
            ((ScalarParameterHandle)param).setAllowBlank(value);
        } else {
            super.setReportParamIsRequired(param, obsoletePropName, value);
        }
    }

    protected boolean getReportParamAllowMumble(AbstractScalarParameterHandle param, String propName) {
        assert (param instanceof ScalarParameterHandle);
        if ("allowNull".equalsIgnoreCase(propName)) {
            return ((ScalarParameterHandle)param).allowNull();
        }
        if ("allowBlank".equalsIgnoreCase(propName)) {
            return ((ScalarParameterHandle)param).allowBlank();
        }
        return super.getReportParamAllowMumble(param, propName);
    }

    protected String getROMDefaultValueLiteral(AbstractScalarParameterHandle setParam, String value) {
        assert (setParam instanceof ScalarParameterHandle);
        String literalValue = super.getROMDefaultValueLiteral(setParam, value);
        if (literalValue != null && AdapterUtil.needsQuoteDelimiters(((ScalarParameterHandle)setParam).getDataType())) {
            literalValue = ParameterValueUtil.isQuoted(value) ? ParameterValueUtil.toLiteralValue(value) : null;
        }
        return literalValue;
    }

    void updateLinkedReportParameter(ScalarParameterHandle reportParam, ParameterDefinition paramDefn, ParameterDefinition cachedParamDefn, String dataType, OdaDataSetHandle setHandle) throws SemanticException {
        if (this.isUpdatedReportParameter(reportParam, paramDefn, dataType)) {
            return;
        }
        this.dataType = dataType;
        this.updateLinkedReportParameter((AbstractScalarParameterHandle)reportParam, paramDefn, cachedParamDefn, setHandle);
    }

    protected void updateAbstractScalarParameter(AbstractScalarParameterHandle reportParam, ParameterDefinition paramDefn, ParameterDefinition cachedParamDefn, OdaDataSetHandle setHandle) throws SemanticException {
        assert (reportParam instanceof ScalarParameterHandle);
        if (this.dataType == null) {
            if (!"any".equalsIgnoreCase(this.dataType)) {
                ((ScalarParameterHandle)reportParam).setDataType(this.dataType);
            } else {
                ((ScalarParameterHandle)reportParam).setDataType("string");
            }
        }
        super.updateAbstractScalarParameter(reportParam, paramDefn, cachedParamDefn, setHandle);
    }

    protected void updateInputElementAttrsToReportParam(InputElementAttributes elementAttrs, InputElementAttributes cachedElementAttrs, AbstractScalarParameterHandle reportParam, OdaDataSetHandle setHandle) throws SemanticException {
        InputElementUIHints uiHints;
        Boolean cachedMasksValues;
        assert (reportParam instanceof ScalarParameterHandle);
        Boolean masksValue = elementAttrs.isMasksValue();
        Boolean bl = cachedMasksValues = cachedElementAttrs == null ? null : Boolean.valueOf(cachedElementAttrs.isMasksValue());
        if (!CompareUtil.isEquals(cachedMasksValues, masksValue)) {
            ((ScalarParameterHandle)reportParam).setConcealValue(masksValue.booleanValue());
        }
        if ((uiHints = elementAttrs.getUiHints()) != null) {
            InputPromptControlStyle cachedStyle;
            InputElementUIHints cachedUiHints = cachedElementAttrs == null ? null : cachedElementAttrs.getUiHints();
            InputPromptControlStyle style = uiHints.getPromptStyle();
            InputPromptControlStyle inputPromptControlStyle = cachedStyle = cachedUiHints == null ? null : cachedUiHints.getPromptStyle();
            if (cachedStyle == null || style != null && cachedStyle.getValue() != style.getValue()) {
                ((ScalarParameterHandle)reportParam).setControlType(style == null ? null : AdapterUtil.newROMControlType(style));
            }
            ((ScalarParameterHandle)reportParam).setAutoSuggestThreshold(uiHints.getAutoSuggestThreshold());
        }
        super.updateInputElementAttrsToReportParam(elementAttrs, cachedElementAttrs, reportParam, setHandle);
    }
}

