/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jpt.jaxb.core.internal.ClassesGenerator;
import org.eclipse.jpt.jaxb.ui.internal.JptJaxbUiMessages;
import org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen.ClassesGeneratorWizard;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ClassesGeneratorUi {
    private final IJavaProject javaProject;
    private final String xmlSchemaName;

    public static void generate(IFile xsdFile) {
        IJavaProject javaProject = JavaCore.create((IProject)xsdFile.getProject());
        if (javaProject == null) {
            throw new NullPointerException();
        }
        IPath xmlSchema = xsdFile.getProjectRelativePath();
        new ClassesGeneratorUi(javaProject, xmlSchema.toOSString()).generate();
    }

    private ClassesGeneratorUi(IJavaProject javaProject, String xmlSchemaName) {
        if (javaProject == null || StringTools.stringIsEmpty((String)xmlSchemaName)) {
            throw new NullPointerException();
        }
        this.javaProject = javaProject;
        this.xmlSchemaName = xmlSchemaName;
    }

    protected void generate() {
        ClassesGeneratorWizard wizard = new ClassesGeneratorWizard(this.javaProject, this.xmlSchemaName);
        WizardDialog dialog = new WizardDialog(this.getCurrentShell(), (IWizard)wizard);
        dialog.create();
        int returnCode = dialog.open();
        if (returnCode != 0) {
            return;
        }
        String outputDir = wizard.getDestinationFolder();
        String targetPackage = wizard.getTargetPackage();
        String catalog = wizard.getCatalog();
        boolean useMoxy = wizard.getUseMoxy();
        String[] bindingsFileNames = wizard.getBindingsFileNames();
        this.run(outputDir, targetPackage, catalog, useMoxy, bindingsFileNames);
    }

    private void run(String outputDir, String targetPackage, String catalog, boolean useMoxyGenerator, String[] bindingsFileNames) {
        IWorkspaceRunnable runnable = this.buildGenerateEntitiesRunnable(this.javaProject, this.xmlSchemaName, outputDir, targetPackage, catalog, useMoxyGenerator, bindingsFileNames);
        try {
            ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    private IWorkspaceRunnable buildGenerateEntitiesRunnable(IJavaProject javaProject, String xmlSchemaName, String outputDir, String targetPackage, String catalog, boolean useMoxyGenerator, String[] bindingsFileNames) {
        return new GenerateEntitiesRunnable(javaProject, xmlSchemaName, outputDir, targetPackage, catalog, useMoxyGenerator, bindingsFileNames);
    }

    private Shell getCurrentShell() {
        return Display.getCurrent().getActiveShell();
    }

    private static class GenerateEntitiesRunnable
    implements IWorkspaceRunnable {
        private final IJavaProject javaProject;
        private final String xmlSchemaName;
        private final String outputDir;
        private final String targetPackage;
        private final String catalog;
        private final boolean useMoxyGenerator;
        private final String[] bindingsFileNames;

        public GenerateEntitiesRunnable(IJavaProject javaProject, String xmlSchemaName, String outputDir, String targetPackage, String catalog, boolean useMoxyGenerator, String[] bindingsFileNames) {
            this.javaProject = javaProject;
            this.xmlSchemaName = xmlSchemaName;
            this.outputDir = outputDir;
            this.targetPackage = targetPackage;
            this.catalog = catalog;
            this.useMoxyGenerator = useMoxyGenerator;
            this.bindingsFileNames = bindingsFileNames;
        }

        public void run(IProgressMonitor monitor) {
            try {
                this.entitiesGeneratorGenerate(this.javaProject, this.xmlSchemaName, this.outputDir, this.targetPackage, this.catalog, this.useMoxyGenerator, this.bindingsFileNames, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                return;
            }
            catch (RuntimeException re) {
                String msg = re.getMessage();
                String message = msg == null ? re.toString() : msg;
                this.logError(message);
                throw new RuntimeException(re);
            }
        }

        private void entitiesGeneratorGenerate(IJavaProject javaProject, String xmlSchemaName, String outputDir, String targetPackage, String catalog, boolean useMoxyGenerator, String[] bindingsFileNames, IProgressMonitor monitor) {
            ClassesGenerator.generate(javaProject, xmlSchemaName, outputDir, targetPackage, catalog, useMoxyGenerator, bindingsFileNames, monitor);
        }

        private void logError(String message) {
            this.displayError(message);
        }

        private void displayError(String message) {
            MessageDialog.openError((Shell)this.getShell(), (String)JptJaxbUiMessages.ClassesGeneratorWizard_errorDialogTitle, (String)message);
        }

        private Shell getShell() {
            Shell[] shells;
            Shell shell;
            Display display = Display.getCurrent();
            Shell shell2 = shell = display == null ? null : display.getActiveShell();
            if (shell == null && display != null && (shells = display.getShells()).length > 0) {
                shell = shells[0];
            }
            return shell;
        }
    }
}

