/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.wizards.schemagen;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.jaxb.ui.internal.JptJaxbUiMessages;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ProjectWizardPage
extends WizardPage {
    private IJavaProject javaProject;
    private ProjectGroup projectGroup;

    protected ProjectWizardPage() {
        super("Java Project");
        this.setTitle(JptJaxbUiMessages.SchemaGeneratorWizardPage_title);
        this.setDescription(JptJaxbUiMessages.ProjectWizardPage_desc);
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        this.setControl(this.buildTopLevelControl(parent));
    }

    private Control buildTopLevelControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        this.projectGroup = new ProjectGroup(composite);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected IJavaProject getProject() {
        return this.javaProject;
    }

    private void setProject(IJavaProject project) {
        this.javaProject = project;
    }

    private void projectChanged() {
        this.setPageComplete(false);
        String projectName = this.projectGroup.getProjectName();
        if (!StringTools.stringIsEmpty((String)projectName)) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            this.setProject(JavaCore.create((IProject)project));
            this.setPageComplete(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProjectGroup {
        private Combo projectCombo;

        private ProjectGroup(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            this.buildLabel(composite, JptJaxbUiMessages.ProjectWizardPage_project);
            this.projectCombo = this.buildProjectCombo(composite, this.buildProjectComboSelectionListener());
            this.updateProjectCombo();
            ProjectWizardPage.this.setPageComplete(false);
        }

        private SelectionListener buildProjectComboSelectionListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    ProjectGroup.this.selectedProjectChanged();
                }

                public String toString() {
                    return "JavaProjectWizardPage project combo-box selection listener";
                }
            };
        }

        void selectedProjectChanged() {
            ProjectWizardPage.this.projectChanged();
        }

        protected String getProjectName() {
            return this.projectCombo.getText();
        }

        protected void updateProjectCombo() {
            this.projectCombo.removeAll();
            for (String name : this.getJavaProjectsNames()) {
                this.projectCombo.add(name);
            }
            if (ProjectWizardPage.this.javaProject != null) {
                this.projectCombo.select(this.projectCombo.indexOf(ProjectWizardPage.this.javaProject.getProject().getName()));
            }
        }

        private Iterable<String> getJavaProjectsNames() {
            return new TransformationIterable<IProject, String>(this.getJavaProjects()){

                protected String transform(IProject project) {
                    return project.getName();
                }
            };
        }

        private Iterable<IProject> getJavaProjects() {
            return new FilteringIterable<IProject>((Iterable)CollectionTools.collection(this.getProjects())){

                protected boolean accept(IProject next) {
                    try {
                        return next.hasNature("org.eclipse.jdt.core.javanature");
                    }
                    catch (CoreException coreException) {
                        return false;
                    }
                }
            };
        }

        private Iterator<IProject> getProjects() {
            return new ArrayIterator((Object[])this.sortedProjects());
        }

        private IProject[] sortedProjects() {
            return (IProject[])ArrayTools.sort((Object[])ResourcesPlugin.getWorkspace().getRoot().getProjects(), this.projectNameComparator());
        }

        private Comparator<IProject> projectNameComparator() {
            return new Comparator<IProject>(){

                @Override
                public int compare(IProject project1, IProject project2) {
                    return Collator.getInstance().compare(project1.getName(), project2.getName());
                }
            };
        }

        private Label buildLabel(Composite parent, String text) {
            Label label = new Label(parent, 16384);
            label.setLayoutData((Object)new GridData());
            label.setText(text);
            return label;
        }

        private Combo buildProjectCombo(Composite parent, SelectionListener listener) {
            Combo projectCombo = new Combo(parent, 8);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            projectCombo.setLayoutData((Object)gridData);
            projectCombo.addSelectionListener(listener);
            return projectCombo;
        }
    }
}

