/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;

public class ScopeAnalyzer {
    private static final IBinding[] NO_BINDING = new IBinding[0];
    public static final int METHODS = 1;
    public static final int VARIABLES = 2;
    public static final int TYPES = 4;
    public static final int CHECK_VISIBILITY = 16;
    private HashSet fTypesVisited = new HashSet();
    private JavaScriptUnit fRoot;

    public ScopeAnalyzer(JavaScriptUnit root) {
        this.fRoot = root;
    }

    private void clearLists() {
        this.fTypesVisited.clear();
    }

    private static String getSignature(IBinding binding) {
        if (binding != null) {
            switch (binding.getKind()) {
                case 4: {
                    StringBuffer buf = new StringBuffer();
                    buf.append('M');
                    buf.append(binding.getName()).append('(');
                    ITypeBinding[] parameters = ((IFunctionBinding)binding).getParameterTypes();
                    int i = 0;
                    while (i < parameters.length) {
                        if (i > 0) {
                            buf.append(',');
                        }
                        ITypeBinding paramType = parameters[i].getErasure();
                        buf.append(paramType.getQualifiedName());
                        ++i;
                    }
                    buf.append(')');
                    return buf.toString();
                }
                case 3: {
                    return String.valueOf('V') + binding.getName();
                }
                case 2: {
                    return String.valueOf('T') + binding.getName();
                }
            }
        }
        return null;
    }

    static final boolean hasFlag(int property, int flags) {
        return (flags & property) != 0;
    }

    private boolean addInherited(ITypeBinding binding, int flags, IBindingRequestor requestor) {
        ITypeBinding superClass;
        IFunctionBinding curr;
        int i;
        if (!this.fTypesVisited.add(binding)) {
            return false;
        }
        if (ScopeAnalyzer.hasFlag(2, flags)) {
            IVariableBinding[] variableBindings = binding.getDeclaredFields();
            i = 0;
            while (i < variableBindings.length) {
                if (requestor.acceptBinding((IBinding)variableBindings[i])) {
                    return true;
                }
                ++i;
            }
        }
        if (ScopeAnalyzer.hasFlag(1, flags)) {
            IFunctionBinding[] methodBindings = binding.getDeclaredMethods();
            i = 0;
            while (i < methodBindings.length) {
                curr = methodBindings[i];
                if (!curr.isConstructor() && requestor.acceptBinding((IBinding)curr)) {
                    return true;
                }
                ++i;
            }
        }
        if (ScopeAnalyzer.hasFlag(4, flags)) {
            ITypeBinding[] typeBindings = binding.getDeclaredTypes();
            i = 0;
            while (i < typeBindings.length) {
                curr = typeBindings[i];
                if (requestor.acceptBinding((IBinding)curr)) {
                    return true;
                }
                ++i;
            }
        }
        return (superClass = binding.getSuperclass()) != null ? this.addInherited(superClass, flags, requestor) : binding.isArray() && this.addInherited(this.fRoot.getAST().resolveWellKnownType("java.lang.Object"), flags, requestor);
    }

    private boolean addTypeDeclarations(ITypeBinding binding, int flags, IBindingRequestor requestor) {
        if (ScopeAnalyzer.hasFlag(4, flags) && !binding.isAnonymous() && requestor.acceptBinding((IBinding)binding)) {
            return true;
        }
        this.addInherited(binding, flags, requestor);
        if (binding.isLocal()) {
            this.addOuterDeclarationsForLocalType(binding, flags, requestor);
        } else {
            ITypeBinding declaringClass = binding.getDeclaringClass();
            if (declaringClass != null) {
                if (this.addTypeDeclarations(declaringClass, flags, requestor)) {
                    return true;
                }
            } else if (ScopeAnalyzer.hasFlag(4, flags) && this.fRoot.findDeclaringNode((IBinding)binding) != null) {
                List types = this.fRoot.types();
                int i = 0;
                while (i < types.size()) {
                    if (requestor.acceptBinding((IBinding)((AbstractTypeDeclaration)types.get(i)).resolveBinding())) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    private boolean addOuterDeclarationsForLocalType(ITypeBinding localBinding, int flags, IBindingRequestor requestor) {
        ASTNode node = this.fRoot.findDeclaringNode((IBinding)localBinding);
        if (node == null) {
            return false;
        }
        if (node instanceof AbstractTypeDeclaration || node instanceof AnonymousClassDeclaration) {
            if (this.addLocalDeclarations(node.getParent(), flags, requestor)) {
                return true;
            }
            ITypeBinding parentTypeBinding = Bindings.getBindingOfParentType(node.getParent());
            if (parentTypeBinding != null && this.addTypeDeclarations(parentTypeBinding, flags, requestor)) {
                return true;
            }
        } else if (node instanceof JavaScriptUnit) {
            this.addLocalDeclarations(node, flags, requestor);
            ITypeBinding parentTypeBinding = Bindings.getBindingOfParentType(node.getParent());
            if (parentTypeBinding != null && this.addTypeDeclarations(parentTypeBinding, flags, requestor)) {
                return true;
            }
            IJavaScriptElement element = ((JavaScriptUnit)node).getJavaElement();
            try {
                SearchableEnvironment env = element.newSearchableNameEnvironment(new IJavaScriptUnit[0]);
            }
            catch (JavaScriptModelException ex) {
                ex.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private static ITypeBinding getBinding(Expression node) {
        if (node != null) {
            return node.resolveTypeBinding();
        }
        return null;
    }

    private static ITypeBinding getQualifier(SimpleName selector) {
        ASTNode normalizedNode;
        ASTNode parent = selector.getParent();
        switch (parent.getNodeType()) {
            case 32: {
                FunctionInvocation decl = (FunctionInvocation)parent;
                if (selector == decl.getName()) {
                    return ScopeAnalyzer.getBinding(decl.getExpression());
                }
                return null;
            }
            case 40: {
                QualifiedName qualifiedName = (QualifiedName)parent;
                if (selector == qualifiedName.getName()) {
                    return ScopeAnalyzer.getBinding((Expression)qualifiedName.getQualifier());
                }
                return null;
            }
            case 22: {
                FieldAccess fieldAccess = (FieldAccess)parent;
                if (selector == fieldAccess.getName()) {
                    return ScopeAnalyzer.getBinding(fieldAccess.getExpression());
                }
                return null;
            }
            case 47: {
                ITypeBinding curr = Bindings.getBindingOfParentType(parent);
                return curr.getSuperclass();
            }
            case 48: {
                SuperMethodInvocation superInv = (SuperMethodInvocation)parent;
                if (selector == superInv.getName()) {
                    ITypeBinding curr = Bindings.getBindingOfParentType(parent);
                    return curr.getSuperclass();
                }
                return null;
            }
        }
        if (parent instanceof Type && (normalizedNode = ASTNodes.getNormalizedNode(parent)).getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY) {
            ClassInstanceCreation creation = (ClassInstanceCreation)normalizedNode.getParent();
            return ScopeAnalyzer.getBinding(creation.getExpression());
        }
        return null;
    }

    public IBinding[] getDeclarationsInScope(SimpleName selector, int flags) {
        block6: {
            try {
                ITypeBinding parentTypeBinding;
                if (selector.getLocationInParent() == SwitchCase.EXPRESSION_PROPERTY) {
                    ((SwitchStatement)selector.getParent().getParent()).getExpression().resolveTypeBinding();
                }
                if ((parentTypeBinding = Bindings.getBindingOfParentType((ASTNode)selector)) == null) break block6;
                ITypeBinding binding = ScopeAnalyzer.getQualifier(selector);
                DefaultBindingRequestor requestor = new DefaultBindingRequestor(parentTypeBinding, flags);
                if (binding == null) {
                    this.addLocalDeclarations((ASTNode)selector, flags, requestor);
                    this.addTypeDeclarations(parentTypeBinding, flags, requestor);
                } else {
                    this.addInherited(binding, flags, requestor);
                }
                List result = requestor.getResult();
                IBinding[] iBindingArray = result.toArray(new IBinding[result.size()]);
                Object var7_9 = null;
                this.clearLists();
                return iBindingArray;
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                this.clearLists();
                throw throwable;
            }
        }
        IBinding[] iBindingArray = NO_BINDING;
        Object var7_10 = null;
        this.clearLists();
        return iBindingArray;
    }

    public boolean isDeclaredInScope(IBinding declaration, SimpleName selector, int flags) {
        block7: {
            SearchRequestor requestor;
            ITypeBinding binding;
            block8: {
                ITypeBinding parentTypeBinding;
                block9: {
                    try {
                        if (selector.getLocationInParent() == SwitchCase.EXPRESSION_PROPERTY) {
                            ((SwitchStatement)selector.getParent().getParent()).getExpression().resolveTypeBinding();
                        }
                        if ((parentTypeBinding = Bindings.getBindingOfParentTypeContext((ASTNode)selector)) == null) break block7;
                        binding = ScopeAnalyzer.getQualifier(selector);
                        requestor = new SearchRequestor(declaration, parentTypeBinding, flags);
                        if (binding != null) break block8;
                        this.addLocalDeclarations((ASTNode)selector, flags, requestor);
                        if (!requestor.found()) break block9;
                        boolean bl = requestor.isVisible();
                        Object var7_10 = null;
                        this.clearLists();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        Object var7_14 = null;
                        this.clearLists();
                        throw throwable;
                    }
                }
                this.addTypeDeclarations(parentTypeBinding, flags, requestor);
                if (requestor.found()) {
                    boolean bl = requestor.isVisible();
                    Object var7_11 = null;
                    this.clearLists();
                    return bl;
                }
                break block7;
            }
            this.addInherited(binding, flags, requestor);
            if (!requestor.found()) break block7;
            boolean bl = requestor.isVisible();
            Object var7_12 = null;
            this.clearLists();
            return bl;
        }
        Object var7_13 = null;
        this.clearLists();
        return false;
    }

    public IBinding[] getDeclarationsInScope(int offset, int flags) {
        NodeFinder finder = new NodeFinder(offset, 0);
        this.fRoot.accept((ASTVisitor)finder);
        ASTNode node = finder.getCoveringNode();
        if (node == null) {
            return NO_BINDING;
        }
        if (node instanceof SimpleName) {
            return this.getDeclarationsInScope((SimpleName)node, flags);
        }
        try {
            ITypeBinding binding = Bindings.getBindingOfParentType(node);
            DefaultBindingRequestor requestor = new DefaultBindingRequestor(binding, flags);
            this.addLocalDeclarations(node, offset, flags, requestor);
            if (binding != null) {
                this.addTypeDeclarations(binding, flags, requestor);
            }
            List result = requestor.getResult();
            IBinding[] iBindingArray = result.toArray(new IBinding[result.size()]);
            Object var8_9 = null;
            this.clearLists();
            return iBindingArray;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.clearLists();
            throw throwable;
        }
    }

    private static ITypeBinding getDeclaringType(IBinding binding) {
        switch (binding.getKind()) {
            case 3: {
                return ((IVariableBinding)binding).getDeclaringClass();
            }
            case 4: {
                return ((IFunctionBinding)binding).getDeclaringClass();
            }
            case 2: {
                ITypeBinding typeBinding = (ITypeBinding)binding;
                if (typeBinding.getDeclaringClass() != null) {
                    return typeBinding;
                }
                return typeBinding;
            }
        }
        return null;
    }

    public static boolean isVisible(IBinding binding, ITypeBinding context) {
        if (binding.getKind() == 3 && !((IVariableBinding)binding).isField()) {
            return true;
        }
        ITypeBinding declaring = ScopeAnalyzer.getDeclaringType(binding);
        if (declaring == null) {
            return false;
        }
        int modifiers = binding.getModifiers();
        if (Modifier.isPublic((int)modifiers)) {
            return true;
        }
        if (Modifier.isProtected((int)modifiers) || !Modifier.isPrivate((int)modifiers)) {
            if (declaring.getPackage() == context.getPackage()) {
                return true;
            }
            return ScopeAnalyzer.isTypeInScope(declaring, context, Modifier.isProtected((int)modifiers));
        }
        return ScopeAnalyzer.isTypeInScope(declaring, context, false);
    }

    private static boolean isTypeInScope(ITypeBinding declaring, ITypeBinding context, boolean includeHierarchy) {
        ITypeBinding curr = context;
        while (curr != null && curr != declaring) {
            if (includeHierarchy && Bindings.isSuperType(declaring, curr)) {
                return true;
            }
            curr = curr.getDeclaringClass();
        }
        return curr == declaring;
    }

    public IBinding[] getDeclarationsAfter(int offset, int flags) {
        block6: {
            ASTNode node;
            block5: {
                NodeFinder finder = new NodeFinder(offset, 0);
                this.fRoot.accept((ASTVisitor)finder);
                node = finder.getCoveringNode();
                if (node != null) break block5;
                Object var9_5 = null;
                this.clearLists();
                return null;
            }
            try {
                Statement declaration = ASTResolving.findParentStatement(node);
                while (declaration instanceof Statement && declaration.getNodeType() != 8) {
                    declaration = declaration.getParent();
                }
                if (!(declaration instanceof Block)) break block6;
                DefaultBindingRequestor requestor = new DefaultBindingRequestor();
                DeclarationsAfterVisitor visitor = new DeclarationsAfterVisitor(node.getStartPosition(), flags, requestor);
                declaration.accept((ASTVisitor)visitor);
                List result = requestor.getResult();
                IBinding[] iBindingArray = result.toArray(new IBinding[result.size()]);
                Object var9_6 = null;
                this.clearLists();
                return iBindingArray;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                this.clearLists();
                throw throwable;
            }
        }
        IBinding[] iBindingArray = NO_BINDING;
        Object var9_7 = null;
        this.clearLists();
        return iBindingArray;
    }

    private boolean addLocalDeclarations(ASTNode node, int flags, IBindingRequestor requestor) {
        return this.addLocalDeclarations(node, node.getStartPosition(), flags, requestor);
    }

    private boolean addLocalDeclarations(ASTNode node, int offset, int flags, IBindingRequestor requestor) {
        BodyDeclaration declaration;
        if ((ScopeAnalyzer.hasFlag(2, flags) || ScopeAnalyzer.hasFlag(4, flags)) && ((declaration = ASTResolving.findParentBodyDeclaration(node)) instanceof FunctionDeclaration || declaration instanceof Initializer)) {
            ScopeAnalyzerVisitor visitor = new ScopeAnalyzerVisitor(offset, flags, requestor);
            declaration.accept((ASTVisitor)visitor);
            return visitor.fBreak;
        }
        return false;
    }

    public Collection getUsedVariableNames(int offset, int length) {
        HashSet<String> result = new HashSet<String>();
        IBinding[] bindingsBefore = this.getDeclarationsInScope(offset, 2);
        int i = 0;
        while (i < bindingsBefore.length) {
            result.add(bindingsBefore[i].getName());
            ++i;
        }
        IBinding[] bindingsAfter = this.getDeclarationsAfter(offset + length, 2);
        int i2 = 0;
        while (i2 < bindingsAfter.length) {
            result.add(bindingsAfter[i2].getName());
            ++i2;
        }
        List imports = this.fRoot.imports();
        int i3 = 0;
        while (i3 < imports.size()) {
            ImportDeclaration decl = (ImportDeclaration)imports.get(i3);
            if (decl.isStatic() && !decl.isOnDemand()) {
                result.add(ASTNodes.getSimpleNameIdentifier(decl.getName()));
            }
            ++i3;
        }
        return result;
    }

    private class DeclarationsAfterVisitor
    extends HierarchicalASTVisitor {
        private final int fPosition;
        private final int fFlags;
        private final IBindingRequestor fRequestor;
        private boolean fBreak;

        public DeclarationsAfterVisitor(int position, int flags, IBindingRequestor requestor) {
            this.fPosition = position;
            this.fFlags = flags;
            this.fRequestor = requestor;
            this.fBreak = false;
        }

        public boolean visit(ASTNode node) {
            return !this.fBreak;
        }

        public boolean visit(VariableDeclaration node) {
            if (ScopeAnalyzer.hasFlag(2, this.fFlags) && this.fPosition < node.getStartPosition()) {
                this.fBreak = this.fRequestor.acceptBinding((IBinding)node.resolveBinding());
            }
            return false;
        }

        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        public boolean visit(TypeDeclarationStatement node) {
            if (ScopeAnalyzer.hasFlag(4, this.fFlags) && this.fPosition < node.getStartPosition()) {
                this.fBreak = this.fRequestor.acceptBinding((IBinding)node.resolveBinding());
            }
            return false;
        }
    }

    private static class DefaultBindingRequestor
    implements IBindingRequestor {
        private final List fResult;
        private final HashSet fNamesAdded;
        private final int fFlags;
        private final ITypeBinding fParentTypeBinding;

        public DefaultBindingRequestor(ITypeBinding parentTypeBinding, int flags) {
            this.fParentTypeBinding = parentTypeBinding;
            this.fFlags = flags;
            this.fResult = new ArrayList();
            this.fNamesAdded = new HashSet();
        }

        public DefaultBindingRequestor() {
            this(null, 0);
        }

        public boolean acceptBinding(IBinding binding) {
            if (binding == null) {
                return false;
            }
            String signature = ScopeAnalyzer.getSignature(binding);
            if (signature != null && this.fNamesAdded.add(signature)) {
                this.fResult.add(binding);
            }
            return false;
        }

        public List getResult() {
            if (ScopeAnalyzer.hasFlag(16, this.fFlags)) {
                int i = this.fResult.size() - 1;
                while (i >= 0) {
                    IBinding binding = (IBinding)this.fResult.get(i);
                    if (!ScopeAnalyzer.isVisible(binding, this.fParentTypeBinding)) {
                        this.fResult.remove(i);
                    }
                    --i;
                }
            }
            return this.fResult;
        }
    }

    private static interface IBindingRequestor {
        public boolean acceptBinding(IBinding var1);
    }

    private class ScopeAnalyzerVisitor
    extends HierarchicalASTVisitor {
        private int fPosition;
        private int fFlags;
        private final IBindingRequestor fRequestor;
        private boolean fBreak;

        public ScopeAnalyzerVisitor(int position, int flags, IBindingRequestor requestor) {
            this.fPosition = position;
            this.fFlags = flags;
            this.fRequestor = requestor;
            this.fBreak = false;
        }

        private boolean isInside(ASTNode node) {
            int start = node.getStartPosition();
            int end = start + node.getLength();
            return start <= this.fPosition && this.fPosition < end;
        }

        public boolean visit(FunctionDeclaration node) {
            if (this.isInside((ASTNode)node)) {
                Block body = node.getBody();
                if (body != null) {
                    body.accept((ASTVisitor)this);
                }
                this.visitBackwards(node.parameters());
            }
            return false;
        }

        public boolean visit(SwitchCase node) {
            if (ScopeAnalyzer.hasFlag(2, this.fFlags) && !node.isDefault() && this.isInside((ASTNode)node.getExpression())) {
                SwitchStatement switchStatement = (SwitchStatement)node.getParent();
                switchStatement.getExpression().resolveTypeBinding();
            }
            return false;
        }

        public boolean visit(Initializer node) {
            return !this.fBreak && this.isInside((ASTNode)node);
        }

        public boolean visit(Statement node) {
            return !this.fBreak && this.isInside((ASTNode)node);
        }

        public boolean visit(ASTNode node) {
            return false;
        }

        public boolean visit(Block node) {
            if (this.isInside((ASTNode)node)) {
                this.visitBackwards(node.statements());
            }
            return false;
        }

        public boolean visit(VariableDeclaration node) {
            if (ScopeAnalyzer.hasFlag(2, this.fFlags) && node.getStartPosition() < this.fPosition) {
                this.fBreak = this.fRequestor.acceptBinding((IBinding)node.resolveBinding());
            }
            return !this.fBreak;
        }

        public boolean visit(VariableDeclarationStatement node) {
            this.visitBackwards(node.fragments());
            return false;
        }

        public boolean visit(VariableDeclarationExpression node) {
            this.visitBackwards(node.fragments());
            return false;
        }

        public boolean visit(CatchClause node) {
            if (this.isInside((ASTNode)node)) {
                node.getBody().accept((ASTVisitor)this);
                node.getException().accept((ASTVisitor)this);
            }
            return false;
        }

        public boolean visit(ForStatement node) {
            if (this.isInside((ASTNode)node)) {
                node.getBody().accept((ASTVisitor)this);
                this.visitBackwards(node.initializers());
            }
            return false;
        }

        public boolean visit(ForInStatement node) {
            if (this.isInside((ASTNode)node)) {
                node.getBody().accept((ASTVisitor)this);
                node.getIterationVariable().accept((ASTVisitor)this);
            }
            return false;
        }

        public boolean visit(TypeDeclarationStatement node) {
            if (ScopeAnalyzer.hasFlag(4, this.fFlags) && node.getStartPosition() + node.getLength() < this.fPosition) {
                this.fBreak = node.getAST().apiLevel() == 2 ? this.fRequestor.acceptBinding((IBinding)node.getTypeDeclaration().resolveBinding()) : this.fRequestor.acceptBinding(node.getDeclaration().getName().resolveBinding());
                return false;
            }
            return !this.fBreak && this.isInside((ASTNode)node);
        }

        private void visitBackwards(List list) {
            if (this.fBreak) {
                return;
            }
            int i = list.size() - 1;
            while (i >= 0) {
                ASTNode curr = (ASTNode)list.get(i);
                if (curr.getStartPosition() < this.fPosition) {
                    curr.accept((ASTVisitor)this);
                }
                --i;
            }
        }
    }

    private static class SearchRequestor
    implements IBindingRequestor {
        private final int fFlags;
        private final ITypeBinding fParentTypeBinding;
        private final IBinding fToSearch;
        private boolean fFound;
        private boolean fIsVisible;

        public SearchRequestor(IBinding toSearch, ITypeBinding parentTypeBinding, int flag) {
            this.fFlags = flag;
            this.fToSearch = toSearch;
            this.fParentTypeBinding = parentTypeBinding;
            this.fFound = false;
            this.fIsVisible = true;
        }

        public boolean acceptBinding(IBinding binding) {
            if (this.fFound) {
                return true;
            }
            if (binding == null) {
                return false;
            }
            if (this.fToSearch.getKind() != binding.getKind()) {
                return false;
            }
            boolean checkVisibility = ScopeAnalyzer.hasFlag(16, this.fFlags);
            if (binding == this.fToSearch) {
                this.fFound = true;
            } else {
                String signature;
                IBinding bindingDeclaration = Bindings.getDeclaration(binding);
                if (bindingDeclaration == this.fToSearch) {
                    this.fFound = true;
                } else if (bindingDeclaration.getName().equals(this.fToSearch.getName()) && (signature = ScopeAnalyzer.getSignature(bindingDeclaration)) != null && signature.equals(ScopeAnalyzer.getSignature(this.fToSearch))) {
                    if (checkVisibility) {
                        this.fIsVisible = false;
                    }
                    return true;
                }
            }
            if (this.fFound && checkVisibility) {
                this.fIsVisible = ScopeAnalyzer.isVisible(binding, this.fParentTypeBinding);
            }
            return this.fFound;
        }

        public boolean found() {
            return this.fFound;
        }

        public boolean isVisible() {
            return this.fIsVisible;
        }
    }
}

