/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.loader;

import com.ibm.icu.text.MessageFormat;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCSchema;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.Messages;
import org.eclipse.datatools.connectivity.sqm.loader.SchemaFilterProvider;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Schema;

public class JDBCSchemaLoader
extends JDBCBaseLoader {
    public static final String COLUMN_TABLE_SCHEM = "TABLE_SCHEM";
    public static final String COLUMN_TABLE_CATALOG = "TABLE_CATALOG";
    private Set mSupportedColumns;

    public JDBCSchemaLoader(ICatalogObject catalogObject) {
        this(catalogObject, new SchemaFilterProvider());
    }

    public JDBCSchemaLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        assert (catalogObject instanceof Catalog);
    }

    public List loadSchemas() throws SQLException {
        ArrayList retVal = new ArrayList();
        this.loadSchemas(retVal, Collections.EMPTY_SET);
        return retVal;
    }

    public void loadSchemas(List containmentList, Collection existingSchemas) throws SQLException {
        ResultSet rs = null;
        try {
            this.initActiveFilter();
            rs = this.createResultSet();
            if (this.mSupportedColumns == null) {
                this.mSupportedColumns = new TreeSet();
                ResultSetMetaData rsmd = rs.getMetaData();
                int colNum = 1;
                int colCount = rsmd.getColumnCount();
                while (colNum <= colCount) {
                    this.mSupportedColumns.add(rsmd.getColumnName(colNum));
                    ++colNum;
                }
            }
            while (rs.next()) {
                String schemaName;
                if (!this.isSchemaInCatalog(rs) || (schemaName = rs.getString(COLUMN_TABLE_SCHEM)) == null || this.isFiltered(schemaName)) continue;
                Schema schema = (Schema)this.getAndRemoveSQLObject(existingSchemas, schemaName);
                if (schema == null) {
                    schema = this.processRow(rs);
                    if (schema == null) continue;
                    containmentList.add(schema);
                    continue;
                }
                containmentList.add(schema);
                if (!(schema instanceof ICatalogObject)) continue;
                ((ICatalogObject)schema).refresh();
            }
        }
        finally {
            if (rs != null) {
                this.closeResultSet(rs);
            }
        }
    }

    public void clearSchemas(List schemas) {
        schemas.clear();
    }

    protected ResultSet createResultSet() throws SQLException {
        try {
            return this.getCatalogObject().getConnection().getMetaData().getSchemas();
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getSchemas()"}));
            error.initCause(e);
            throw error;
        }
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {}
    }

    protected Schema processRow(ResultSet rs) throws SQLException {
        Schema schema = this.createSchema();
        this.initialize(schema, rs);
        return schema;
    }

    protected boolean isSchemaInCatalog(ResultSet rs) throws SQLException {
        boolean caseSensitive;
        DatabaseMetaData databaseMetaData = this.getCatalogObject().getConnection().getMetaData();
        boolean bl = caseSensitive = databaseMetaData.supportsMixedCaseIdentifiers() || databaseMetaData.supportsMixedCaseQuotedIdentifiers();
        if (this.mSupportedColumns.contains(COLUMN_TABLE_CATALOG)) {
            Catalog catalog = this.getCatalog();
            String catalogName = rs.getString(COLUMN_TABLE_CATALOG);
            if (catalogName != null) {
                if (caseSensitive) {
                    return catalog.getName().equalsIgnoreCase(catalogName.toLowerCase());
                }
                return catalog.getName().equals(catalogName);
            }
        }
        return caseSensitive && this.getCatalog().getName().equals(this.getCatalogObject().getConnection().getCatalog()) || !caseSensitive && this.getCatalog().getName().equalsIgnoreCase(this.getCatalogObject().getConnection().getCatalog()) || this.getCatalog().getName().length() == 0 && this.getCatalogObject().getConnection().getCatalog() == null;
    }

    protected Schema createSchema() {
        return new JDBCSchema();
    }

    protected void initialize(Schema schema, ResultSet rs) throws SQLException {
        schema.setName(rs.getString(COLUMN_TABLE_SCHEM));
    }

    protected Catalog getCatalog() {
        return (Catalog)this.getCatalogObject();
    }
}

