/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JoinTable;
import org.eclipse.jpt.core.context.JoinTableEnabledRelationshipReference;
import org.eclipse.jpt.core.context.JoinTableJoiningStrategy;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.java.JavaJoinTable;
import org.eclipse.jpt.core.context.java.JavaJoinTableJoiningStrategy;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.core.resource.java.JoinTableAnnotation;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaJoinTableJoiningStrategy
extends AbstractJavaJpaContextNode
implements JavaJoinTableJoiningStrategy {
    protected JavaJoinTable joinTable;

    protected AbstractJavaJoinTableJoiningStrategy(JoinTableEnabledRelationshipReference parent) {
        super(parent);
    }

    @Override
    public JoinTableEnabledRelationshipReference getParent() {
        return (JoinTableEnabledRelationshipReference)super.getParent();
    }

    @Override
    public JoinTableEnabledRelationshipReference getRelationshipReference() {
        return this.getParent();
    }

    public RelationshipMapping getRelationshipMapping() {
        return this.getRelationshipReference().getRelationshipMapping();
    }

    @Override
    public String getTableName() {
        return this.getJoinTable().getName();
    }

    @Override
    public Table getDbTable(String tableName) {
        return this.getJoinTable().getDbTable();
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return !StringTools.stringsAreEqual((String)this.getTableName(), (String)tableName);
    }

    @Override
    public String getColumnTableNotValidDescription() {
        return JpaValidationDescriptionMessages.DOES_NOT_MATCH_JOIN_TABLE;
    }

    @Override
    public String getJoinTableDefaultName() {
        return MappingTools.buildJoinTableDefaultName(this.getRelationshipReference());
    }

    @Override
    public void addStrategy() {
        if (this.joinTable == null) {
            this.joinTable = this.getJpaFactory().buildJavaJoinTable(this);
            this.addAnnotation();
            this.firePropertyChanged("joinTable", null, this.joinTable);
        }
    }

    @Override
    public void removeStrategy() {
        if (this.joinTable != null) {
            JavaJoinTable oldJoinTable = this.joinTable;
            this.joinTable = null;
            this.removeAnnotation();
            this.firePropertyChanged("joinTable", oldJoinTable, null);
        }
    }

    @Override
    public void initializeFrom(JoinTableJoiningStrategy oldStrategy) {
        JoinTable oldJoinTable = oldStrategy.getJoinTable();
        if (oldJoinTable != null) {
            this.addStrategy();
            this.getJoinTable().setSpecifiedCatalog(oldJoinTable.getSpecifiedCatalog());
            this.getJoinTable().setSpecifiedSchema(oldJoinTable.getSpecifiedSchema());
            this.getJoinTable().setSpecifiedName(oldJoinTable.getSpecifiedName());
        }
    }

    @Override
    public JavaJoinTable getJoinTable() {
        return this.joinTable;
    }

    protected void setJoinTable_(JavaJoinTable newJoinTable) {
        JavaJoinTable oldJoinTable = this.joinTable;
        this.joinTable = newJoinTable;
        this.firePropertyChanged("joinTable", oldJoinTable, newJoinTable);
    }

    protected abstract JoinTableAnnotation addAnnotation();

    protected abstract void removeAnnotation();

    protected boolean mayHaveJoinTable() {
        return this.getAnnotation().isSpecified() || this.getRelationshipReference().mayHaveDefaultJoinTable();
    }

    @Override
    public void initialize() {
        JoinTableAnnotation annotation = this.getAnnotation();
        if (this.mayHaveJoinTable()) {
            this.joinTable = this.getJpaFactory().buildJavaJoinTable(this);
            this.joinTable.initialize(annotation);
        }
    }

    @Override
    public void update() {
        JoinTableAnnotation annotation = this.getAnnotation();
        if (this.mayHaveJoinTable()) {
            if (this.joinTable == null) {
                this.setJoinTable_(this.getJpaFactory().buildJavaJoinTable(this));
            }
            this.joinTable.update(annotation);
        } else if (this.joinTable != null) {
            this.setJoinTable_(null);
        }
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result == null && this.joinTable != null) {
            result = this.joinTable.javaCompletionProposals(pos, filter, astRoot);
        }
        return result;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.joinTable != null) {
            this.joinTable.validate(messages, reporter, astRoot);
        }
    }
}

