/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ListIterator;
import org.eclipse.jpt.core.context.orm.OrmAttributeMappingDefinition;
import org.eclipse.jpt.core.context.orm.OrmTypeMappingDefinition;
import org.eclipse.jpt.core.context.orm.OrmXmlContextNodeFactory;
import org.eclipse.jpt.core.context.orm.OrmXmlDefinition;
import org.eclipse.jpt.core.context.orm.UnsupportedOrmAttributeMappingDefinition;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.Tools;
import org.eclipse.jpt.utility.internal.iterators.ArrayListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmXmlDefinition
implements OrmXmlDefinition {
    private OrmTypeMappingDefinition[] ormTypeMappingDefinitions;
    private OrmAttributeMappingDefinition[] ormAttributeMappingDefinitions;
    private final OrmXmlContextNodeFactory factory = this.buildContextNodeFactory();

    protected AbstractOrmXmlDefinition() {
    }

    protected abstract OrmXmlContextNodeFactory buildContextNodeFactory();

    @Override
    public OrmXmlContextNodeFactory getContextNodeFactory() {
        return this.factory;
    }

    @Override
    public OrmTypeMappingDefinition getOrmTypeMappingDefinition(String mappingKey) {
        for (OrmTypeMappingDefinition definition : CollectionTools.iterable(this.ormTypeMappingDefinitions())) {
            if (!Tools.valuesAreEqual((Object)definition.getKey(), (Object)mappingKey)) continue;
            return definition;
        }
        throw new IllegalArgumentException("Illegal type mapping key: " + mappingKey);
    }

    public ListIterator<OrmTypeMappingDefinition> ormTypeMappingDefinitions() {
        return new ArrayListIterator((Object[])this.getOrmTypeMappingDefinitions());
    }

    protected synchronized OrmTypeMappingDefinition[] getOrmTypeMappingDefinitions() {
        if (this.ormTypeMappingDefinitions == null) {
            this.ormTypeMappingDefinitions = this.buildOrmTypeMappingDefinitions();
        }
        return this.ormTypeMappingDefinitions;
    }

    protected abstract OrmTypeMappingDefinition[] buildOrmTypeMappingDefinitions();

    @Override
    public OrmAttributeMappingDefinition getOrmAttributeMappingDefinition(String mappingKey) {
        for (OrmAttributeMappingDefinition definition : CollectionTools.iterable(this.ormAttributeMappingDefinitions())) {
            if (!Tools.valuesAreEqual((Object)definition.getKey(), (Object)mappingKey)) continue;
            return definition;
        }
        return UnsupportedOrmAttributeMappingDefinition.instance();
    }

    public ListIterator<OrmAttributeMappingDefinition> ormAttributeMappingDefinitions() {
        return new ArrayListIterator((Object[])this.getOrmAttributeMappingDefinitions());
    }

    protected synchronized OrmAttributeMappingDefinition[] getOrmAttributeMappingDefinitions() {
        if (this.ormAttributeMappingDefinitions == null) {
            this.ormAttributeMappingDefinitions = this.buildOrmAttributeMappingDefinitions();
        }
        return this.ormAttributeMappingDefinitions;
    }

    protected abstract OrmAttributeMappingDefinition[] buildOrmAttributeMappingDefinitions();
}

