/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.IllegalOperationException;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.AbstractTheme;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.interfaces.IAbstractThemeModel;

public abstract class AbstractThemeHandle
extends ReportElementHandle
implements IAbstractThemeModel {
    public AbstractThemeHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public final SlotHandle getStyles() {
        return this.getSlot(0);
    }

    public final List getAllStyles() {
        AbstractTheme theme = (AbstractTheme)this.getElement();
        ArrayList<DesignElementHandle> styles = new ArrayList<DesignElementHandle>();
        List<StyleElement> styleList = theme.getAllStyles();
        for (StyleElement style : styleList) {
            styles.add(style.getHandle(this.module));
        }
        return styles;
    }

    public List getAllCssStyleSheets() {
        return Collections.emptyList();
    }

    public final StyleHandle findStyle(String name) {
        AbstractTheme theme = (AbstractTheme)this.getElement();
        StyleElement style = theme.findStyle(name);
        if (style != null) {
            return (StyleHandle)style.getHandle(this.module);
        }
        return null;
    }

    final String makeUniqueStyleName(String name) {
        assert (this != null);
        SlotHandle styles = this.getStyles();
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < styles.getCount()) {
            StyleHandle style = (StyleHandle)styles.get(i);
            set.add(style.getName());
            ++i;
        }
        PropertyHandle propHandle = this.getPropertyHandle("cssStyleSheets");
        if (propHandle != null) {
            Iterator iterator = propHandle.iterator();
            while (iterator.hasNext()) {
                IncludedCssStyleSheetHandle handle = (IncludedCssStyleSheetHandle)iterator.next();
                set.add(handle.getFileName());
            }
        }
        int index = 0;
        String baseName = name;
        while (set.contains(name)) {
            name = String.valueOf(baseName) + ++index;
        }
        return name;
    }

    public final String getDisplayLabel(int level) {
        String displayLabel = super.getDisplayLabel(level);
        Module rootModule = this.getModule();
        if (rootModule instanceof Library) {
            displayLabel = StringUtil.buildQualifiedReference(((Library)rootModule).getNamespace(), displayLabel);
        }
        return displayLabel;
    }

    public final Iterator includeCssesIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("cssStyleSheets");
        return propHandle == null ? Collections.emptyList().iterator() : propHandle.iterator();
    }

    public void addCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        throw new IllegalOperationException();
    }

    public void addCss(IncludedCssStyleSheet cssStruct) throws SemanticException {
        throw new IllegalOperationException();
    }

    public void addCss(String fileName) throws SemanticException {
        throw new IllegalOperationException();
    }

    public void dropCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        throw new IllegalOperationException();
    }

    public boolean canDropCssStyleSheet(CssStyleSheetHandle sheetHandle) {
        return false;
    }

    public boolean canAddCssStyleSheet(CssStyleSheetHandle sheetHandle) {
        return false;
    }

    public boolean canAddCssStyleSheet(String fileName) {
        return false;
    }

    public void reloadCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        throw new IllegalOperationException();
    }

    public CssStyleSheetHandle findCssStyleSheetHandleByName(String fileName) {
        return null;
    }

    public IncludedCssStyleSheetHandle findIncludedCssStyleSheetHandleByName(String fileName) {
        return null;
    }

    public void renameCss(IncludedCssStyleSheetHandle handle, String newFileName) throws SemanticException {
        throw new IllegalOperationException();
    }

    public boolean canRenameCss(IncludedCssStyleSheetHandle handle, String newFileName) throws SemanticException {
        return false;
    }
}

