/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextWorkingSetManager
implements IWorkingSetUpdater {
    private static ContextWorkingSetManager INSTANCE = new ContextWorkingSetManager();
    private List<ContextWorkingSetManager> workingSetUpdaters = null;
    private final AbstractContextListener CONTEXT_LISTENER = new AbstractContextListener(){

        public void contextChanged(ContextChangeEvent event) {
            switch (event.getEventKind()) {
                case ACTIVATED: 
                case DEACTIVATED: 
                case CLEARED: 
                case INTEREST_CHANGED: 
                case LANDMARKS_ADDED: 
                case LANDMARKS_REMOVED: 
                case ELEMENTS_DELETED: {
                    ContextWorkingSetManager.this.updateWorkingSet();
                }
            }
        }
    };
    private final List<IWorkingSet> workingSets = new ArrayList<IWorkingSet>();

    public void addWorkingSetManager(ContextWorkingSetManager updater) {
        if (this.workingSetUpdaters == null) {
            this.workingSetUpdaters = new ArrayList<ContextWorkingSetManager>();
        }
        this.workingSetUpdaters.add(updater);
        ContextCore.getContextManager().addListener(this.CONTEXT_LISTENER);
    }

    public void dispose() {
        ContextCore.getContextManager().removeListener(this.CONTEXT_LISTENER);
    }

    public ContextWorkingSetManager getWorkingSetUpdater() {
        if (this.workingSetUpdaters == null) {
            return null;
        }
        return this.workingSetUpdaters.get(0);
    }

    public void add(IWorkingSet workingSet) {
        this.workingSets.add(workingSet);
    }

    public boolean remove(IWorkingSet workingSet) {
        return this.workingSets.remove(workingSet);
    }

    public boolean contains(IWorkingSet workingSet) {
        return this.workingSets.contains(workingSet);
    }

    private void updateWorkingSet() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (ContextWorkingSetManager.this.workingSets.size() <= 0) {
                    return;
                }
                IWorkingSet set = (IWorkingSet)ContextWorkingSetManager.this.workingSets.get(0);
                set.setElements(new IAdaptable[0]);
                ArrayList<IAdaptable> elements = new ArrayList<IAdaptable>();
                ContextWorkingSetManager.getElementsFromContext(elements);
                set.setElements(elements.toArray(new IAdaptable[elements.size()]));
            }
        });
    }

    public static void getElementsFromContext(List<IAdaptable> elements) {
        for (IInteractionElement node : ContextCorePlugin.getContextManager().getActiveDocuments()) {
            Object o;
            AbstractContextStructureBridge bridge = ContextCore.getStructureBridge((String)node.getContentType());
            if (bridge.getContentType().equals("bugzilla") || !((o = bridge.getObjectForHandle(node.getHandleIdentifier())) instanceof IAdaptable)) continue;
            elements.add((IAdaptable)o);
        }
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSets.get(0);
    }

    public static ContextWorkingSetManager getDefault() {
        return INSTANCE;
    }
}

