/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards.orm;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.operations.OrmFileCreationDataModelProvider;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.wizards.orm.MappingFileWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;

public class MappingFileWizard
extends DataModelWizard
implements INewWizard {
    private MappingFileWizardPage page;

    public MappingFileWizard() {
        this(null);
    }

    public MappingFileWizard(IDataModel dataModel) {
        super(dataModel);
        this.setWindowTitle(JptUiMessages.MappingFileWizard_title);
        this.setDefaultPageImageDescriptor(JptUiPlugin.getImageDescriptor("full/wizban/new_jpa_file_wizban"));
    }

    protected void doAddPages() {
        super.doAddPages();
        this.page = this.buildMappingFileWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    protected MappingFileWizardPage buildMappingFileWizardPage() {
        return new MappingFileWizardPage(this.getDataModel(), "Page_1");
    }

    protected IDataModelProvider getDefaultProvider() {
        return new OrmFileCreationDataModelProvider();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IFolder sourceFolder;
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Object firstSelection = selection.getFirstElement();
        PersistenceUnit pUnit = this.extractPersistenceUnit(firstSelection);
        IProject project = this.extractProject(pUnit, sourceFolder = this.extractSourceFolder(pUnit, firstSelection), firstSelection);
        if (project != null) {
            this.getDataModel().setStringProperty("JpaFileCreationDataModelProperties.PROJECT_NAME", project.getName());
        }
        if (sourceFolder != null) {
            this.getDataModel().setStringProperty("JpaFileCreationDataModelProperties.SOURCE_FOLDER", sourceFolder.getFullPath().toPortableString());
        }
        if (pUnit != null) {
            this.getDataModel().setBooleanProperty("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT", true);
            this.getDataModel().setStringProperty("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT", pUnit.getName());
        }
    }

    private PersistenceUnit extractPersistenceUnit(Object selection) {
        if (selection instanceof PersistenceUnit) {
            return (PersistenceUnit)selection;
        }
        PersistenceUnit pUnit = null;
        if (selection instanceof JpaContextNode) {
            try {
                pUnit = ((JpaContextNode)selection).getPersistenceUnit();
            }
            catch (Exception exception) {}
        }
        if (pUnit == null && selection instanceof IAdaptable) {
            pUnit = (PersistenceUnit)((IAdaptable)selection).getAdapter(PersistenceUnit.class);
        }
        return pUnit;
    }

    private IFolder extractSourceFolder(PersistenceUnit pUnit, Object selection) {
        IResource resource;
        IJavaProject javaProject = null;
        IFolder srcFolder = null;
        if (pUnit != null && (srcFolder = this.findSourceFolder(javaProject = pUnit.getJpaProject().getJavaProject(), pUnit.getResource())) != null) {
            return srcFolder;
        }
        if (selection instanceof IResource && (javaProject = JavaCore.create((IProject)((IResource)selection).getProject())).exists() && (srcFolder = this.findSourceFolder(javaProject, (IResource)selection)) != null) {
            return srcFolder;
        }
        if (selection instanceof IAdaptable && (resource = (IResource)((IAdaptable)selection).getAdapter(IResource.class)) != null && (javaProject = JavaCore.create((IProject)resource.getProject())).exists() && (srcFolder = this.findSourceFolder(javaProject, resource)) != null) {
            return srcFolder;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private IFolder findSourceFolder(IJavaProject javaProject, IResource resource) {
        block10: {
            if (JptCorePlugin.getJpaProject((IProject)javaProject.getProject()) != null) ** GOTO lbl4
            return null;
lbl-1000:
            // 1 sources

            {
                resource = resource.getParent();
lbl4:
                // 2 sources

                ** while (resource != null && !(resource instanceof IFolder))
            }
lbl5:
            // 1 sources

            if (resource == null) {
                return null;
            }
            folder = (IFolder)resource;
            try {
                packageFragmentRoot = null;
                while (packageFragmentRoot == null && folder != null) {
                    packageFragmentRoot = javaProject.findPackageFragmentRoot(folder.getFullPath());
                    if (packageFragmentRoot == null && (packageFragment = javaProject.findPackageFragment(folder.getFullPath())) != null) {
                        packageFragmentRoot = (IPackageFragmentRoot)packageFragment.getAncestor(3);
                    }
                    if (packageFragmentRoot != null) continue;
                    try {
                        folder = (IFolder)folder.getParent();
                    }
                    catch (ClassCastException v0) {
                        folder = null;
                    }
                }
                if (packageFragmentRoot != null) break block10;
                return null;
            }
            catch (JavaModelException v1) {}
        }
        if (JDTTools.packageFragmentRootIsSourceFolder(packageFragmentRoot)) {
            return (IFolder)packageFragmentRoot.getResource();
        }
        return null;
    }

    private IProject extractProject(PersistenceUnit pUnit, IFolder sourceFolder, Object selection) {
        if (pUnit != null) {
            return pUnit.getJpaProject().getProject();
        }
        if (sourceFolder != null) {
            return sourceFolder.getProject();
        }
        IProject project = null;
        if (selection instanceof IResource) {
            project = ((IResource)selection).getProject();
        }
        if (project == null && selection instanceof IJavaElement) {
            project = ((IJavaElement)selection).getJavaProject().getProject();
        }
        if (project == null && selection instanceof JpaContextNode) {
            project = ((JpaContextNode)selection).getJpaProject().getProject();
        }
        if (project == null && selection instanceof IAdaptable) {
            IJavaElement javaElement;
            IResource resource;
            project = (IProject)((IAdaptable)selection).getAdapter(IProject.class);
            if (project == null && (resource = (IResource)((IAdaptable)selection).getAdapter(IResource.class)) != null) {
                project = resource.getProject();
            }
            if (project == null && (javaElement = (IJavaElement)((IAdaptable)selection).getAdapter(IJavaElement.class)) != null) {
                project = javaElement.getJavaProject().getProject();
            }
        }
        if (project != null) {
            DataModelPropertyDescriptor[] dataModelPropertyDescriptorArray = this.getDataModel().getValidPropertyDescriptors("JpaFileCreationDataModelProperties.PROJECT_NAME");
            int n = dataModelPropertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataModelPropertyDescriptor descriptor = dataModelPropertyDescriptorArray[n2];
                if (descriptor.getPropertyDescription().equals(project.getName())) {
                    return project;
                }
                ++n2;
            }
        }
        return null;
    }

    protected void postPerformFinish() throws InvocationTargetException {
        try {
            String projectName = (String)this.getDataModel().getProperty("JpaFileCreationDataModelProperties.PROJECT_NAME");
            IProject project = ProjectUtilities.getProject((String)projectName);
            String sourceFolder = this.getDataModel().getStringProperty("JpaFileCreationDataModelProperties.SOURCE_FOLDER");
            String filePath = this.getDataModel().getStringProperty("JpaFileCreationDataModelProperties.FILE_PATH");
            IFile file = project.getWorkspace().getRoot().getFile(new Path(sourceFolder).append(filePath));
            this.openEditor(file);
        }
        catch (Exception cantOpen) {
            throw new InvocationTargetException(cantOpen);
        }
    }

    private void openEditor(final IFile file) {
        if (file != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        JptUiPlugin.log(e);
                    }
                }
            });
        }
    }
}

