/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TracingOptionsManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.TracingPropertySource;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.pde.ui.launcher.TracingTab;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;

public class TracingBlock {
    private TracingTab fTab;
    private Button fTracingCheck;
    private CheckboxTableViewer fPluginViewer;
    private IPluginModelBase[] fTraceableModels;
    private Properties fMasterOptions = new Properties();
    private Button fSelectAllButton;
    private Button fDeselectAllButton;
    private Hashtable fPropertySources = new Hashtable();
    private FormToolkit fToolkit;
    private ScrolledPageBook fPageBook;

    public TracingBlock(TracingTab tab) {
        this.fTab = tab;
    }

    public AbstractLauncherTab getTab() {
        return this.fTab;
    }

    public void createControl(Composite parent) {
        this.fTracingCheck = new Button(parent, 32);
        this.fTracingCheck.setText(PDEUIMessages.TracingLauncherTab_tracing);
        this.fTracingCheck.setLayoutData((Object)new GridData(768));
        this.fTracingCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                TracingBlock.this.masterCheckChanged(true);
                TracingBlock.this.fTab.updateLaunchConfigurationDialog();
                if (TracingBlock.this.fTracingCheck.getSelection() && !(selection = (IStructuredSelection)TracingBlock.this.fPluginViewer.getSelection()).isEmpty()) {
                    TracingBlock.this.pluginSelected((IPluginModelBase)selection.getFirstElement(), TracingBlock.this.fPluginViewer.getChecked(selection.getFirstElement()));
                }
            }
        });
        this.createSashSection(parent);
        this.createButtonSection(parent);
    }

    private void createSashSection(Composite container) {
        SashForm sashForm = new SashForm(container, 256);
        sashForm.setLayoutData((Object)new GridData(1808));
        this.createPluginViewer((Composite)sashForm);
        this.createPropertySheetClient((Composite)sashForm);
    }

    private void createPluginViewer(Composite sashForm) {
        Composite composite = new Composite(sashForm, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        composite.setLayout((Layout)layout);
        this.fPluginViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.fPluginViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fPluginViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fPluginViewer.setComparator((ViewerComparator)new ListUtil.PluginComparator());
        this.fPluginViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                CheckboxTableViewer tableViewer = (CheckboxTableViewer)e.getSource();
                boolean selected = tableViewer.getChecked((Object)TracingBlock.this.getSelectedModel());
                TracingBlock.this.pluginSelected(TracingBlock.this.getSelectedModel(), selected);
            }
        });
        this.fPluginViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CheckboxTableViewer tableViewer = (CheckboxTableViewer)event.getSource();
                tableViewer.setSelection((ISelection)new StructuredSelection(event.getElement()));
                TracingBlock.this.pluginSelected(TracingBlock.this.getSelectedModel(), event.getChecked());
                TracingBlock.this.fTab.updateLaunchConfigurationDialog();
            }
        });
        this.fPluginViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selection;
                CheckboxTableViewer tableViewer = (CheckboxTableViewer)event.getSource();
                boolean addingCheck = !tableViewer.getChecked(selection = ((IStructuredSelection)event.getSelection()).getFirstElement());
                tableViewer.setChecked(selection, addingCheck);
                TracingBlock.this.pluginSelected(TracingBlock.this.getSelectedModel(), addingCheck);
                TracingBlock.this.fTab.updateLaunchConfigurationDialog();
            }
        });
        GridData gd = new GridData(1808);
        gd.widthHint = 125;
        gd.heightHint = 100;
        this.fPluginViewer.getTable().setLayoutData((Object)gd);
    }

    private void createPropertySheetClient(Composite sashForm) {
        int margin;
        Composite tableChild = new Composite(sashForm, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tableChild.setLayout((Layout)layout);
        layout.marginWidth = layout.marginHeight = (margin = this.createPropertySheet(tableChild));
    }

    private void createButtonSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.fSelectAllButton = new Button(container, 8);
        this.fSelectAllButton.setText(PDEUIMessages.TracingLauncherTab_selectAll);
        this.fSelectAllButton.setLayoutData((Object)new GridData(32));
        SWTUtil.setButtonDimensionHint(this.fSelectAllButton);
        this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TracingBlock.this.fPluginViewer.setAllChecked(true);
                TracingBlock.this.pluginSelected(TracingBlock.this.getSelectedModel(), true);
                TracingBlock.this.fTab.updateLaunchConfigurationDialog();
            }
        });
        this.fDeselectAllButton = new Button(container, 8);
        this.fDeselectAllButton.setText(PDEUIMessages.TracinglauncherTab_deselectAll);
        this.fDeselectAllButton.setLayoutData((Object)new GridData(32));
        SWTUtil.setButtonDimensionHint(this.fDeselectAllButton);
        this.fDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TracingBlock.this.fPluginViewer.setAllChecked(false);
                TracingBlock.this.pluginSelected(TracingBlock.this.getSelectedModel(), false);
                TracingBlock.this.fTab.updateLaunchConfigurationDialog();
            }
        });
    }

    protected int createPropertySheet(Composite parent) {
        this.fToolkit = new FormToolkit(parent.getDisplay());
        int toolkitBorderStyle = this.fToolkit.getBorderStyle();
        int style = toolkitBorderStyle == 2048 ? 0 : 2048;
        Composite container = new Composite(parent, style);
        FillLayout flayout = new FillLayout();
        flayout.marginWidth = 1;
        flayout.marginHeight = 1;
        container.setLayout((Layout)flayout);
        container.setLayoutData((Object)new GridData(1808));
        this.fPageBook = new ScrolledPageBook(container, style | 0x200 | 0x100);
        this.fToolkit.adapt((Control)this.fPageBook, false, false);
        if (style == 0) {
            this.fPageBook.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
            this.fToolkit.paintBordersFor(container);
        }
        return style == 0 ? 2 : 0;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.fMasterOptions.clear();
        this.disposePropertySources();
        try {
            this.fTracingCheck.setSelection(config.getAttribute("tracing", false));
            Map options = config.getAttribute("tracingOptions", null);
            options = options == null ? PDECore.getDefault().getTracingOptionsManager().getTracingTemplateCopy() : PDECore.getDefault().getTracingOptionsManager().getTracingOptions(options);
            this.fMasterOptions.putAll((Map<?, ?>)options);
            this.masterCheckChanged(false);
            String checked = config.getAttribute("checked", null);
            if (checked == null) {
                this.fPluginViewer.setAllChecked(true);
            } else if (checked.equals("[NONE]")) {
                this.fPluginViewer.setAllChecked(false);
            } else {
                StringTokenizer tokenizer = new StringTokenizer(checked, ",");
                ArrayList<IPluginModelBase> list = new ArrayList<IPluginModelBase>();
                while (tokenizer.hasMoreTokens()) {
                    String id = tokenizer.nextToken();
                    IPluginModelBase model = PluginRegistry.findModel((String)id);
                    model = PluginRegistry.findModel((String)id);
                    if (model == null) continue;
                    list.add(model);
                }
                this.fPluginViewer.setCheckedElements(list.toArray());
                IPluginModelBase model = this.getLastSelectedPlugin(config);
                if (model != null) {
                    this.fPluginViewer.setSelection((ISelection)new StructuredSelection((Object)model), true);
                    this.pluginSelected(model, list.contains(model));
                } else {
                    this.pluginSelected(null, false);
                }
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        Object[] checked;
        boolean tracingEnabled = this.fTracingCheck.getSelection();
        config.setAttribute("tracing", tracingEnabled);
        if (tracingEnabled) {
            IPluginModelBase model = this.getSelectedModel();
            String id = model == null ? null : model.getPluginBase().getId();
            config.setAttribute("selectedPlugin", id);
            boolean changes = false;
            Enumeration elements = this.fPropertySources.elements();
            while (elements.hasMoreElements()) {
                TracingPropertySource source = (TracingPropertySource)elements.nextElement();
                if (!source.isModified()) continue;
                changes = true;
                source.save();
            }
            if (changes) {
                config.setAttribute("tracingOptions", (Map)this.fMasterOptions);
            }
        } else {
            config.setAttribute("selectedPlugin", null);
        }
        if ((checked = this.fPluginViewer.getCheckedElements()).length == 0) {
            config.setAttribute("checked", "[NONE]");
        } else if (checked.length == this.fPluginViewer.getTable().getItemCount()) {
            config.setAttribute("checked", null);
        } else {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < checked.length) {
                IPluginModelBase model = (IPluginModelBase)checked[i];
                buffer.append(model.getPluginBase().getId());
                if (i < checked.length - 1) {
                    buffer.append(',');
                }
                ++i;
            }
            config.setAttribute("checked", buffer.toString());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("tracing", false);
        configuration.setAttribute("checked", "[NONE]");
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.fPageBook.getParent().getParent().layout(true);
    }

    public void dispose() {
        if (this.fToolkit != null) {
            this.fToolkit.dispose();
        }
    }

    public FormToolkit getToolkit() {
        return this.fToolkit;
    }

    private IPluginModelBase getSelectedModel() {
        Object item;
        if (this.fTracingCheck.isEnabled() && (item = ((IStructuredSelection)this.fPluginViewer.getSelection()).getFirstElement()) instanceof IPluginModelBase) {
            return (IPluginModelBase)item;
        }
        return null;
    }

    private void pluginSelected(IPluginModelBase model, boolean checked) {
        TracingPropertySource source = this.getPropertySource(model);
        if (source == null) {
            this.fPageBook.showEmptyPage();
        } else {
            PageBookKey key = new PageBookKey(model, checked);
            if (!this.fPageBook.hasPage((Object)key)) {
                Composite parent = this.fPageBook.createPage((Object)key);
                source.createContents(parent, checked);
            }
            this.fPageBook.showPage((Object)key);
        }
    }

    private IPluginModelBase[] getTraceableModels() {
        if (this.fTraceableModels == null) {
            IPluginModelBase[] models = PluginRegistry.getActiveModels();
            ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
            int i = 0;
            while (i < models.length) {
                if (TracingOptionsManager.isTraceable((IPluginModelBase)models[i])) {
                    result.add(models[i]);
                }
                ++i;
            }
            this.fTraceableModels = result.toArray(new IPluginModelBase[result.size()]);
        }
        return this.fTraceableModels;
    }

    private IPluginModelBase getLastSelectedPlugin(ILaunchConfiguration config) throws CoreException {
        String pluginID = config.getAttribute("selectedPlugin", null);
        return pluginID == null ? null : PluginRegistry.findModel((String)pluginID);
    }

    private TracingPropertySource getPropertySource(IPluginModelBase model) {
        if (model == null) {
            return null;
        }
        TracingPropertySource source = (TracingPropertySource)this.fPropertySources.get(model);
        if (source == null) {
            String id = model.getPluginBase().getId();
            Hashtable defaults = PDECore.getDefault().getTracingOptionsManager().getTemplateTable(id);
            source = new TracingPropertySource(model, this.fMasterOptions, defaults, this);
            this.fPropertySources.put(model, source);
        }
        return source;
    }

    private void masterCheckChanged(boolean userChange) {
        boolean enabled = this.fTracingCheck.getSelection();
        this.fPluginViewer.getTable().setEnabled(enabled);
        Control currentPage = this.fPageBook.getCurrentPage();
        if (currentPage != null && !enabled) {
            this.fPageBook.showEmptyPage();
        }
        if (enabled) {
            this.fPluginViewer.setInput((Object)this.getTraceableModels());
        }
        this.fSelectAllButton.setEnabled(enabled);
        this.fDeselectAllButton.setEnabled(enabled);
    }

    private void disposePropertySources() {
        Enumeration elements = this.fPropertySources.elements();
        while (elements.hasMoreElements()) {
            TracingPropertySource source = (TracingPropertySource)elements.nextElement();
            this.fPageBook.removePage((Object)source.getModel());
        }
        this.fPropertySources.clear();
    }

    private class PageBookKey {
        IPluginModelBase fModel;
        boolean fEnabled;

        PageBookKey(IPluginModelBase model, boolean enabled) {
            this.fModel = model;
            this.fEnabled = enabled;
        }

        public boolean equals(Object object) {
            if (object instanceof PageBookKey) {
                return this.fEnabled == ((PageBookKey)object).fEnabled && this.fModel.equals(((PageBookKey)object).fModel);
            }
            return false;
        }

        public int hashCode() {
            return this.fModel.hashCode() + (this.fEnabled ? 1 : 0);
        }
    }
}

