/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal.vendor;

import java.util.Collections;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jpt.db.internal.vendor.CatalogStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FauxCatalogStrategy
implements CatalogStrategy {
    private static final CatalogStrategy INSTANCE = new FauxCatalogStrategy();

    static CatalogStrategy instance() {
        return INSTANCE;
    }

    private FauxCatalogStrategy() {
    }

    @Override
    public boolean supportsCatalogs(Database database) {
        return false;
    }

    @Override
    public List<Catalog> getCatalogs(Database database) {
        return Collections.emptyList();
    }

    @Override
    public List<Schema> getSchemas(Database database) {
        EList catalogs = database.getCatalogs();
        if (catalogs == null || catalogs.isEmpty()) {
            return database.getSchemas();
        }
        return this.getFauxCatalog((List<Catalog>)database.getCatalogs()).getSchemas();
    }

    private Catalog getFauxCatalog(List<Catalog> catalogs) {
        if (catalogs == null) {
            throw new IllegalStateException();
        }
        if (catalogs.size() != 1) {
            throw new IllegalStateException("not a single catalog: " + catalogs.size());
        }
        Catalog catalog = catalogs.get(0);
        if (catalog.getName().length() != 0) {
            throw new IllegalStateException("illegal name: " + catalog.getName());
        }
        return catalog;
    }
}

