/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.event;

import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.util.FillUtil;

public class PolygonRenderEvent
extends PrimitiveRenderEvent {
    private static final long serialVersionUID = 7825900630615976817L;
    private transient Location[] _loa;
    protected transient LineAttributes _lia;
    protected transient Fill _ifBackground;

    public PolygonRenderEvent(Object oSource) {
        super(oSource);
    }

    public final void setPoints(Location[] la) {
        this._loa = la;
    }

    public final Location[] getPoints() {
        return this._loa;
    }

    public Fill getBackground() {
        return this._ifBackground;
    }

    public void setBackground(Fill ifBackground) {
        this._ifBackground = ifBackground;
    }

    public LineAttributes getOutline() {
        return this._lia;
    }

    public void setOutline(LineAttributes lia) {
        this._lia = lia;
    }

    public Bounds getBounds() throws ChartException {
        Bounds bo = goFactory.createBounds(0.0, 0.0, 0.0, 0.0);
        bo.updateFrom(this._loa);
        return bo;
    }

    public PrimitiveRenderEvent copy() {
        PolygonRenderEvent pre = new PolygonRenderEvent(this.source);
        if (this._loa != null) {
            Location[] loa = new Location[this._loa.length];
            int i = 0;
            while (i < loa.length) {
                loa[i] = this._loa[i].copyInstance();
                ++i;
            }
            pre.setPoints(loa);
        }
        if (this._lia != null) {
            pre.setOutline(goFactory.copyOf(this._lia));
        }
        if (this._ifBackground != null) {
            pre.setBackground(FillUtil.copyOf(this._ifBackground));
        }
        pre.setDepth(this.getDepth());
        return pre;
    }

    public final void draw(IDeviceRenderer idr) throws ChartException {
        idr.drawPolygon(this);
    }

    public final void fill(IDeviceRenderer idr) throws ChartException {
        idr.fillPolygon(this);
    }

    public void reset() {
        this._ifBackground = null;
        this._lia = null;
        this._loa = null;
    }

    public LineAttributes getLineAttributes() {
        return this.getOutline();
    }
}

