/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.swtutils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SWTUtils {
    public static final int COLORDIALOG_WIDTH = 222;
    public static final int COLORDIALOG_HEIGHT = 306;
    static final DateFormat dayF = new SimpleDateFormat("dd");
    static final DateFormat monthF = new SimpleDateFormat("MM");
    static final DateFormat yearF = new SimpleDateFormat("yyyy");
    static final DateFormat hourF = new SimpleDateFormat("HH");
    static final DateFormat minuteF = new SimpleDateFormat("mm");
    static final DateFormat secondsF = new SimpleDateFormat("ss");

    public static Label drawLabel(Composite parent, String text, int syle, Object layoutData) {
        Label label = new Label(parent, 0);
        label.setText(text);
        if (layoutData != null) {
            label.setLayoutData(layoutData);
        }
        return label;
    }

    public static Text drawText(Composite parent, int style, Object layoutData) {
        Text text = new Text(parent, style);
        if (layoutData != null) {
            text.setLayoutData(layoutData);
        }
        return text;
    }

    public static StyledText drawStyledText(Composite parent, int style, Object layoutData) {
        StyledText text = new StyledText(parent, style);
        if (layoutData != null) {
            text.setLayoutData(layoutData);
        }
        return text;
    }

    public static Combo drawCombo(Composite parent, int style, Object layoutData) {
        Combo combo = new Combo(parent, 2048);
        if (layoutData != null) {
            combo.setLayoutData(layoutData);
        }
        return combo;
    }

    public static Button drawButton(Composite parent, int style, String text, Object layoutData) {
        Button button = new Button(parent, style);
        if (layoutData != null) {
            button.setLayoutData(layoutData);
        }
        return button;
    }

    public static Button drawDateTime(Composite parent, int style, Object layoutData) {
        Button open = new Button(parent, 8);
        if (layoutData != null) {
            open.setLayoutData(layoutData);
        }
        open.setText("");
        open.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Shell dialog = new Shell(parent.getShell(), 2144);
                dialog.setLayout((Layout)new GridLayout(3, false));
                final DateTime calendar = new DateTime((Composite)dialog, 3072);
                final DateTime time = new DateTime((Composite)dialog, 32896);
                Widget widget = e.widget;
                ((Button)widget).getText();
                Object object = ((Button)widget).getData();
                if (object != null) {
                    Date dat = (Date)object;
                    Integer day = Integer.valueOf(dayF.format(dat));
                    Integer year = Integer.valueOf(yearF.format(dat));
                    Integer month = Integer.valueOf(monthF.format(dat));
                    calendar.setDate(year.intValue(), month - 1, day.intValue());
                    Integer hours = Integer.valueOf(hourF.format(dat));
                    Integer minutes = Integer.valueOf(minuteF.format(dat));
                    Integer seconds = Integer.valueOf(secondsF.format(dat));
                    time.setHours(hours.intValue());
                    time.setMinutes(minutes.intValue());
                    time.setSeconds(seconds.intValue());
                }
                new Label((Composite)dialog, 0);
                new Label((Composite)dialog, 0);
                Button ok = new Button((Composite)dialog, 8);
                ok.setText("OK");
                ok.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String wholeDate = SWTUtils.convertDateTimeToString(calendar, time);
                        Date dateToAdd = SWTUtils.convertStringToDate(wholeDate);
                        open.setData((Object)dateToAdd);
                        open.setText(wholeDate);
                        dialog.close();
                    }
                });
                dialog.setDefaultButton(ok);
                dialog.pack();
                dialog.open();
            }
        });
        return open;
    }

    public static Label drawColorPicker(Composite parent, Object layoutData) {
        Composite innerSection = new Composite(parent, 0);
        GridLayout colorGd = new GridLayout();
        colorGd.numColumns = 2;
        colorGd.marginHeight = 0;
        colorGd.marginBottom = 0;
        innerSection.setLayout((Layout)colorGd);
        Label colorLabel = new Label(innerSection, 2048);
        colorLabel.setText("          ");
        RGB rgb = null;
        rgb = new RGB(0, 255, 0);
        Color color = new Color((Device)parent.getDisplay(), rgb);
        colorLabel.setBackground(color);
        String newHexadecimal = SWTUtils.convertRGBToHexadecimal(rgb);
        colorLabel.setData((Object)newHexadecimal);
        Button button = new Button(innerSection, 8);
        button.setText("Color...");
        Shell parentShell = parent.getShell();
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Shell centerShell = new Shell(parentShell, 8);
                centerShell.setLocation((parentShell.getSize().x - 222) / 2, (parentShell.getSize().y - 306) / 2);
                ColorDialog colorDg = new ColorDialog(centerShell, 65536);
                colorDg.setRGB(colorLabel.getBackground().getRGB());
                RGB rgb = colorDg.open();
                if (rgb != null) {
                    color.dispose();
                    Color newColor = new Color((Device)parentShell.getDisplay(), rgb);
                    colorLabel.setBackground(newColor);
                    String newHexadecimal = SWTUtils.convertRGBToHexadecimal(rgb);
                    colorLabel.setData((Object)newHexadecimal);
                }
                centerShell.dispose();
            }
        });
        return colorLabel;
    }

    public static Spinner drawSpinner(Composite parent, int style, Object layoutData, int minimum, int maximum, int digits) {
        Spinner spinner = new Spinner(parent, style);
        if (digits > -1) {
            spinner.setDigits(digits);
        }
        spinner.setMaximum(maximum);
        spinner.setMinimum(minimum);
        if (layoutData != null) {
            spinner.setLayoutData(layoutData);
        }
        return spinner;
    }

    public static GridData setGridLayoutData(int align, int horizontalSpan) {
        GridData gName = new GridData(align);
        if (horizontalSpan > 0) {
            gName.horizontalSpan = horizontalSpan;
        }
        return gName;
    }

    public static void drawEmptyLabel(Composite composite) {
        Label emptyLabel = new Label(composite, 0);
        emptyLabel.setText("");
    }

    public static String convertRGBToHexadecimal(RGB rgb) {
        int red = rgb.red;
        int green = rgb.green;
        int blue = rgb.blue;
        String redHexadecimal = Integer.toHexString(red);
        String greenHexadecimal = Integer.toHexString(green);
        String blueHexadecimal = Integer.toHexString(blue);
        if (redHexadecimal.length() == 1) {
            redHexadecimal = "0" + redHexadecimal;
        }
        if (greenHexadecimal.length() == 1) {
            greenHexadecimal = "0" + greenHexadecimal;
        }
        if (blueHexadecimal.length() == 1) {
            blueHexadecimal = "0" + blueHexadecimal;
        }
        return "#" + redHexadecimal + greenHexadecimal + blueHexadecimal;
    }

    public static RGB convertHexadecimalToRGB(String hexadecimal) throws NumberFormatException {
        java.awt.Color col = null;
        try {
            col = java.awt.Color.decode(hexadecimal);
        }
        catch (Exception exception) {
            col = java.awt.Color.WHITE;
        }
        int red = col.getRed();
        int blue = col.getBlue();
        int green = col.getGreen();
        return new RGB(red, green, blue);
    }

    public static Integer convertValueForSpinner(double d) {
        int indexPoint;
        Double doubleVal = d;
        String doubleString = doubleVal.toString();
        String afterPoint = doubleString.substring((indexPoint = doubleString.indexOf(46)) + 1, doubleString.length());
        if (afterPoint.length() == 1) {
            doubleString = String.valueOf(doubleString) + 0;
        } else if (afterPoint.length() == 0) {
            doubleString = String.valueOf(doubleString) + 0;
        }
        doubleString = SWTUtils.removeChar(doubleString, '.');
        Integer fakeIntVal = Integer.valueOf(doubleString);
        return fakeIntVal;
    }

    private static String removeChar(String s, char c) {
        String r = "";
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != c) {
                r = String.valueOf(r) + s.charAt(i);
            }
            ++i;
        }
        return r;
    }

    public static String convertDateTimeToString(DateTime calendar, DateTime time) {
        String date = String.valueOf(calendar.getDay()) + "/" + (calendar.getMonth() + 1 < 10 ? "0" : "") + (calendar.getMonth() + 1) + "/" + calendar.getYear();
        String timedate = String.valueOf(time.getHours() < 10 ? "0" : "") + time.getHours() + ":" + (time.getMinutes() < 10 ? "0" : "") + time.getMinutes() + ":" + (time.getSeconds() < 10 ? "0" : "") + time.getSeconds();
        String wholeDate = String.valueOf(date) + " " + timedate;
        return wholeDate;
    }

    public static String convertDateToString(Date time) {
        String day = null;
        String month = null;
        String year = null;
        String hour = null;
        String minute = null;
        String seconds = null;
        String toReturn = null;
        SimpleDateFormat dayF = new SimpleDateFormat("dd");
        SimpleDateFormat monthF = new SimpleDateFormat("MM");
        SimpleDateFormat yearF = new SimpleDateFormat("yyyy");
        SimpleDateFormat hourF = new SimpleDateFormat("HH");
        SimpleDateFormat minuteF = new SimpleDateFormat("mm");
        SimpleDateFormat secondsF = new SimpleDateFormat("ss");
        try {
            day = dayF.format(time);
            month = monthF.format(time);
            year = yearF.format(time);
            hour = hourF.format(time);
            minute = minuteF.format(time);
            seconds = secondsF.format(time);
            toReturn = String.valueOf(day) + "/" + month + "/" + year + " " + hour + ":" + minute + ":" + seconds;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public static String convertDateTimeToString(DateTime time) {
        String day = null;
        String month = null;
        String year = null;
        String hour = null;
        String minute = null;
        String seconds = null;
        String toReturn = null;
        try {
            day = dayF.format(time);
            month = monthF.format(time);
            year = yearF.format(time);
            hour = hourF.format(time);
            minute = minuteF.format(time);
            seconds = secondsF.format(time);
            toReturn = String.valueOf(day) + "/" + month + "/" + year + " " + hour + ":" + minute + ":" + seconds;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public static Date convertStringToDate(String wholeString) {
        Date toReturn = null;
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
        try {
            toReturn = formatter.parse(wholeString);
        }
        catch (ParseException parseException) {}
        return toReturn;
    }
}

