/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.alarmwidgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ebam.designers.exception.WizardException;
import org.eclipse.ebam.designers.swtutils.ColorConstants;
import org.eclipse.ebam.designers.swtutils.ImageDescriptors;
import org.eclipse.ebam.designers.wizards.pages.alarmwidgets.AlarmWizardPage;
import org.eclipse.ebam.designers.wizards.pages.alarmwidgets.AlarmsDetailComposite;
import org.eclipse.ebam.designers.wizards.pages.alarmwidgets.detailtabs.AlarmContactsTabItem;
import org.eclipse.ebam.designers.wizards.pages.alarmwidgets.detailtabs.AlarmDetailTabItem;
import org.eclipse.ebam.designers.wizards.pages.alarmwidgets.detailtabs.AlarmEventsTabItem;
import org.eclipse.ebam.designers.wizards.pages.alarmwidgets.detailtabs.AlarmThValueTabItem;
import org.eclipse.ebam.designers.wizards.pages.thresholdwidgets.ThresholdsDetailComposite;
import org.eclipse.ebam.emf.SbiAlarmTransactions;
import org.eclipse.ebam.model.entities.SbiAlarm;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlarmsListComposite
extends Composite {
    private AlarmWizardPage alarmWizardPage = null;
    private Table alarmsTable = null;
    public static final int LABEL = 0;
    public static final int NAME = 1;
    private static Logger logger = LoggerFactory.getLogger(AlarmsListComposite.class);

    public AlarmsListComposite(Composite parent, int style, AlarmWizardPage alarmWizardPage1) {
        super(parent, style);
        this.alarmWizardPage = alarmWizardPage1;
    }

    public void drawComp() {
        logger.debug("in");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        try {
            this.setLayout((Layout)gridLayout);
            Label label = new Label((Composite)this, 0);
            label.setText("Alarms List: ");
            label.setForeground(new Color((Device)this.getDisplay(), ColorConstants.titlesColor));
            label.setLayoutData((Object)new GridData(32));
            Label empty = new Label((Composite)this, 0);
            empty.setText("");
            empty.setLayoutData((Object)new GridData(128));
            Button buttonAdd = new Button((Composite)this, 8);
            buttonAdd.setToolTipText("Add an alarm");
            buttonAdd.setLayoutData((Object)new GridData(32));
            Image addImage = ImageDescriptors.getAddIcon().createImage();
            buttonAdd.setImage(addImage);
            buttonAdd.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    AlarmsListComposite.this.addAddButtonPush();
                }
            });
            Button buttonErase = new Button((Composite)this, 8);
            buttonErase.setToolTipText("Erase selected alarm");
            buttonErase.setLayoutData((Object)new GridData(128));
            Image eraseImage = ImageDescriptors.getEraseIcon().createImage();
            buttonErase.setImage(eraseImage);
            buttonErase.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        AlarmsListComposite.this.eraseButtonPush();
                        AlarmsDetailComposite alarmsDetailComposite = AlarmsListComposite.this.getAlarmWizardPage().getDetailComposite();
                        alarmsDetailComposite.getStatusLabel().setText(AlarmsDetailComposite.EMPTY);
                    }
                    catch (WizardException wizardException) {
                        logger.error("database connection exception");
                        MessageDialog.openError((Shell)AlarmsListComposite.this.alarmsTable.getShell(), (String)"Error", (String)"Error in removing alarm");
                    }
                }
            });
            List<SbiAlarm> alarmsList = this.retrieveAlarms();
            if (alarmsList == null) {
                alarmsList = new ArrayList<SbiAlarm>();
            }
            this.alarmsTable = new Table((Composite)this, 68100);
            this.alarmsTable.setLinesVisible(true);
            this.alarmsTable.setHeaderVisible(true);
            GridData g = new GridData(1808);
            g.horizontalSpan = 2;
            this.alarmsTable.setLayoutData((Object)g);
            String[] titles = new String[]{"                 Label                 ", "                          Name                        "};
            int i = 0;
            while (i < titles.length) {
                TableColumn column = new TableColumn(this.alarmsTable, 0);
                column.setText(titles[i]);
                ++i;
            }
            i = 0;
            while (i < alarmsList.size()) {
                SbiAlarm sbiAlarm = alarmsList.get(i);
                TableItem item = new TableItem(this.alarmsTable, 0);
                String labelVal = "";
                if (sbiAlarm.getLabel() != null) {
                    labelVal = sbiAlarm.getLabel();
                }
                item.setText(0, labelVal);
                String nameVal = "";
                if (sbiAlarm.getName() != null) {
                    nameVal = sbiAlarm.getName();
                }
                item.setText(1, nameVal);
                item.setData((Object)sbiAlarm.getAlarmId());
                ++i;
            }
            i = 0;
            while (i < titles.length) {
                this.alarmsTable.getColumn(i).pack();
                ++i;
            }
            this.alarmsTable.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        AlarmsListComposite.this.getAlarmWizardPage().getDetailComposite().getStatusLabel().setText(AlarmsDetailComposite.MODIFYING);
                        AlarmsListComposite.this.getAlarmWizardPage().getDetailComposite().getStatusLabel().redraw();
                        AlarmsListComposite.this.addAlarmSelection();
                    }
                    catch (Exception exception) {
                        logger.error("database connectionexception");
                        MessageDialog.openError((Shell)AlarmsListComposite.this.alarmsTable.getShell(), (String)"Error", (String)"Error in preparing page for selected allarm");
                    }
                }
            });
        }
        catch (WizardException wizardException) {
            logger.error("database connection exception");
            MessageDialog.openError((Shell)this.alarmsTable.getShell(), (String)"Error", (String)"database connectione exception");
        }
        catch (Exception exception) {
            logger.error("exception in building alarm wizard");
            MessageDialog.openError((Shell)this.alarmsTable.getShell(), (String)"Error", (String)"exception in building alarm wizard");
        }
        this.alarmsTable.redraw();
        logger.debug("OUT");
    }

    private void addAlarmSelection() throws Exception {
        logger.debug("IN");
        int indexSelected = this.alarmsTable.getSelectionIndex();
        TableItem tableItem = this.alarmsTable.getItem(indexSelected);
        String label = tableItem.getText(0);
        SbiAlarm sbiAlarm = new SbiAlarmTransactions().getSbiAlarmByLabel(label);
        if (sbiAlarm == null) {
            logger.error("could not find alarm " + label);
            MessageDialog.openError((Shell)this.alarmsTable.getShell(), (String)"Error", (String)("Could not find alarm with label " + label));
        }
        logger.debug("fill detail page with selected alarm " + label);
        AlarmsDetailComposite alDetailComposite = this.getAlarmWizardPage().getDetailComposite();
        CTabFolder tabFolder = alDetailComposite.getTabFolder();
        AlarmDetailTabItem alarmDetailTabItem = (AlarmDetailTabItem)tabFolder.getItem(0);
        alarmDetailTabItem.fillEmptyValues();
        alarmDetailTabItem.fillAlarmValues(sbiAlarm);
        alarmDetailTabItem.enableFields(false);
        AlarmThValueTabItem alarmThValueTabItem = (AlarmThValueTabItem)tabFolder.getItem(1);
        alarmThValueTabItem.fillEmptyValues();
        alarmThValueTabItem.fillAlarmValues(sbiAlarm);
        alarmThValueTabItem.enableFields();
        tabFolder.setSelection(0);
        AlarmContactsTabItem alarmContactsTabItem = (AlarmContactsTabItem)tabFolder.getItem(2);
        alarmContactsTabItem.fillEmptyValues();
        alarmContactsTabItem.fillAlarmValues(sbiAlarm);
        alarmContactsTabItem.enableFields();
        AlarmEventsTabItem alarmEventsTabItem = (AlarmEventsTabItem)tabFolder.getItem(3);
        alarmEventsTabItem.fillEmptyValues();
        alarmEventsTabItem.fillAlarmValues(sbiAlarm);
        alarmEventsTabItem.enableFields();
        tabFolder.setEnabled(true);
        tabFolder.setSelection(3);
        this.getAlarmWizardPage().getDetailComposite().getButtonSave().setEnabled(true);
        tabFolder.setSelection(0);
        logger.debug("OUT");
    }

    private void addAddButtonPush() {
        logger.debug("IN");
        AlarmsDetailComposite alDetailComposite = this.getAlarmWizardPage().getDetailComposite();
        CTabFolder tabFolder = alDetailComposite.getTabFolder();
        this.alarmsTable.setSelection(-1);
        AlarmDetailTabItem alarmDetailTabItem = (AlarmDetailTabItem)tabFolder.getItem(0);
        alarmDetailTabItem.fillEmptyValues();
        alarmDetailTabItem.enableFields(true);
        AlarmThValueTabItem alarmSlaTabItem = (AlarmThValueTabItem)tabFolder.getItem(1);
        alarmSlaTabItem.fillEmptyValues();
        alarmSlaTabItem.disableFields();
        AlarmContactsTabItem alarmContactsTabItem = (AlarmContactsTabItem)tabFolder.getItem(2);
        alarmContactsTabItem.fillEmptyValues();
        alarmContactsTabItem.disableFields();
        AlarmEventsTabItem alarmEventsTabItem = (AlarmEventsTabItem)tabFolder.getItem(3);
        alarmEventsTabItem.fillEmptyValues();
        alarmEventsTabItem.disableFields();
        tabFolder.setEnabled(true);
        tabFolder.setSelection(0);
        this.getAlarmWizardPage().getDetailComposite().getButtonSave().setEnabled(true);
        this.getAlarmWizardPage().getDetailComposite().getStatusLabel().setText(ThresholdsDetailComposite.INSERTING);
        this.getAlarmWizardPage().getDetailComposite().getStatusLabel().redraw();
    }

    private List<SbiAlarm> retrieveAlarms() throws WizardException {
        List alarms = null;
        try {
            alarms = new SbiAlarmTransactions().getSbiAlarmList();
        }
        catch (Exception e) {
            logger.error("error in retrieving alarms list", (Throwable)e);
            throw new WizardException(e, "error in retrieving alarms list");
        }
        return alarms;
    }

    private void eraseButtonPush() throws WizardException {
        logger.debug("IN");
        int indexSelected = this.alarmsTable.getSelectionIndex();
        if (indexSelected != -1) {
            TableItem tableItem = this.alarmsTable.getItem(indexSelected);
            String label = tableItem.getText(0);
            SbiAlarm sbiAlarm = null;
            try {
                sbiAlarm = new SbiAlarmTransactions().getSbiAlarmByLabel(label);
                new SbiAlarmTransactions().deleteSbiAlarm(sbiAlarm);
            }
            catch (Exception e) {
                logger.error("error in erasing alarm", (Throwable)e);
                throw new WizardException(e, "error in erasing alarm");
            }
            this.alarmsTable.remove(indexSelected);
            this.alarmsTable.setSelection(-1);
            AlarmsDetailComposite alDetailComposite = this.getAlarmWizardPage().getDetailComposite();
            CTabFolder tabFolder = alDetailComposite.getTabFolder();
            AlarmDetailTabItem alarmDetailTabItem = (AlarmDetailTabItem)tabFolder.getItem(0);
            alarmDetailTabItem.fillEmptyValues();
            alarmDetailTabItem.disableFields();
            AlarmThValueTabItem alarmSlaTabItem = (AlarmThValueTabItem)tabFolder.getItem(1);
            alarmSlaTabItem.fillEmptyValues();
            alarmSlaTabItem.disableFields();
            AlarmContactsTabItem alarmContactsTabItem = (AlarmContactsTabItem)tabFolder.getItem(2);
            alarmContactsTabItem.fillEmptyValues();
            alarmContactsTabItem.disableFields();
            tabFolder.setSelection(0);
            tabFolder.setEnabled(false);
            this.alarmsTable.redraw();
        }
        this.getAlarmWizardPage().getDetailComposite().getButtonSave().setEnabled(false);
        logger.debug("OUT");
    }

    public AlarmWizardPage getAlarmWizardPage() {
        return this.alarmWizardPage;
    }

    public void setAlarmWizardPage(AlarmWizardPage alarmWizardPage1) {
        this.alarmWizardPage = alarmWizardPage1;
    }

    public Table getAlarmsTable() {
        return this.alarmsTable;
    }

    public void setAlarmsTable(Table alarmsTable) {
        this.alarmsTable = alarmsTable;
    }
}

