/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.alarmwidgets.detailtabs;

import java.util.Random;
import org.eclipse.ebam.designers.exception.WizardException;
import org.eclipse.ebam.designers.wizards.pages.alarmwidgets.AlarmsDetailComposite;
import org.eclipse.ebam.designers.wizards.pages.alarmwidgets.AlarmsListComposite;
import org.eclipse.ebam.emf.SbiDomainTransactions;
import org.eclipse.ebam.model.entities.SbiAlarm;
import org.eclipse.ebam.model.entities.SbiDomain;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmDetailTabItem
extends CTabItem {
    private AlarmsDetailComposite alarmsDetailComposite;
    private Text labelText;
    private Text nameText;
    private Text descrText;
    private Text urlText;
    private Text mailText;
    private Button mailButton = null;
    private Button smsButton = null;
    private Button autButton = null;
    private Button evButton = null;
    private boolean inserting = true;
    public static final int tabIndex = 0;
    private static Logger logger = LoggerFactory.getLogger(AlarmDetailTabItem.class);

    public AlarmDetailTabItem(CTabFolder parent, int style, AlarmsDetailComposite alComposite) {
        super(parent, style);
        this.alarmsDetailComposite = alComposite;
    }

    public void drawComp(CTabFolder folder) {
        logger.debug("IN");
        Composite detailComposite = new Composite((Composite)folder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        detailComposite.setLayout((Layout)gridLayout);
        Label labelLabel = new Label(detailComposite, 0);
        labelLabel.setText("Label ");
        GridData gLabel = new GridData(32);
        labelLabel.setLayoutData((Object)gLabel);
        this.labelText = new Text(detailComposite, 2048);
        GridData gLabelText = new GridData(768);
        gLabelText.horizontalSpan = 2;
        this.labelText.setLayoutData((Object)gLabelText);
        Label nameLabel = new Label(detailComposite, 0);
        nameLabel.setText("Name ");
        GridData gName = new GridData(32);
        nameLabel.setLayoutData((Object)gName);
        this.nameText = new Text(detailComposite, 2048);
        GridData gNameText = new GridData(768);
        gNameText.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gNameText);
        Label descrLabel = new Label(detailComposite, 0);
        descrLabel.setText("Description ");
        GridData gDescr = new GridData(32);
        descrLabel.setLayoutData((Object)gDescr);
        this.descrText = new Text(detailComposite, 2048);
        GridData gDescrText = new GridData(768);
        gDescrText.horizontalSpan = 2;
        this.descrText.setLayoutData((Object)gDescrText);
        Label modLabel = new Label(detailComposite, 0);
        modLabel.setText("Modality ");
        GridData gMod = new GridData(32);
        modLabel.setLayoutData((Object)gMod);
        this.mailButton = new Button(detailComposite, 16);
        this.mailButton.setText("Mail");
        this.mailButton.setData((Object)"MAIL");
        this.smsButton = new Button(detailComposite, 16);
        this.smsButton.setText("SMS");
        this.smsButton.setData((Object)"SMS");
        Label optLabel = new Label(detailComposite, 0);
        optLabel.setText("Options ");
        GridData gOpt = new GridData(32);
        optLabel.setLayoutData((Object)gOpt);
        this.evButton = new Button(detailComposite, 32);
        this.evButton.setText("Event");
        this.autButton = new Button(detailComposite, 32);
        this.autButton.setText("Automatic disabled");
        Label urlLabel = new Label(detailComposite, 0);
        urlLabel.setText("Url ");
        GridData gUrl = new GridData(32);
        urlLabel.setLayoutData((Object)gUrl);
        this.urlText = new Text(detailComposite, 2048);
        GridData gUrlText = new GridData(768);
        gUrlText.horizontalSpan = 2;
        this.urlText.setLayoutData((Object)gUrlText);
        Label mailLabel = new Label(detailComposite, 0);
        mailLabel.setText("Mail text ");
        GridData gMail = new GridData(32);
        mailLabel.setLayoutData((Object)gMail);
        this.mailText = new Text(detailComposite, 2626);
        GridData gMailText = new GridData(1808);
        gMailText.horizontalSpan = 2;
        this.mailText.setLayoutData((Object)gMailText);
        this.setControl((Control)detailComposite);
        logger.debug("OUT");
    }

    public void fillEmptyValues() {
        this.setInserting(true);
        this.labelText.setText("");
        this.nameText.setText("");
        this.descrText.setText("");
        this.urlText.setText("");
        this.mailText.setText("");
        this.evButton.setSelection(false);
        this.autButton.setSelection(false);
        this.mailButton.setSelection(false);
        this.smsButton.setSelection(false);
    }

    public void fillAlarmValues(SbiAlarm sbiAlarm) throws WizardException {
        String label = sbiAlarm.getLabel() != null ? sbiAlarm.getLabel() : "";
        this.labelText.setText(label);
        String name = sbiAlarm.getName() != null ? sbiAlarm.getName() : "";
        this.nameText.setText(name);
        String descr = sbiAlarm.getDescr() != null ? sbiAlarm.getDescr() : "";
        this.descrText.setText(descr);
        String url = sbiAlarm.getUrl() != null ? sbiAlarm.getUrl() : "";
        this.urlText.setText(url);
        String mail = sbiAlarm.getText() != null ? sbiAlarm.getText() : "";
        this.mailText.setText(mail);
        try {
            String singleEvent;
            String autoDisabled;
            sbiAlarm.getModalityId();
            SbiDomain domain = null;
            Integer modalityId = sbiAlarm.getModalityId();
            if (modalityId != null) {
                domain = new SbiDomainTransactions().getDomainById(modalityId);
            }
            String modalityCd = null;
            this.mailButton.setSelection(false);
            this.smsButton.setSelection(false);
            if (domain != null) {
                modalityCd = domain.getValueCd();
                if (modalityCd.equalsIgnoreCase("SMS")) {
                    this.smsButton.setSelection(true);
                } else if (modalityCd.equalsIgnoreCase("Mail")) {
                    this.mailButton.setSelection(true);
                }
            }
            String string = autoDisabled = sbiAlarm.getAutoDisabled() != null ? sbiAlarm.getAutoDisabled() : "F";
            if (autoDisabled.equalsIgnoreCase("T")) {
                this.autButton.setSelection(true);
            } else {
                this.autButton.setSelection(false);
            }
            String string2 = singleEvent = sbiAlarm.getSingleEvent() != null ? sbiAlarm.getSingleEvent() : "F";
            if (singleEvent.equalsIgnoreCase("T")) {
                this.evButton.setSelection(true);
            } else {
                this.evButton.setSelection(false);
            }
        }
        catch (Exception e) {
            logger.error("Error in filling with details of  selected alarm the detail tab ", (Throwable)e);
            throw new WizardException(e, "Error in filling with details of selected alarm the detail tab");
        }
        logger.debug("OUT");
    }

    public void recoverSavingInformations(SbiAlarm sbiAlarm) throws WizardException {
        logger.debug("IN");
        String label = this.labelText.getText();
        String name = this.nameText.getText();
        String descr = this.descrText.getText();
        String url = this.urlText.getText();
        String mailTextS = this.mailText.getText();
        if (label == null || label.equalsIgnoreCase("")) {
            Random r = new Random();
            label = Long.toString(Math.abs(r.nextLong()), 36);
        }
        boolean sms = this.smsButton.getSelection();
        boolean mail = this.mailButton.getSelection();
        boolean event = this.evButton.getSelection();
        boolean autoDisabled = this.autButton.getSelection();
        AlarmsListComposite alarmListComposite = this.getAlarmsDetailComposite().getAlarmWizardPage().getListComposite();
        Table alarmsTable = alarmListComposite.getAlarmsTable();
        alarmsTable.getSelectionIndex();
        sbiAlarm.setLabel(label);
        sbiAlarm.setName(name);
        sbiAlarm.setDescr(descr);
        sbiAlarm.setUrl(url);
        sbiAlarm.setText(mailTextS);
        if (event) {
            sbiAlarm.setSingleEvent("T");
        } else {
            sbiAlarm.setSingleEvent("F");
        }
        if (autoDisabled) {
            sbiAlarm.setAutoDisabled("T");
        } else {
            sbiAlarm.setAutoDisabled("F");
        }
        SbiDomainTransactions domainTransactions = new SbiDomainTransactions();
        Integer modalityId = null;
        try {
            String modLabel = null;
            if (sms) {
                modLabel = (String)this.smsButton.getData();
            } else if (mail) {
                modLabel = (String)this.mailButton.getData();
            }
            if (modLabel != null) {
                SbiDomain d = domainTransactions.getSbiDomainByCode(modLabel);
                modalityId = d.getValueId();
            }
        }
        catch (Exception e) {
            logger.error("Error in retrieving domains", (Throwable)e);
            throw new WizardException(e, "Error in retrieving domains");
        }
        if (modalityId != null) {
            sbiAlarm.setModalityId(modalityId.intValue());
        }
    }

    public void disableFields() {
        this.autButton.setEnabled(false);
        this.descrText.setEnabled(false);
        this.urlText.setEnabled(false);
        this.evButton.setEnabled(false);
        this.labelText.setEnabled(false);
        this.mailButton.setEnabled(false);
        this.mailText.setEnabled(false);
        this.nameText.setEnabled(false);
        this.smsButton.setEnabled(false);
    }

    public void enableFields(boolean insert) {
        this.autButton.setEnabled(true);
        this.descrText.setEnabled(true);
        this.evButton.setEnabled(true);
        if (insert) {
            this.labelText.setEnabled(true);
        } else {
            this.labelText.setEnabled(false);
        }
        this.mailButton.setEnabled(true);
        this.urlText.setEnabled(true);
        this.mailText.setEnabled(true);
        this.nameText.setEnabled(true);
        this.smsButton.setEnabled(true);
    }

    public AlarmsDetailComposite getAlarmsDetailComposite() {
        return this.alarmsDetailComposite;
    }

    public void setAlarmsDetailComposite(AlarmsDetailComposite alarmsDetailComposite) {
        this.alarmsDetailComposite = alarmsDetailComposite;
    }

    public Text getLabelText() {
        return this.labelText;
    }

    public void setLabelText(Text labelText) {
        this.labelText = labelText;
    }

    public Text getNameText() {
        return this.nameText;
    }

    public void setNameText(Text nameText) {
        this.nameText = nameText;
    }

    public Text getUrlText() {
        return this.urlText;
    }

    public void setUrlText(Text urlText) {
        this.urlText = urlText;
    }

    public Text getDescrText() {
        return this.descrText;
    }

    public void setDescrText(Text descrText) {
        this.descrText = descrText;
    }

    public Text getMailText() {
        return this.mailText;
    }

    public void setMailText(Text mailText) {
        this.mailText = mailText;
    }

    public Button getMailButton() {
        return this.mailButton;
    }

    public void setMailButton(Button mailButton) {
        this.mailButton = mailButton;
    }

    public Button getSmsButton() {
        return this.smsButton;
    }

    public void setSmsButton(Button smsButton) {
        this.smsButton = smsButton;
    }

    public Button getAutButton() {
        return this.autButton;
    }

    public void setAutButton(Button autButton) {
        this.autButton = autButton;
    }

    public Button getEvButton() {
        return this.evButton;
    }

    public void setEvButton(Button evButton) {
        this.evButton = evButton;
    }

    public boolean isInserting() {
        return this.inserting;
    }

    public void setInserting(boolean inserting) {
        this.inserting = inserting;
    }
}

