/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.messagewidgets.detailtabs;

import java.util.List;
import org.eclipse.ebam.designers.exception.WizardException;
import org.eclipse.ebam.designers.swtutils.ImageDescriptors;
import org.eclipse.ebam.designers.swtutils.SWTUtils;
import org.eclipse.ebam.designers.wizards.pages.messagewidgets.MessageWizardPage;
import org.eclipse.ebam.designers.wizards.pages.messagewidgets.MessagesDetailComposite;
import org.eclipse.ebam.designers.wizards.pages.messagewidgets.detailtabs.MessageDataAttributeTabFunctions;
import org.eclipse.ebam.designers.wizards.pages.thresholdwidgets.ThresholdsDetailComposite;
import org.eclipse.ebam.emf.MessageTransactions;
import org.eclipse.ebam.model.entities.DataAttribute;
import org.eclipse.ebam.model.entities.Message;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDataAttributeTabItem
extends CTabItem {
    private MessagesDetailComposite messageDetailComposite;
    private Table dataAttributeTable = null;
    public static final int NAME = 0;
    public static final int EXPRESSION = 1;
    public final MessageDataAttributeTabFunctions functions;
    private Text nameText;
    private Text expressionText;
    private Combo dataTypeCombo;
    private Combo attrTypeCombo;
    Button buttonAdd;
    Button buttonSaveValue;
    Button buttonErase;
    public static final int tabIndex = 2;
    private static Logger logger = LoggerFactory.getLogger(MessageDataAttributeTabItem.class);

    public MessageDataAttributeTabItem(CTabFolder parent, int style, MessagesDetailComposite alComposite) {
        super(parent, style);
        this.messageDetailComposite = alComposite;
        this.functions = new MessageDataAttributeTabFunctions(this);
    }

    public void drawComp(CTabFolder folder) throws WizardException {
        logger.debug("IN");
        Composite detailComposite = new Composite((Composite)folder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        detailComposite.setLayout((Layout)gridLayout);
        Label titleLabel = new Label(detailComposite, 1);
        titleLabel.setText(" Data Attributes List: ");
        Color color = new Color((Device)detailComposite.getShell().getDisplay(), new RGB(0, 0, 255));
        titleLabel.setForeground(color);
        GridData gTitleName = new GridData(64);
        gTitleName.horizontalSpan = 4;
        titleLabel.setLayoutData((Object)gTitleName);
        this.dataAttributeTable = new Table(detailComposite, 68100);
        this.dataAttributeTable.setLinesVisible(true);
        this.dataAttributeTable.setHeaderVisible(true);
        GridData g = new GridData(1808);
        g.horizontalSpan = 4;
        this.dataAttributeTable.setLayoutData((Object)g);
        String[] titles = new String[]{"                 Name                ", "                    Expression                  "};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.dataAttributeTable, 0);
            column.setText(titles[i]);
            ++i;
        }
        i = 0;
        while (i < titles.length) {
            this.dataAttributeTable.getColumn(i).pack();
            ++i;
        }
        this.dataAttributeTable.redraw();
        this.dataAttributeTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    int selectedIndex = MessageDataAttributeTabItem.this.dataAttributeTable.getSelectionIndex();
                    TableItem tableItem = MessageDataAttributeTabItem.this.dataAttributeTable.getItem(selectedIndex);
                    MessageDataAttributeTabItem.this.messageDetailComposite.getStatusLabel().setText(MessagesDetailComposite.MODIFYING_ATT);
                    MessageDataAttributeTabItem.this.functions.addDataAttributeSelection(tableItem);
                    MessageDataAttributeTabItem.this.functions.enableDataAttributeDetail(tableItem);
                }
                catch (Exception exception) {
                    logger.error("database connection exception");
                    MessageDialog.openError((Shell)MessageDataAttributeTabItem.this.dataAttributeTable.getShell(), (String)"Error", (String)"Error in preparing page for selected Data Attribute");
                }
            }
        });
        this.buttonAdd = new Button(detailComposite, 8);
        this.buttonAdd.setToolTipText("Add a data attribute");
        this.buttonAdd.setLayoutData((Object)new GridData(64));
        Image addImage = ImageDescriptors.getAddIcon().createImage();
        this.buttonAdd.setImage(addImage);
        this.buttonAdd.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Integer id = MessageDataAttributeTabItem.this.getSelectedMessageId();
                MessageDataAttributeTabItem.this.messageDetailComposite.getStatusLabel().setText(MessagesDetailComposite.INSERTING_ATT);
                try {
                    MessageDataAttributeTabItem.this.functions.addAddButtonPush(id);
                    MessageDataAttributeTabItem.this.functions.enableDataAttributeDetail(null);
                }
                catch (Exception e) {
                    new WizardException(e, "error while saving new Data Attribute");
                }
            }
        });
        this.buttonErase = new Button(detailComposite, 8);
        this.buttonErase.setToolTipText("Erase selected Data Attribute");
        this.buttonErase.setLayoutData((Object)new GridData(64));
        Image eraseImage = ImageDescriptors.getEraseIcon().createImage();
        this.buttonErase.setImage(eraseImage);
        this.buttonErase.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    MessageDataAttributeTabItem.this.messageDetailComposite.getStatusLabel().setText(ThresholdsDetailComposite.EMPTY);
                    MessageDataAttributeTabItem.this.functions.eraseDataAttributePush();
                }
                catch (WizardException wizardException) {
                    logger.error("database connection exception");
                }
            }
        });
        this.buttonErase.setEnabled(false);
        this.buttonSaveValue = new Button(detailComposite, 8);
        this.buttonSaveValue.setToolTipText("Save new Value");
        this.buttonSaveValue.setLayoutData((Object)new GridData(64));
        Image saveImage = ImageDescriptors.getSaveIcon().createImage();
        this.buttonSaveValue.setImage(saveImage);
        this.buttonSaveValue.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Integer messageId = MessageDataAttributeTabItem.this.getSelectedMessageId();
                try {
                    MessageDataAttributeTabItem.this.functions.saveValueButtonPush(messageId);
                    MessageDataAttributeTabItem.this.functions.disableDataAttributeDetail();
                    MessageDataAttributeTabItem.this.messageDetailComposite.getStatusLabel().setText(ThresholdsDetailComposite.EMPTY);
                }
                catch (Exception e) {
                    new WizardException(e, "error while saving new Data Attribute");
                }
            }
        });
        this.buttonSaveValue.setVisible(false);
        SWTUtils.drawLabel(detailComposite, "", 0, null);
        GridData labelLabel = SWTUtils.setGridLayoutData(128, 1);
        GridData gridLabel = SWTUtils.setGridLayoutData(32, 1);
        SWTUtils.drawLabel(detailComposite, "Label", 0, labelLabel);
        this.nameText = SWTUtils.drawText(detailComposite, 2048, gridLabel);
        SWTUtils.drawLabel(detailComposite, "Expression", 0, labelLabel);
        this.expressionText = SWTUtils.drawText(detailComposite, 2048, gridLabel);
        SWTUtils.drawLabel(detailComposite, "Data type", 0, labelLabel);
        this.dataTypeCombo = SWTUtils.drawCombo(detailComposite, 2048, gridLabel);
        SWTUtils.drawLabel(detailComposite, "Attribute type", 0, labelLabel);
        this.attrTypeCombo = SWTUtils.drawCombo(detailComposite, 2048, gridLabel);
        this.dataTypeCombo.add("STRING", 0);
        this.dataTypeCombo.add("LIST", 1);
        this.functions.disableDataAttributeDetail();
        this.setControl((Control)detailComposite);
        logger.debug("OUT");
    }

    public void fillEmptyValues() {
    }

    public void recoverSavingInformations(DataAttribute dataAttribute) throws WizardException {
    }

    public void fillDataAttribute(Message message) throws Exception {
        logger.debug("IN");
        List dataAttributes = new MessageTransactions().getDataAttributeByMsgIdNoCache(Integer.valueOf(message.getMessageId()));
        this.dataAttributeTable.removeAll();
        for (DataAttribute dataAttribute : dataAttributes) {
            TableItem item = new TableItem(this.dataAttributeTable, 0);
            item.setText(0, dataAttribute.getName());
            item.setText(1, dataAttribute.getExpression());
            item.setData((Object)dataAttribute.getAttributeId());
        }
        this.dataAttributeTable.setSelection(-1);
        this.buttonErase.setEnabled(false);
        this.functions.disableDataAttributeDetail();
        logger.debug("OUT");
    }

    public void disableItems() {
        this.dataAttributeTable.setEnabled(false);
        this.functions.handleEventButtons(false, false, false);
        this.functions.disableDataAttributeDetail();
    }

    public void enableItems() {
        this.dataAttributeTable.setEnabled(true);
        this.functions.handleEventButtons(true, false, false);
    }

    public Button getButtonAdd() {
        return this.buttonAdd;
    }

    public void setButtonAdd(Button buttonAdd) {
        this.buttonAdd = buttonAdd;
    }

    public Button getButtonSaveValue() {
        return this.buttonSaveValue;
    }

    public void setButtonSaveValue(Button buttonSaveValue) {
        this.buttonSaveValue = buttonSaveValue;
    }

    public Button getButtonErase() {
        return this.buttonErase;
    }

    public void setButtonErase(Button buttonErase) {
        this.buttonErase = buttonErase;
    }

    public MessageDataAttributeTabFunctions getFunctions() {
        return this.functions;
    }

    public Integer getSelectedMessageId() {
        MessageWizardPage messageWizardPage = this.messageDetailComposite.getMessageWizardPage();
        Table messageTable = messageWizardPage.getListComposite().getMessagesTable();
        Integer index = messageTable.getSelectionIndex();
        TableItem item = messageTable.getItem(index.intValue());
        Integer id = (Integer)item.getData();
        return id;
    }

    public Combo getDataTypeCombo() {
        return this.dataTypeCombo;
    }

    public void setDataTypeCombo(Combo dataTypeCombo) {
        this.dataTypeCombo = dataTypeCombo;
    }

    public Combo getAttrTypeCombo() {
        return this.attrTypeCombo;
    }

    public void setAttrTypeCombo(Combo attrTypeCombo) {
        this.attrTypeCombo = attrTypeCombo;
    }

    public Table getDataAttributeTable() {
        return this.dataAttributeTable;
    }

    public void setDataAttributeTable(Table dataAttributeTable) {
        this.dataAttributeTable = dataAttributeTable;
    }

    public Text getNameText() {
        return this.nameText;
    }

    public void setNameText(Text nameText) {
        this.nameText = nameText;
    }

    public Text getExpressionText() {
        return this.expressionText;
    }

    public void setExpressionText(Text expressionText) {
        this.expressionText = expressionText;
    }
}

