/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.messagewidgets.detailtabs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.ebam.designers.exception.WizardException;
import org.eclipse.ebam.designers.wizards.pages.messagewidgets.MessagesDetailComposite;
import org.eclipse.ebam.emf.SbiDomainTransactions;
import org.eclipse.ebam.model.entities.Message;
import org.eclipse.ebam.model.entities.MessageEngine;
import org.eclipse.ebam.model.entities.SbiDomain;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageEngineTabItem
extends CTabItem {
    Table enginesTable = null;
    MessagesDetailComposite messagesDetailComposite = null;
    List<MessageEngine> messageEngine = null;
    public static final int tabIndex = 1;
    public static final int NAME = 0;
    private static Logger logger = LoggerFactory.getLogger(MessageEngineTabItem.class);

    public MessageEngineTabItem(CTabFolder parent, int style, MessagesDetailComposite messagesDetailComposite1) {
        super(parent, style);
        this.messagesDetailComposite = messagesDetailComposite1;
    }

    public void drawComp(CTabFolder folder) throws WizardException {
        logger.debug("IN");
        Composite detailComposite = new Composite((Composite)folder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        detailComposite.setLayout((Layout)gridLayout);
        this.enginesTable = new Table(detailComposite, 68132);
        this.enginesTable.setLinesVisible(true);
        this.enginesTable.setHeaderVisible(true);
        GridData g = new GridData(1808);
        this.enginesTable.setLayoutData((Object)g);
        this.enginesTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        String[] titles = new String[]{"                 Name                  "};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.enginesTable, 0);
            column.setText(titles[i]);
            ++i;
        }
        List<SbiDomain> engines = this.retrieveSbiDomains();
        int i2 = 0;
        while (i2 < engines.size()) {
            SbiDomain engine = engines.get(i2);
            TableItem item = new TableItem(this.enginesTable, 0);
            item.setText(0, engine.getValueCd() != null ? engine.getValueCd() : "");
            item.setData((Object)engine);
            ++i2;
        }
        i2 = 0;
        while (i2 < titles.length) {
            this.enginesTable.getColumn(i2).pack();
            ++i2;
        }
        this.enginesTable.redraw();
        this.setControl((Control)detailComposite);
        logger.debug("OUT");
    }

    private List<SbiDomain> retrieveSbiDomains() throws WizardException {
        List sbiDomains = null;
        try {
            sbiDomains = new SbiDomainTransactions().getDomainByDomainCd("RULE_TYPE");
        }
        catch (Exception e) {
            logger.error("error in retrieving type domains list", (Throwable)e);
            throw new WizardException(e, "error in retrieving engines Domain List");
        }
        return sbiDomains;
    }

    public void fillMessageEngineValues(Message message) {
        logger.debug("IN");
        List messageEngines = message.getMessageEngine();
        Vector<String> messagesEnginesName = new Vector<String>();
        for (MessageEngine messageEngine : messageEngines) {
            messagesEnginesName.add(messageEngine.getSbiDomain().getValueCd());
        }
        int i = 0;
        while (i < this.enginesTable.getItems().length) {
            TableItem item = this.enginesTable.getItems()[i];
            String name = item.getText(0);
            if (messagesEnginesName.contains(name)) {
                item.setChecked(true);
            } else {
                item.setChecked(false);
            }
            ++i;
        }
        this.enginesTable.redraw();
        logger.debug("OUT");
    }

    public void recoverSavingInformations(Message message) {
        logger.debug("IN");
        Vector<SbiDomain> sbiDomainsSelected = new Vector<SbiDomain>();
        TableItem[] tableItems = this.enginesTable.getItems();
        int i = 0;
        while (i < tableItems.length) {
            TableItem tableItem = tableItems[i];
            boolean checked = tableItem.getChecked();
            if (checked) {
                SbiDomain sbiDomain = (SbiDomain)tableItem.getData();
                sbiDomainsSelected.add(sbiDomain);
            }
            ++i;
        }
        ArrayList<MessageEngine> messageEnginesNew = new ArrayList<MessageEngine>();
        for (SbiDomain selected : sbiDomainsSelected) {
            MessageEngine messageEngine = new MessageEngine();
            messageEngine.setEbamMessage(message);
            messageEngine.setMessageId(message.getMessageId());
            messageEngine.setSbiDomain(selected);
            messageEngine.setValueId(selected.getValueId());
            messageEngine.setEbamMessage(message);
            messageEnginesNew.add(messageEngine);
        }
        message.setMessageEngine(messageEnginesNew);
        logger.debug("OUT");
    }

    public void disableFields() {
        this.enginesTable.setEnabled(false);
    }

    public void enableFields() {
        this.enginesTable.setEnabled(true);
    }

    public Table getEnginesTable() {
        return this.enginesTable;
    }

    public void setEnginesTable(Table enginesTable) {
        this.enginesTable = enginesTable;
    }

    public void fillEmptyValues() {
        TableItem[] items = this.enginesTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem type = items[i];
            type.setChecked(false);
            ++i;
        }
    }

    public boolean isDomainPresent(Vector<SbiDomain> sbiDomains, SbiDomain isPresent) {
        boolean toReturn = false;
        Iterator<SbiDomain> iterator = sbiDomains.iterator();
        while (iterator.hasNext() && !toReturn) {
            SbiDomain sbiDomain = iterator.next();
            if (sbiDomain.getValueId() != isPresent.getValueId() || sbiDomain.getValueCd().equals(isPresent.getValueCd())) {
                // empty if block
            }
            toReturn = true;
        }
        return toReturn;
    }

    public boolean isDomainPresent(List<MessageEngine> messageEngines, SbiDomain isPresent) {
        boolean toReturn = false;
        Iterator<MessageEngine> iterator = messageEngines.iterator();
        while (iterator.hasNext() && !toReturn) {
            MessageEngine messageEngine = iterator.next();
            SbiDomain sbiDomain = messageEngine.getSbiDomain();
            if (sbiDomain.getValueId() != isPresent.getValueId() || sbiDomain.getValueCd().equals(isPresent.getValueCd())) {
                // empty if block
            }
            toReturn = true;
        }
        return toReturn;
    }
}

