/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.rulewidgets;

import org.eclipse.ebam.designers.exception.WizardException;
import org.eclipse.ebam.designers.swtutils.ColorConstants;
import org.eclipse.ebam.designers.swtutils.ImageDescriptors;
import org.eclipse.ebam.designers.wizards.pages.rulewidgets.RuleWizardPage;
import org.eclipse.ebam.designers.wizards.pages.rulewidgets.RulesListComposite;
import org.eclipse.ebam.designers.wizards.pages.rulewidgets.detailtabs.RuleDetailTabItem;
import org.eclipse.ebam.designers.wizards.pages.rulewidgets.detailtabs.RuleEventTabItem;
import org.eclipse.ebam.emf.RulesTransactions;
import org.eclipse.ebam.model.entities.Rule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesDetailComposite
extends Composite {
    private RuleWizardPage ruleWizardPage = null;
    private RuleDetailTabItem detailTabItem = null;
    private RuleEventTabItem ruleEventTabItem = null;
    private Button buttonSave;
    private CTabFolder tabFolder = null;
    private Label statusLabel = null;
    public static String INSERTING = "INSERT A NEW RULE";
    public static String MODIFYING = "MODIFY SELECTED RULE";
    public static String EMPTY = "                                                       ";
    public static String INSERTING_ATT = "INSERT A NEW EVENT";
    public static String MODIFYING_ATT = "MODIFY A EVENT";
    private static Logger logger = LoggerFactory.getLogger(RulesDetailComposite.class);

    public RulesDetailComposite(Composite parent, int style, RuleWizardPage ruleWizardPage1) {
        super(parent, style);
        this.ruleWizardPage = ruleWizardPage1;
    }

    public void drawComp() {
        logger.debug("IN");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.statusLabel = new Label((Composite)this, 0);
        this.statusLabel.setForeground(new Color((Device)this.getDisplay(), ColorConstants.statusLabelColor));
        this.statusLabel.setText(EMPTY);
        this.statusLabel.setLayoutData((Object)new GridData(64));
        this.buttonSave = new Button((Composite)this, 8);
        this.buttonSave.setToolTipText("Save rule details");
        this.buttonSave.setLayoutData((Object)new GridData(128));
        Image saveImage = ImageDescriptors.getSaveIcon().createImage();
        this.buttonSave.setImage(saveImage);
        this.buttonSave.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    logger.debug("Save Rule Button push");
                    RulesDetailComposite.this.saveButtonPush();
                    logger.debug("Rule saved");
                    RulesDetailComposite.this.statusLabel.setText(EMPTY);
                }
                catch (Exception e) {
                    logger.error("database connection exception " + e.getMessage(), (Throwable)e);
                    MessageDialog.openError((Shell)RulesDetailComposite.this.getShell(), (String)"Error", (String)"Error in inserting/updating rule");
                }
            }
        });
        this.buttonSave.setEnabled(false);
        try {
            this.tabFolder = new CTabFolder((Composite)this, 2048);
            this.tabFolder.setLayoutData((Object)new GridData(1808));
            this.tabFolder.setEnabled(false);
            this.detailTabItem = new RuleDetailTabItem(this.tabFolder, 0, this);
            this.detailTabItem.setText("Detail");
            this.detailTabItem.drawComp(this.tabFolder);
            this.ruleEventTabItem = new RuleEventTabItem(this.tabFolder, 0, this);
            this.ruleEventTabItem.setText("Event");
            this.ruleEventTabItem.drawComp(this.tabFolder);
        }
        catch (Exception exception) {
            logger.error("could not create Rules wizard");
            return;
        }
        logger.debug("OUT");
    }

    private void saveButtonPush() throws WizardException, Exception {
        logger.debug("IN");
        Table rulesTable = this.getRuleWizardPage().getListComposite().getRulesTable();
        int index = rulesTable.getSelectionIndex();
        Rule rule = null;
        if (index == -1) {
            rule = new Rule();
        } else {
            TableItem item = rulesTable.getItem(index);
            Integer id = (Integer)item.getData();
            String type = item.getText(1);
            String service = item.getText(0);
            try {
                rule = new RulesTransactions().getRuleById(id);
            }
            catch (Exception e) {
                logger.error("error in getting rule with type " + type + " and service " + service, (Throwable)e);
                throw new WizardException(e, "error in getting rule with type " + type + " and service " + service);
            }
        }
        RuleDetailTabItem ruleDetailTabItem = (RuleDetailTabItem)this.tabFolder.getItem(0);
        ruleDetailTabItem.recoverSavingInformations(rule);
        ruleDetailTabItem.disableFields();
        RuleEventTabItem ruleEventTabItem = (RuleEventTabItem)this.tabFolder.getItem(1);
        ruleEventTabItem.recoverSavingInformations(rule);
        ruleEventTabItem.disableItems();
        RulesTransactions rulesTransactions = new RulesTransactions();
        try {
            if (index == -1) {
                logger.debug("Inserting rule mode");
                rulesTransactions.createNewRule(rule);
                Integer id = rule.getCepRuleId();
                TableItem tableItem = new TableItem(rulesTable, 0);
                String typeVal = "";
                if (rule.getSbiDomain() != null) {
                    typeVal = rule.getSbiDomain().getValueCd();
                }
                tableItem.setText(1, typeVal);
                tableItem.setText(0, rule.getService() != null ? rule.getService() : "");
                tableItem.setData((Object)id);
            } else {
                logger.debug("Updating rule mode");
                rulesTransactions.mergeRule(rule);
                TableItem item = rulesTable.getItem(index);
                String typeVal = "";
                if (rule.getSbiDomain() != null) {
                    typeVal = rule.getSbiDomain().getValueCd();
                }
                item.setText(1, typeVal);
                item.setText(0, rule.getService());
            }
        }
        catch (Exception e1) {
            logger.error("Error in inserting o updating rule ", (Throwable)e1);
            throw new WizardException(e1, "Error in inserting or updating rule");
        }
        rulesTable.setSelection(-1);
        this.tabFolder.setEnabled(false);
        this.buttonSave.setEnabled(false);
        logger.debug("OUT");
    }

    public Integer getListSelectedRuleId() {
        logger.debug("IN");
        RulesListComposite listComp = this.getRuleWizardPage().getListComposite();
        int selectedIndex = listComp.getRulesTable().getSelectionIndex();
        if (selectedIndex == -1) {
            return null;
        }
        TableItem item = listComp.getRulesTable().getItem(selectedIndex);
        if (item == null) {
            return null;
        }
        Object o = item.getData();
        if (o == null) {
            return null;
        }
        Integer id = (Integer)o;
        logger.debug("OUT");
        return id;
    }

    public RuleWizardPage getRuleWizardPage() {
        return this.ruleWizardPage;
    }

    public void setRuleWizardPage(RuleWizardPage ruleWizardPage) {
        this.ruleWizardPage = ruleWizardPage;
    }

    public RuleDetailTabItem getDetailTabItem() {
        return this.detailTabItem;
    }

    public void setDetailTabItem(RuleDetailTabItem detailTabItem) {
        this.detailTabItem = detailTabItem;
    }

    public Button getButtonSave() {
        return this.buttonSave;
    }

    public void setButtonSave(Button buttonSave) {
        this.buttonSave = buttonSave;
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public void setTabFolder(CTabFolder tabFolder) {
        this.tabFolder = tabFolder;
    }

    public Label getStatusLabel() {
        return this.statusLabel;
    }

    public void setStatusLabel(Label statusLabel) {
        this.statusLabel = statusLabel;
    }
}

