/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.rulewidgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ebam.designers.exception.WizardException;
import org.eclipse.ebam.designers.swtutils.ColorConstants;
import org.eclipse.ebam.designers.swtutils.ImageDescriptors;
import org.eclipse.ebam.designers.wizards.pages.rulewidgets.RuleWizardPage;
import org.eclipse.ebam.designers.wizards.pages.rulewidgets.RulesDetailComposite;
import org.eclipse.ebam.designers.wizards.pages.rulewidgets.detailtabs.RuleDetailTabItem;
import org.eclipse.ebam.designers.wizards.pages.rulewidgets.detailtabs.RuleEventTabItem;
import org.eclipse.ebam.emf.RulesTransactions;
import org.eclipse.ebam.model.entities.Rule;
import org.eclipse.ebam.model.entities.SbiDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesListComposite
extends Composite {
    private RuleWizardPage ruleWizardPage = null;
    private Table rulesTable = null;
    Button buttonAdd = null;
    Button buttonErase = null;
    public static final int SERVICE = 0;
    public static final int TYPE = 1;
    private static Logger logger = LoggerFactory.getLogger(RulesListComposite.class);

    public RulesListComposite(Composite parent, int style, RuleWizardPage ruleWizardPage1) {
        super(parent, style);
        this.ruleWizardPage = ruleWizardPage1;
    }

    public void drawComp() {
        logger.debug("in");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        try {
            this.setLayout((Layout)gridLayout);
            Label label = new Label((Composite)this, 0);
            label.setText("Rules List: ");
            label.setForeground(new Color((Device)this.getDisplay(), ColorConstants.titlesColor));
            label.setLayoutData((Object)new GridData(32));
            Label empty = new Label((Composite)this, 0);
            empty.setText("");
            empty.setLayoutData((Object)new GridData(128));
            this.buttonAdd = new Button((Composite)this, 8);
            this.buttonAdd.setToolTipText("Add an rule");
            this.buttonAdd.setLayoutData((Object)new GridData(32));
            Image addImage = ImageDescriptors.getAddIcon().createImage();
            this.buttonAdd.setImage(addImage);
            this.buttonAdd.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    RulesListComposite.this.addAddButtonPush();
                }
            });
            this.buttonErase = new Button((Composite)this, 8);
            this.buttonErase.setToolTipText("Erase selected rule");
            this.buttonErase.setLayoutData((Object)new GridData(128));
            Image eraseImage = ImageDescriptors.getEraseIcon().createImage();
            this.buttonErase.setImage(eraseImage);
            this.buttonErase.setEnabled(false);
            this.buttonErase.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        logger.debug("Erase Rule Button Push");
                        RulesListComposite.this.eraseButtonPush();
                        RulesDetailComposite rulesDetailComposite = RulesListComposite.this.getRuleWizardPage().getDetailComposite();
                        rulesDetailComposite.getStatusLabel().setText(RulesDetailComposite.EMPTY);
                        logger.debug("Rule Deleted");
                    }
                    catch (WizardException wizardException) {
                        logger.error("database connection exception");
                        MessageDialog.openError((Shell)RulesListComposite.this.rulesTable.getShell(), (String)"Error", (String)"Error in removing rule");
                    }
                }
            });
            List<Rule> rulesList = this.retrieveRules();
            if (rulesList == null) {
                rulesList = new ArrayList<Rule>();
            }
            this.rulesTable = new Table((Composite)this, 68100);
            this.rulesTable.setLinesVisible(true);
            this.rulesTable.setHeaderVisible(true);
            GridData g = new GridData(1808);
            g.horizontalSpan = 2;
            this.rulesTable.setLayoutData((Object)g);
            String[] titles = new String[]{"  Service  ", "          Type        "};
            int i = 0;
            while (i < titles.length) {
                TableColumn column = new TableColumn(this.rulesTable, 0);
                column.setText(titles[i]);
                ++i;
            }
            i = 0;
            while (i < rulesList.size()) {
                Rule sbiRule = rulesList.get(i);
                TableItem item = new TableItem(this.rulesTable, 0);
                String typeVal = "";
                if (sbiRule.getExpression() != null) {
                    SbiDomain domain = sbiRule.getSbiDomain();
                    typeVal = domain.getValueCd();
                }
                item.setText(1, typeVal);
                item.setText(0, sbiRule.getService() != null ? sbiRule.getService() : "");
                item.setData((Object)sbiRule.getCepRuleId());
                ++i;
            }
            i = 0;
            while (i < titles.length) {
                this.rulesTable.getColumn(i).pack();
                ++i;
            }
            this.rulesTable.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        logger.debug("Rule selected");
                        RulesListComposite.this.getRuleWizardPage().getDetailComposite().getStatusLabel().setText(RulesDetailComposite.MODIFYING);
                        RulesListComposite.this.getRuleWizardPage().getDetailComposite().getStatusLabel().redraw();
                        RulesListComposite.this.addRuleSelection();
                    }
                    catch (Exception exception) {
                        logger.error("database connectionexception");
                        MessageDialog.openError((Shell)RulesListComposite.this.rulesTable.getShell(), (String)"Error", (String)"Error in preparing page for selected Rule");
                    }
                }
            });
        }
        catch (WizardException wizardException) {
            logger.error("database connection exception");
            MessageDialog.openError((Shell)this.rulesTable.getShell(), (String)"Error", (String)"database connectione exception");
        }
        catch (Exception exception) {
            logger.error("exception in building rule wizard");
            MessageDialog.openError((Shell)this.rulesTable.getShell(), (String)"Error", (String)"exception in building rule wizard");
        }
        this.rulesTable.redraw();
        logger.debug("OUT");
    }

    private void addRuleSelection() throws Exception {
        logger.debug("IN");
        int indexSelected = this.rulesTable.getSelectionIndex();
        TableItem tableItem = this.rulesTable.getItem(indexSelected);
        Integer id = (Integer)tableItem.getData();
        String type = tableItem.getText(1);
        String service = tableItem.getText(0);
        Rule sbiRule = new RulesTransactions().getRuleById(id);
        if (sbiRule == null) {
            logger.error("could not find rule with type " + type + " and service " + service);
            MessageDialog.openError((Shell)this.rulesTable.getShell(), (String)"Error", (String)("could not find rule with type " + type + " and service " + service));
        }
        logger.debug("fill detail page with selected rule of type " + type);
        RulesDetailComposite alDetailComposite = this.getRuleWizardPage().getDetailComposite();
        CTabFolder tabFolder = alDetailComposite.getTabFolder();
        RuleDetailTabItem ruleDetailTabItem = (RuleDetailTabItem)tabFolder.getItem(0);
        ruleDetailTabItem.fillEmptyValues();
        ruleDetailTabItem.fillRuleValues(sbiRule);
        ruleDetailTabItem.enableFields(false);
        tabFolder.setSelection(0);
        RuleEventTabItem ruleEventTabItem = (RuleEventTabItem)tabFolder.getItem(1);
        ruleEventTabItem.fillEmptyValues(false);
        ruleEventTabItem.fillRuleEvent(sbiRule);
        ruleEventTabItem.enableItems();
        this.getRuleWizardPage().getDetailComposite().getButtonSave().setEnabled(true);
        this.buttonErase.setEnabled(true);
        tabFolder.setEnabled(true);
        tabFolder.setSelection(0);
        logger.debug("OUT");
    }

    private void addAddButtonPush() {
        logger.debug("IN");
        RulesDetailComposite alDetailComposite = this.getRuleWizardPage().getDetailComposite();
        CTabFolder tabFolder = alDetailComposite.getTabFolder();
        this.rulesTable.setSelection(-1);
        RuleDetailTabItem ruleDetailTabItem = (RuleDetailTabItem)tabFolder.getItem(0);
        ruleDetailTabItem.fillEmptyValues();
        ruleDetailTabItem.enableFields(true);
        RuleEventTabItem ruleEventTabItem = (RuleEventTabItem)tabFolder.getItem(1);
        ruleEventTabItem.fillEmptyValues(true);
        ruleEventTabItem.disableItems();
        tabFolder.setEnabled(true);
        tabFolder.setSelection(0);
        this.getRuleWizardPage().getDetailComposite().getButtonSave().setEnabled(true);
        this.getRuleWizardPage().getDetailComposite().getStatusLabel().setText(RulesDetailComposite.INSERTING);
        this.getRuleWizardPage().getDetailComposite().getStatusLabel().redraw();
    }

    private List<Rule> retrieveRules() throws WizardException {
        List rules = null;
        try {
            rules = new RulesTransactions().getEbamRulesList();
        }
        catch (Exception e) {
            logger.error("error in retrieving rules list", (Throwable)e);
            throw new WizardException(e, "error in retrieving rules list");
        }
        return rules;
    }

    private void eraseButtonPush() throws WizardException {
        logger.debug("IN");
        int indexSelected = this.rulesTable.getSelectionIndex();
        if (indexSelected != -1) {
            TableItem tableItem = this.rulesTable.getItem(indexSelected);
            Integer id = (Integer)tableItem.getData();
            tableItem.getText(1);
            tableItem.getText(0);
            Rule sbiRule = null;
            try {
                sbiRule = new RulesTransactions().getRuleById(id);
                new RulesTransactions().deleteRule(sbiRule);
            }
            catch (Exception e) {
                logger.error("Error in erasing rule", (Throwable)e);
                throw new WizardException(e, "Error in erasing rule");
            }
            this.rulesTable.remove(indexSelected);
            this.rulesTable.setSelection(-1);
            RulesDetailComposite alDetailComposite = this.getRuleWizardPage().getDetailComposite();
            CTabFolder tabFolder = alDetailComposite.getTabFolder();
            RuleDetailTabItem ruleDetailTabItem = (RuleDetailTabItem)tabFolder.getItem(0);
            ruleDetailTabItem.fillEmptyValues();
            ruleDetailTabItem.disableFields();
            RuleEventTabItem ruleEventTabItem = (RuleEventTabItem)tabFolder.getItem(1);
            ruleEventTabItem.fillEmptyValues(true);
            ruleEventTabItem.disableItems();
            tabFolder.setSelection(0);
            tabFolder.setEnabled(false);
            this.rulesTable.redraw();
        }
        this.getRuleWizardPage().getDetailComposite().getButtonSave().setEnabled(false);
        this.buttonErase.setEnabled(false);
        logger.debug("OUT");
    }

    public RuleWizardPage getRuleWizardPage() {
        return this.ruleWizardPage;
    }

    public void setRuleWizardPage(RuleWizardPage ruleWizardPage1) {
        this.ruleWizardPage = ruleWizardPage1;
    }

    public Table getRulesTable() {
        return this.rulesTable;
    }

    public void setRulesTable(Table rulesTable) {
        this.rulesTable = rulesTable;
    }
}

