/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.rulewidgets.detailtabs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ebam.designers.exception.WizardException;
import org.eclipse.ebam.designers.swtutils.SWTUtils;
import org.eclipse.ebam.designers.wizards.pages.rulewidgets.RulesDetailComposite;
import org.eclipse.ebam.emf.SbiDomainTransactions;
import org.eclipse.ebam.emf.SbiThresholdTransactions;
import org.eclipse.ebam.emf.ServiceTransactions;
import org.eclipse.ebam.model.entities.Rule;
import org.eclipse.ebam.model.entities.SbiDomain;
import org.eclipse.ebam.model.entities.SbiThreshold;
import org.eclipse.ebam.model.entities.Service;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleDetailTabItem
extends CTabItem {
    private RulesDetailComposite rulesDetailComposite;
    private Combo serviceCombo;
    private Combo typeCombo;
    private Combo thresholdCombo;
    private StyledText expressionText;
    private StyledText xslText;
    Map<Integer, Service> idToService = new HashMap<Integer, Service>();
    Map<String, Integer> serviceNameToServiceId = new HashMap<String, Integer>();
    Map<Integer, Integer> indexToServiceId = new HashMap<Integer, Integer>();
    Map<Integer, Integer> serviceIdToIndex = new HashMap<Integer, Integer>();
    Map<Integer, SbiDomain> idToDomain = new HashMap<Integer, SbiDomain>();
    Map<Integer, Integer> indexToDomainId = new HashMap<Integer, Integer>();
    Map<Integer, Integer> domainIdToIndex = new HashMap<Integer, Integer>();
    Map<Integer, SbiThreshold> idToThreshold = new HashMap<Integer, SbiThreshold>();
    Map<Integer, Integer> indexToThresholdId = new HashMap<Integer, Integer>();
    Map<Integer, Integer> thresholdIdToIndex = new HashMap<Integer, Integer>();
    private boolean inserting = true;
    public static final int tabIndex = 0;
    private static Logger logger = LoggerFactory.getLogger(RuleDetailTabItem.class);

    public RuleDetailTabItem(CTabFolder parent, int style, RulesDetailComposite alComposite) {
        super(parent, style);
        this.rulesDetailComposite = alComposite;
    }

    public void drawComp(CTabFolder folder) throws WizardException {
        logger.debug("IN");
        Composite detailComposite = new Composite((Composite)folder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        detailComposite.setLayout((Layout)gridLayout);
        GridData gridName = SWTUtils.setGridLayoutData(768, 3);
        SWTUtils.drawLabel(detailComposite, "Type", 0, null);
        this.typeCombo = SWTUtils.drawCombo(detailComposite, 2048, gridName);
        SWTUtils.drawLabel(detailComposite, "Service", 0, null);
        this.serviceCombo = SWTUtils.drawCombo(detailComposite, 2048, gridName);
        SWTUtils.drawLabel(detailComposite, "Threshold", 0, null);
        this.thresholdCombo = SWTUtils.drawCombo(detailComposite, 2048, gridName);
        GridData grid = new GridData(1808);
        grid.horizontalSpan = 3;
        SWTUtils.drawLabel(detailComposite, "Expression Schema", 0, null);
        this.expressionText = SWTUtils.drawStyledText(detailComposite, 2818, grid);
        logger.debug("widgets for tabItem created");
        List<Service> serviceList = this.retrieveServices();
        int j = 0;
        for (Service service : serviceList) {
            logger.debug("service " + service.getName() + " retrieved");
            this.serviceCombo.add(service.getName(), j);
            this.indexToServiceId.put(j, service.getIdService());
            this.idToService.put(service.getIdService(), service);
            this.serviceIdToIndex.put(service.getIdService(), j);
            this.serviceNameToServiceId.put(service.getName(), service.getIdService());
            ++j;
        }
        this.serviceCombo.select(0);
        this.serviceCombo.redraw();
        List<SbiDomain> sbiDomainList = this.retrieveSbiDomains();
        int i = 0;
        for (SbiDomain sbiDomain : sbiDomainList) {
            logger.debug("domain " + sbiDomain.getValueNm() + " retrieved");
            this.typeCombo.add(sbiDomain.getValueCd(), i);
            this.domainIdToIndex.put(sbiDomain.getValueId(), i);
            this.indexToDomainId.put(i, sbiDomain.getValueId());
            this.idToDomain.put(sbiDomain.getValueId(), sbiDomain);
            ++i;
        }
        this.typeCombo.select(0);
        this.typeCombo.redraw();
        List<SbiThreshold> sbiThresholdList = this.retrieveThresholds();
        int z = 0;
        this.thresholdCombo.add("", z);
        ++z;
        for (SbiThreshold sbiThreshold : sbiThresholdList) {
            logger.debug("threshold " + sbiThreshold.getName() + " retrieved");
            this.thresholdCombo.add(sbiThreshold.getName(), z);
            this.thresholdIdToIndex.put(sbiThreshold.getThresholdId(), z);
            this.indexToThresholdId.put(z, sbiThreshold.getThresholdId());
            this.idToThreshold.put(sbiThreshold.getThresholdId(), sbiThreshold);
            ++z;
        }
        this.typeCombo.select(0);
        this.typeCombo.redraw();
        this.setControl((Control)detailComposite);
        logger.debug("OUT");
    }

    public void fillEmptyValues() {
        this.setInserting(true);
        this.expressionText.setText("");
        this.typeCombo.select(-1);
        this.serviceCombo.select(-1);
        this.thresholdCombo.select(0);
    }

    public void fillRuleValues(Rule rule) throws WizardException {
        logger.debug("IN");
        String expression = rule.getExpression() != null ? rule.getExpression() : "";
        this.expressionText.setText(expression);
        try {
            Service service;
            String nameService;
            Integer id;
            SbiThreshold threshold;
            SbiDomain typeDomain = rule.getSbiDomain();
            if (typeDomain != null) {
                Integer domainIndexToSelect = this.domainIdToIndex.get(typeDomain.getValueId());
                this.typeCombo.select(domainIndexToSelect.intValue());
            }
            if ((threshold = rule.getThreshold()) != null) {
                Integer thIndexToSelect = this.thresholdIdToIndex.get(threshold.getThresholdId());
                this.thresholdCombo.select(thIndexToSelect.intValue());
            }
            if ((id = this.serviceNameToServiceId.get(nameService = rule.getService())) != null && (service = new ServiceTransactions().getServiceByName(nameService)) != null) {
                Integer serviceIndexToSelect = this.serviceIdToIndex.get(id);
                this.serviceCombo.select(serviceIndexToSelect.intValue());
            }
        }
        catch (Exception e) {
            logger.error("Error in filling with details of  selected rule the detail tab ", (Throwable)e);
            throw new WizardException(e, "Error in filling with details of selected rule the detail tab");
        }
        logger.debug("OUT");
    }

    public void recoverSavingInformations(Rule rule) throws WizardException {
        Integer indexThreshold;
        Integer thresholdId;
        logger.debug("IN");
        String expression = this.expressionText.getText();
        rule.setExpression(expression);
        Integer indexService = this.serviceCombo.getSelectionIndex();
        Integer serviceId = this.indexToServiceId.get(indexService);
        if (serviceId != null) {
            Service service = this.idToService.get(serviceId);
            rule.setService(service.getName());
        }
        if ((thresholdId = this.indexToThresholdId.get(indexThreshold = Integer.valueOf(this.thresholdCombo.getSelectionIndex()))) != null) {
            SbiThreshold threshold = this.idToThreshold.get(thresholdId);
            rule.setThreshold(threshold);
        } else {
            rule.setThreshold(null);
        }
        Integer indexDomain = this.typeCombo.getSelectionIndex();
        Integer domainId = this.indexToDomainId.get(indexDomain);
        if (domainId != null) {
            SbiDomain domain = this.idToDomain.get(domainId);
            rule.setSbiDomain(domain);
        }
        logger.debug("OUT");
    }

    public void disableFields() {
        this.expressionText.setEnabled(false);
        this.typeCombo.setEnabled(false);
        this.serviceCombo.setEnabled(false);
        this.thresholdCombo.setEnabled(false);
    }

    public void enableFields(boolean insert) {
        this.expressionText.setEnabled(true);
        this.typeCombo.setEnabled(true);
        this.serviceCombo.setEnabled(true);
        this.thresholdCombo.setEnabled(true);
    }

    public RulesDetailComposite getRulesDetailComposite() {
        return this.rulesDetailComposite;
    }

    public void setRulesDetailComposite(RulesDetailComposite rulesDetailComposite) {
        this.rulesDetailComposite = rulesDetailComposite;
    }

    public boolean isInserting() {
        return this.inserting;
    }

    public void setInserting(boolean inserting) {
        this.inserting = inserting;
    }

    private List<Service> retrieveServices() throws WizardException {
        List services = null;
        try {
            services = new ServiceTransactions().getServiceList();
        }
        catch (Exception e) {
            logger.error("error in retrieving services list", (Throwable)e);
            throw new WizardException(e, "Error in retrieving services list");
        }
        return services;
    }

    private List<SbiThreshold> retrieveThresholds() throws WizardException {
        List thresholds = null;
        try {
            thresholds = new SbiThresholdTransactions().getSbiThresholdList();
        }
        catch (Exception e) {
            logger.error("error in retrieving threshold list", (Throwable)e);
            throw new WizardException(e, "error in retrieving threshold list");
        }
        return thresholds;
    }

    private List<SbiDomain> retrieveSbiDomains() throws WizardException {
        List sbiDomains = null;
        try {
            sbiDomains = new SbiDomainTransactions().getDomainByDomainCd("RULE_TYPE");
        }
        catch (Exception e) {
            logger.error("error in retrieving type domains list", (Throwable)e);
            throw new WizardException(e, "error in retrieving type domains list");
        }
        return sbiDomains;
    }
}

