/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.rulewidgets.detailtabs;

import java.util.List;
import org.eclipse.ebam.designers.exception.WizardException;
import org.eclipse.ebam.designers.swtutils.ImageDescriptors;
import org.eclipse.ebam.designers.swtutils.SWTUtils;
import org.eclipse.ebam.designers.wizards.pages.rulewidgets.RuleWizardPage;
import org.eclipse.ebam.designers.wizards.pages.rulewidgets.RulesDetailComposite;
import org.eclipse.ebam.designers.wizards.pages.rulewidgets.detailtabs.RuleEventTabFunctions;
import org.eclipse.ebam.designers.wizards.pages.thresholdwidgets.ThresholdsDetailComposite;
import org.eclipse.ebam.emf.EbamEventTransactions;
import org.eclipse.ebam.model.entities.Rule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEventTabItem
extends CTabItem {
    private RulesDetailComposite ruleDetailComposite;
    private Table ruleEventTable = null;
    public static final int NAME = 0;
    public static final int EXPRESSION = 1;
    public final RuleEventTabFunctions functions;
    private Text nameText;
    private StyledText expressionText;
    private Text classText;
    private Button persistButton;
    Button buttonAdd;
    Button buttonSaveValue;
    Button buttonErase;
    public static final int tabIndex = 1;
    private static Logger logger = LoggerFactory.getLogger(RuleEventTabItem.class);

    public RuleEventTabItem(CTabFolder parent, int style, RulesDetailComposite alComposite) {
        super(parent, style);
        this.ruleDetailComposite = alComposite;
        this.functions = new RuleEventTabFunctions(this);
    }

    public void drawComp(CTabFolder folder) throws WizardException {
        logger.debug("IN");
        Composite detailComposite = new Composite((Composite)folder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        detailComposite.setLayout((Layout)gridLayout);
        GridData gridDataTableLayout = new GridData(1024);
        gridDataTableLayout.horizontalSpan = 3;
        detailComposite.setLayoutData((Object)gridDataTableLayout);
        Label titleLabel = new Label(detailComposite, 1);
        titleLabel.setText(" Event List: ");
        Color color = new Color((Device)detailComposite.getShell().getDisplay(), new RGB(0, 0, 255));
        titleLabel.setForeground(color);
        GridData gTitleName = new GridData(64);
        gTitleName.horizontalSpan = 3;
        titleLabel.setLayoutData((Object)gTitleName);
        this.ruleEventTable = new Table(detailComposite, 68132);
        this.ruleEventTable.setLinesVisible(true);
        this.ruleEventTable.setHeaderVisible(true);
        GridData g = new GridData(1808);
        g.horizontalSpan = 3;
        this.ruleEventTable.setLayoutData((Object)g);
        String[] titles = new String[]{"                 Name                ", "                    Expression                  "};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.ruleEventTable, 0);
            column.setText(titles[i]);
            ++i;
        }
        i = 0;
        while (i < titles.length) {
            this.ruleEventTable.getColumn(i).pack();
            ++i;
        }
        this.ruleEventTable.redraw();
        this.ruleEventTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    TableItem tableItem = (TableItem)event.item;
                    logger.debug("selected event item with id " + tableItem.getData());
                    Integer indexS = RuleEventTabItem.this.ruleEventTable.indexOf(tableItem);
                    RuleEventTabItem.this.ruleEventTable.setSelection(indexS.intValue());
                    RuleEventTabItem.this.ruleDetailComposite.getStatusLabel().setText(RulesDetailComposite.MODIFYING_ATT);
                    RuleEventTabItem.this.functions.addRuleEventSelection(tableItem);
                    RuleEventTabItem.this.functions.enableRuleEventDetail(tableItem);
                }
                catch (Exception exception) {
                    logger.error("database connection exception");
                    MessageDialog.openError((Shell)RuleEventTabItem.this.ruleEventTable.getShell(), (String)"Error", (String)"Error in preparing page for selected Event");
                }
            }
        });
        this.buttonAdd = new Button(detailComposite, 8);
        this.buttonAdd.setToolTipText("Add an Event");
        this.buttonAdd.setLayoutData((Object)new GridData(512));
        Image addImage = ImageDescriptors.getAddIcon().createImage();
        this.buttonAdd.setImage(addImage);
        this.buttonAdd.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                logger.debug("Add a new Event putton pushed");
                Integer id = RuleEventTabItem.this.getSelectedRuleId();
                RuleEventTabItem.this.ruleDetailComposite.getStatusLabel().setText(RulesDetailComposite.INSERTING_ATT);
                try {
                    RuleEventTabItem.this.functions.addAddButtonPush(id);
                    RuleEventTabItem.this.functions.enableRuleEventDetail(null);
                }
                catch (Exception e) {
                    new WizardException(e, "error while saving new Event");
                }
            }
        });
        this.buttonErase = new Button(detailComposite, 8);
        this.buttonErase.setToolTipText("Erase selected Event");
        this.buttonErase.setLayoutData((Object)new GridData(512));
        Image eraseImage = ImageDescriptors.getEraseIcon().createImage();
        this.buttonErase.setImage(eraseImage);
        this.buttonErase.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    logger.debug("Erase Event putton pushed");
                    RuleEventTabItem.this.ruleDetailComposite.getStatusLabel().setText(ThresholdsDetailComposite.EMPTY);
                    RuleEventTabItem.this.functions.eraseRuleEventPush();
                }
                catch (WizardException wizardException) {
                    logger.error("database exception in erasing the event");
                    MessageDialog.openError((Shell)RuleEventTabItem.this.buttonErase.getShell(), (String)"Erase", (String)"Cannot erase the event; check it is not associated to an alarm o to a rule.");
                }
            }
        });
        this.buttonErase.setEnabled(false);
        this.buttonSaveValue = new Button(detailComposite, 8);
        this.buttonSaveValue.setToolTipText("Save new Value");
        this.buttonSaveValue.setLayoutData((Object)new GridData(512));
        Image saveImage = ImageDescriptors.getSaveIcon().createImage();
        this.buttonSaveValue.setImage(saveImage);
        this.buttonSaveValue.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                logger.debug("Save Event putton pushed");
                Integer ruleId = RuleEventTabItem.this.getSelectedRuleId();
                try {
                    RuleEventTabItem.this.functions.saveValueButtonPush(ruleId);
                    RuleEventTabItem.this.functions.disableRuleEventDetail();
                    RuleEventTabItem.this.functions.fillEmptyValues(false);
                    RuleEventTabItem.this.functions.handleEventButtons(true, false, false);
                    RuleEventTabItem.this.ruleDetailComposite.getStatusLabel().setText(ThresholdsDetailComposite.EMPTY);
                }
                catch (Exception e) {
                    logger.error("error while saving new Event: exception track", (Throwable)e);
                    new WizardException(e, "error while saving new Event");
                }
            }
        });
        this.buttonSaveValue.setVisible(false);
        GridData labelLabel = SWTUtils.setGridLayoutData(768, 1);
        GridData gridLabel = SWTUtils.setGridLayoutData(768, 1);
        Composite detEventComposite = new Composite(detailComposite, 0);
        GridLayout gridLayoutDet = new GridLayout();
        gridLayoutDet.numColumns = 2;
        detEventComposite.setLayout((Layout)gridLayoutDet);
        GridData gridDataDet = new GridData(1808);
        gridDataDet.horizontalSpan = 3;
        detEventComposite.setLayoutData((Object)gridDataDet);
        SWTUtils.drawLabel(detEventComposite, "Label", 0, labelLabel);
        this.nameText = SWTUtils.drawText(detEventComposite, 2048, gridLabel);
        SWTUtils.drawLabel(detEventComposite, "Handler Class", 0, labelLabel);
        this.classText = SWTUtils.drawText(detEventComposite, 2048, gridLabel);
        SWTUtils.drawLabel(detEventComposite, "Persist", 0, labelLabel);
        this.persistButton = SWTUtils.drawButton(detEventComposite, 32, "Persist", gridLabel);
        GridData multi = new GridData(1808);
        SWTUtils.drawLabel(detEventComposite, "Expression", 0, labelLabel);
        this.expressionText = SWTUtils.drawStyledText(detEventComposite, 2562, multi);
        this.functions.disableRuleEventDetail();
        this.setControl((Control)detailComposite);
        logger.debug("OUT");
    }

    public void fillEmptyValues(boolean removeChecked) {
        this.functions.fillEmptyValues(removeChecked);
    }

    public void recoverSavingInformations(Rule rule) throws Exception {
        logger.debug("IN");
        TableItem checkedItem = null;
        TableItem[] items = this.ruleEventTable.getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length && checkedItem == null) {
                TableItem item = items[i];
                if (item.getChecked()) {
                    checkedItem = item;
                }
                ++i;
            }
        }
        if (checkedItem == null) {
            logger.debug("no item is checked");
            rule.setEvent(null);
        } else {
            Double doubleId = (Double)checkedItem.getData();
            logger.debug("checked event item with id " + doubleId);
            org.eclipse.ebam.model.entities.Event event = new EbamEventTransactions().getEbamEventById(Integer.valueOf(doubleId.intValue()));
            rule.setEvent(event);
        }
        logger.debug("OUT");
    }

    public void fillRuleEvent(Rule rule) throws Exception {
        logger.debug("IN");
        List events = new EbamEventTransactions().getEbamEventList();
        Double selectedEvent = null;
        selectedEvent = rule.getEvent() != null ? Double.valueOf(rule.getEvent().getEventId()) : null;
        this.ruleEventTable.removeAll();
        for (org.eclipse.ebam.model.entities.Event ruleEvent : events) {
            TableItem item = new TableItem(this.ruleEventTable, 0);
            item.setText(0, ruleEvent.getName());
            item.setText(1, ruleEvent.getExpression() != null ? ruleEvent.getExpression() : "");
            item.setData((Object)ruleEvent.getEventId());
            if (selectedEvent != null && ruleEvent.getEventId() == selectedEvent.doubleValue()) {
                item.setChecked(true);
                continue;
            }
            item.setChecked(false);
        }
        this.ruleEventTable.setSelection(-1);
        this.buttonErase.setEnabled(false);
        this.functions.disableRuleEventDetail();
        logger.debug("OUT");
    }

    public void disableItems() {
        this.ruleEventTable.setEnabled(false);
        this.functions.handleEventButtons(false, false, false);
        this.functions.disableRuleEventDetail();
    }

    public void enableItems() {
        this.ruleEventTable.setEnabled(true);
        this.functions.handleEventButtons(true, false, false);
    }

    public Button getButtonAdd() {
        return this.buttonAdd;
    }

    public void setButtonAdd(Button buttonAdd) {
        this.buttonAdd = buttonAdd;
    }

    public Button getButtonSaveValue() {
        return this.buttonSaveValue;
    }

    public void setButtonSaveValue(Button buttonSaveValue) {
        this.buttonSaveValue = buttonSaveValue;
    }

    public Button getButtonErase() {
        return this.buttonErase;
    }

    public void setButtonErase(Button buttonErase) {
        this.buttonErase = buttonErase;
    }

    public RuleEventTabFunctions getFunctions() {
        return this.functions;
    }

    public Integer getSelectedRuleId() {
        RuleWizardPage ruleWizardPage = this.ruleDetailComposite.getRuleWizardPage();
        Table ruleTable = ruleWizardPage.getListComposite().getRulesTable();
        Integer index = ruleTable.getSelectionIndex();
        TableItem item = ruleTable.getItem(index.intValue());
        Integer id = (Integer)item.getData();
        return id;
    }

    public Text getClassText() {
        return this.classText;
    }

    public void setClassText(Text classText) {
        this.classText = classText;
    }

    public Button getPersistButton() {
        return this.persistButton;
    }

    public void setPersistButton(Button persistButton) {
        this.persistButton = persistButton;
    }

    public Table getRuleEventTable() {
        return this.ruleEventTable;
    }

    public void setRuleEventTable(Table ruleEventTable) {
        this.ruleEventTable = ruleEventTable;
    }

    public Text getNameText() {
        return this.nameText;
    }

    public void setNameText(Text nameText) {
        this.nameText = nameText;
    }

    public StyledText getExpressionText() {
        return this.expressionText;
    }

    public void setExpressionText(StyledText expressionText) {
        this.expressionText = expressionText;
    }
}

