/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.servicewidgets;

import org.eclipse.ebam.designers.exception.WizardException;
import org.eclipse.ebam.designers.swtutils.ColorConstants;
import org.eclipse.ebam.designers.swtutils.ImageDescriptors;
import org.eclipse.ebam.designers.wizards.pages.servicewidgets.ServiceWizardPage;
import org.eclipse.ebam.designers.wizards.pages.servicewidgets.detailtabs.ServiceDetailTabItem;
import org.eclipse.ebam.emf.ServiceTransactions;
import org.eclipse.ebam.model.entities.Service;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesDetailComposite
extends Composite {
    private ServiceWizardPage serviceWizardPage = null;
    private ServiceDetailTabItem detailTabItem = null;
    private Button buttonSave;
    private CTabFolder tabFolder = null;
    private Label statusLabel = null;
    public static String INSERTING = "INSERT A NEW SERVICE";
    public static String MODIFYING = "MODIFY SELECTED SERVICE";
    public static String EMPTY = "                                                       ";
    private static Logger logger = LoggerFactory.getLogger(ServicesDetailComposite.class);

    public ServicesDetailComposite(Composite parent, int style, ServiceWizardPage serviceWizardPage1) {
        super(parent, style);
        this.serviceWizardPage = serviceWizardPage1;
    }

    public void drawComp() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.statusLabel = new Label((Composite)this, 0);
        this.statusLabel.setForeground(new Color((Device)this.getDisplay(), ColorConstants.statusLabelColor));
        this.statusLabel.setText(EMPTY);
        this.statusLabel.setLayoutData((Object)new GridData(64));
        this.buttonSave = new Button((Composite)this, 8);
        this.buttonSave.setToolTipText("Save service details");
        this.buttonSave.setLayoutData((Object)new GridData(128));
        Image saveImage = ImageDescriptors.getSaveIcon().createImage();
        this.buttonSave.setImage(saveImage);
        this.buttonSave.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    ServicesDetailComposite.this.saveButtonPush();
                    ServicesDetailComposite.this.statusLabel.setText(EMPTY);
                }
                catch (WizardException e) {
                    logger.error("database connection exception");
                    MessageDialog.openError((Shell)ServicesDetailComposite.this.getShell(), (String)"Error", (String)("Error in saving service: " + e.getMessage()));
                }
            }
        });
        this.buttonSave.setEnabled(false);
        try {
            this.tabFolder = new CTabFolder((Composite)this, 2048);
            this.tabFolder.setLayoutData((Object)new GridData(1808));
            this.tabFolder.setEnabled(false);
            this.detailTabItem = new ServiceDetailTabItem(this.tabFolder, 0, this);
            this.detailTabItem.setText("Detail");
            this.detailTabItem.drawComp(this.tabFolder);
        }
        catch (Exception exception) {
            logger.error("could not create Service wizard");
            return;
        }
    }

    private void saveButtonPush() throws WizardException {
        logger.debug("IN");
        Table servicesTable = this.getServiceWizardPage().getListComposite().getServicesTable();
        int index = servicesTable.getSelectionIndex();
        Service service = null;
        if (index == -1) {
            service = new Service();
        } else {
            TableItem item = servicesTable.getItem(index);
            String name = item.getText(0);
            Integer id = (Integer)item.getData();
            try {
                service = new ServiceTransactions().getServiceById(id);
            }
            catch (Exception e) {
                logger.error("error in getting Service with name " + name + " and ID " + id, (Throwable)e);
                throw new WizardException(e, "error in getting Service with name " + name + " and ID " + id);
            }
        }
        ServiceDetailTabItem serviceDetailTabItem = (ServiceDetailTabItem)this.tabFolder.getItem(0);
        serviceDetailTabItem.recoverSavingInformations(service);
        serviceDetailTabItem.disableFields();
        ServiceTransactions sbiS = new ServiceTransactions();
        new ServiceTransactions();
        try {
            if (index == -1) {
                sbiS.createNewService(service);
                TableItem tableItem = new TableItem(servicesTable, 0);
                tableItem.setText(0, service.getName());
                Integer idInserted = service.getIdService();
                tableItem.setData((Object)idInserted);
            } else {
                sbiS.mergeService(service);
                TableItem item = servicesTable.getItem(index);
                item.setText(0, service.getName());
            }
        }
        catch (Exception e1) {
            logger.error("Error in inserting o updating service ", (Throwable)e1);
            throw new WizardException(e1, "Error in inserting or updating service");
        }
        servicesTable.redraw();
        servicesTable.setSelection(-1);
        this.tabFolder.setEnabled(false);
        this.buttonSave.setEnabled(false);
        logger.debug("OUT");
    }

    public ServiceWizardPage getServiceWizardPage() {
        return this.serviceWizardPage;
    }

    public void setServiceWizardPage(ServiceWizardPage serviceWizardPage) {
        this.serviceWizardPage = serviceWizardPage;
    }

    public ServiceDetailTabItem getDetailTabItem() {
        return this.detailTabItem;
    }

    public void setDetailTabItem(ServiceDetailTabItem detailTabItem) {
        this.detailTabItem = detailTabItem;
    }

    public Button getButtonSave() {
        return this.buttonSave;
    }

    public void setButtonSave(Button buttonSave) {
        this.buttonSave = buttonSave;
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public void setTabFolder(CTabFolder tabFolder) {
        this.tabFolder = tabFolder;
    }

    public Label getStatusLabel() {
        return this.statusLabel;
    }

    public void setStatusLabel(Label statusLabel) {
        this.statusLabel = statusLabel;
    }
}

