/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.DesignElementHandleAdapter;
import org.eclipse.birt.report.designer.core.model.IModelAdapterHelper;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;

public class ReportDesignHandleAdapter
extends DesignElementHandleAdapter {
    public ReportDesignHandleAdapter(ModuleHandle handle) {
        this(handle, null);
    }

    public ReportDesignHandleAdapter(ModuleHandle handle, IModelAdapterHelper mark) {
        super((DesignElementHandle)handle, mark);
    }

    public List getChildren() {
        return this.getReportDesignHandle().getBody().getContents();
    }

    public List getDataSources() {
        return this.getModuleHandle().getVisibleDataSources();
    }

    public DataSourceHandle getDataSourceHandle(String name) {
        return this.getModuleHandle().findDataSource(name);
    }

    public boolean checkDataSourceName(String name) {
        return this.getModuleHandle().findDataSource(name) != null;
    }

    public boolean checkDataSetName(String name) {
        return this.getModuleHandle().findDataSet(name) != null;
    }

    public void setReportDesignHandle(ModuleHandle handle) {
        this.setElementHandle((DesignElementHandle)handle);
    }

    public MasterPageHandle getMasterPage() {
        return this.getMasterPage(0);
    }

    public MasterPageHandle getMasterPage(int pos) {
        SlotHandle masterPages = this.getModuleHandle().getMasterPages();
        MasterPageHandle masterPage = (MasterPageHandle)masterPages.get(pos);
        return masterPage;
    }

    public Dimension getMasterPageSize(DesignElementHandle handle) {
        int height;
        int width;
        MasterPageHandle masterPage = (MasterPageHandle)handle;
        Dimension size = null;
        if (masterPage == null || masterPage.getPageType().equalsIgnoreCase("us-letter")) {
            size = new Dimension(MetricUtility.inchToPixel((double)8.5, (double)11.0).x, MetricUtility.inchToPixel((double)8.5, (double)11.0).y);
        } else if (masterPage.getPageType().equalsIgnoreCase("us-legal")) {
            size = new Dimension(MetricUtility.inchToPixel((double)8.5, (double)14.0).x, MetricUtility.inchToPixel((double)8.5, (double)14.0).y);
        } else if (masterPage.getPageType().equalsIgnoreCase("a4")) {
            size = new Dimension(MetricUtility.inchToPixel((double)8.3, (double)11.7).x, MetricUtility.inchToPixel((double)8.3, (double)11.7).y);
        } else if (masterPage.getPageType().equalsIgnoreCase("custom")) {
            width = (int)DEUtil.convertoToPixel(masterPage.getWidth());
            height = (int)DEUtil.convertoToPixel(masterPage.getHeight());
            size = new Dimension(width, height);
        }
        if ("landscape".equalsIgnoreCase(masterPage.getOrientation())) {
            width = (int)DEUtil.convertoToPixel(masterPage.getWidth());
            height = (int)DEUtil.convertoToPixel(masterPage.getHeight());
            size = new Dimension(width, height);
        }
        return size;
    }

    public Insets getMasterPageInsets(DesignElementHandle handle) {
        MasterPageHandle masterPage = (MasterPageHandle)handle;
        return new Insets((int)DEUtil.convertoToPixel(masterPage.getTopMargin()), (int)DEUtil.convertoToPixel(masterPage.getLeftMargin()), (int)DEUtil.convertoToPixel(masterPage.getBottomMargin()), (int)DEUtil.convertoToPixel(masterPage.getRightMargin()));
    }
}

