/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.shells;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.eclipse.rse.internal.services.shells.TerminalServiceShellOutputReader;
import org.eclipse.rse.internal.services.shells.TerminalServiceShellWriterThread;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.shells.AbstractHostShell;
import org.eclipse.rse.services.shells.IHostShellOutputReader;
import org.eclipse.rse.services.terminals.ITerminalShell;

public class TerminalServiceHostShell
extends AbstractHostShell {
    public static final String SHELL_INVOCATION = ">";
    ITerminalShell fTerminalShell;
    private TerminalServiceShellOutputReader fStdoutHandler;
    private TerminalServiceShellOutputReader fStderrHandler;
    private TerminalServiceShellWriterThread fShellWriter;
    private static final Pattern cdCommands = Pattern.compile("\\A\\s*(cd|chdir|ls)\\b");

    public TerminalServiceHostShell(ITerminalShell terminalShell, String initialWorkingDirectory, String commandToRun, String[] environment) {
        block10: {
            try {
                this.fTerminalShell = terminalShell;
                String encoding = this.fTerminalShell.getDefaultEncoding();
                this.fStdoutHandler = encoding != null ? new TerminalServiceShellOutputReader(this, new BufferedReader(new InputStreamReader(this.fTerminalShell.getInputStream(), encoding)), false) : new TerminalServiceShellOutputReader(this, new BufferedReader(new InputStreamReader(this.fTerminalShell.getInputStream())), false);
                this.fStderrHandler = new TerminalServiceShellOutputReader(this, null, true);
                OutputStream outputStream = this.fTerminalShell.getOutputStream();
                if (encoding != null) {
                    Charset cs = Charset.forName(encoding);
                    PrintWriter outputWriter = new PrintWriter(new OutputStreamWriter(outputStream, cs));
                    this.fShellWriter = new TerminalServiceShellWriterThread(outputWriter);
                } else {
                    PrintWriter outputWriter = new PrintWriter(outputStream);
                    this.fShellWriter = new TerminalServiceShellWriterThread(outputWriter);
                }
                if (initialWorkingDirectory != null && initialWorkingDirectory.length() > 0 && !initialWorkingDirectory.equals(".") && !initialWorkingDirectory.equals("Command Shell")) {
                    this.writeToShell("cd " + PathUtility.enQuoteUnix(initialWorkingDirectory));
                }
                if (SHELL_INVOCATION.equals(commandToRun)) {
                    this.writeToShell(this.getPromptCommand());
                } else if (commandToRun != null && commandToRun.length() > 0) {
                    this.writeToShell(commandToRun);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.fShellWriter != null) {
                    this.fShellWriter.stopThread();
                    this.fShellWriter = null;
                }
                if (this.fStderrHandler != null) {
                    this.fStderrHandler.interrupt();
                    this.fStderrHandler = null;
                }
                if (this.fStdoutHandler == null) break block10;
                this.fStdoutHandler.interrupt();
                this.fStdoutHandler = null;
            }
        }
    }

    public void exit() {
        if (this.fShellWriter != null) {
            this.fShellWriter.stopThread();
        }
        this.fTerminalShell.exit();
    }

    public IHostShellOutputReader getStandardErrorReader() {
        return this.fStderrHandler;
    }

    public IHostShellOutputReader getStandardOutputReader() {
        return this.fStdoutHandler;
    }

    public boolean isActive() {
        return this.fTerminalShell.isActive();
    }

    public void writeToShell(String command) {
        if (this.isActive()) {
            if ("#break".equals(command)) {
                command = "\u0003";
            } else if (cdCommands.matcher(command).find()) {
                command = String.valueOf(command) + "\r\n" + this.getPromptCommand();
            }
            if (!this.fShellWriter.sendCommand(command)) {
                this.exit();
                this.isActive();
            }
        }
    }

    public String getPromptCommand() {
        return "echo $PWD'>'";
    }
}

