/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.reportitem.ChartBaseQueryHelper;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartSharingQueryHelper
extends ChartBaseQueryHelper {
    public ChartSharingQueryHelper(ReportItemHandle handle, Chart cm, IModelAdapter modelAdapter) {
        super(handle, cm, modelAdapter);
    }

    public ChartSharingQueryHelper(ReportItemHandle handle, Chart cm, IModelAdapter modelAdapter, boolean bCreateBindingForExpression) {
        super(handle, cm, modelAdapter, bCreateBindingForExpression);
    }

    public IDataQueryDefinition createQuery(IDataQueryDefinition parent) throws BirtException {
        return this.createBaseQuery(parent);
    }

    @Override
    protected void generateExtraBindings(BaseQueryDefinition query) throws ChartException {
        List sdList = ChartUtil.getAllOrthogonalSeriesDefinitions((Chart)this.fChartModel);
        sdList.addAll(ChartUtil.getBaseSeriesDefinitions((Chart)this.fChartModel));
        ChartExpressionUtil.ExpressionSet exprSet = new ChartExpressionUtil.ExpressionSet();
        int i = 0;
        while (i < sdList.size()) {
            Iterator sd = (SeriesDefinition)sdList.get(i);
            EList queryList = sd.getDesignTimeSeries().getDataDefinition();
            int j = 0;
            while (j < queryList.size()) {
                exprSet.add(((Query)queryList.get(j)).getDefinition());
                ++j;
            }
            exprSet.add(sd.getQuery().getDefinition());
            ++i;
        }
        for (String expr : exprSet) {
            this.exprCodec.decode(expr);
            if (this.exprCodec.isRowBinding(false)) continue;
            String bindingName = ChartExpressionUtil.escapeSpecialCharacters((String)this.exprCodec.getExpression());
            Binding colBinding = new Binding(bindingName);
            colBinding.setDataType(0);
            colBinding.setExpression((IBaseExpression)ChartReportItemUtil.adaptExpression(this.exprCodec, this.modelAdapter, false));
            try {
                query.addBinding((IBinding)colBinding);
            }
            catch (DataException e) {
                throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e);
            }
        }
        List<GroupHandle> groups = this.getGroups();
        Iterator<GroupHandle> iter = groups.iterator();
        while (iter.hasNext()) {
            ChartSharingQueryHelper.handleGroup(iter.next(), (IBaseQueryDefinition)query, this.modelAdapter);
        }
        if (ChartReportItemUtil.isChartInheritGroups(this.fReportItemHandle)) {
            ListingHandle table = null;
            DesignElementHandle container = this.fReportItemHandle.getContainer();
            while (container != null) {
                if (container instanceof ListingHandle) {
                    table = (ListingHandle)container;
                    break;
                }
                container = container.getContainer();
            }
            if (table != null) {
                Iterator iterator = table.columnBindingsIterator();
                while (iterator.hasNext()) {
                    ComputedColumnHandle binding = (ComputedColumnHandle)iterator.next();
                    if (binding.getAggregateFunction() == null) continue;
                    try {
                        query.addBinding(this.modelAdapter.adaptBinding(binding));
                    }
                    catch (BirtException e) {
                        throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e);
                    }
                }
            }
        }
    }

    private List<GroupHandle> getGroups() {
        ArrayList<GroupHandle> groupList = new ArrayList<GroupHandle>();
        ListingHandle table = null;
        if (this.fReportItemHandle instanceof ListingHandle) {
            table = (ListingHandle)this.fReportItemHandle;
        } else if (ChartReportItemUtil.isChartInheritGroups(this.fReportItemHandle)) {
            DesignElementHandle container = this.fReportItemHandle.getContainer();
            while (container != null) {
                if (container instanceof ListingHandle) {
                    table = (ListingHandle)container;
                    break;
                }
                container = container.getContainer();
            }
        }
        if (table != null) {
            SlotHandle groups = table.getGroups();
            Iterator iter = groups.iterator();
            while (iter.hasNext()) {
                groupList.add((GroupHandle)iter.next());
            }
        }
        return groupList;
    }

    @Override
    protected void addSortAndFilter(ReportItemHandle handle, BaseQueryDefinition query) {
        super.addSortAndFilter(handle, query);
        if (handle instanceof ListingHandle) {
            query.getSorts().addAll(ChartSharingQueryHelper.createSorts(((ListingHandle)handle).sortsIterator(), this.modelAdapter));
        }
    }
}

